/*
DO NOT EDIT!

This file is autogenerated by astropy/wcs/setup_package.py.  To edit
its contents, edit astropy/wcs/docstrings.py

The weirdness here with strncpy is because some C compilers, notably
MSVC, do not support string literals greater than 256 characters.
*/

#include <string.h>
#include "docstrings.h"

#if defined(_MSC_VER)
char doc_DistortionLookupTable[374];
char doc_K[202];
char doc_M[56];
char doc_Sip[1040];
char doc_Tabprm[234];
char doc_UnitConverter[2246];
char doc_Wcs[513];
char doc_Wcsprm[2089];
char doc_Wtbarr[202];
char doc_a[264];
char doc_a_order[60];
char doc_all_pix2world[1268];
char doc_alt[236];
char doc_ap[276];
char doc_ap_order[61];
char doc_axis_types[916];
char doc_b[273];
char doc_b_order[60];
char doc_bp[276];
char doc_bp_order[61];
char doc_cd[1074];
char doc_cdelt[308];
char doc_cdfix[480];
char doc_cel_offset[176];
char doc_celfix[171];
char doc_cname[76];
char doc_colax[91];
char doc_colnum[290];
char doc_convert[121];
char doc_coord[290];
char doc_copy[40];
char doc_cpdis1[106];
char doc_cpdis2[106];
char doc_crder[123];
char doc_crota[1070];
char doc_crpix[88];
char doc_crval[93];
char doc_crval_tabprm[94];
char doc_csyer[132];
char doc_ctype[228];
char doc_cubeface[1236];
char doc_cunit[1272];
char doc_cylfix[162];
char doc_data[78];
char doc_data_wtbarr[52];
char doc_dateavg[152];
char doc_dateobs[133];
char doc_datfix[512];
char doc_delta[251];
char doc_det2im[58];
char doc_det2im1[103];
char doc_det2im2[103];
char doc_dims[111];
char doc_equinox[243];
char doc_extlev[73];
char doc_extnam[74];
char doc_extrema[452];
char doc_extver[73];
char doc_find_all_wcs[880];
char doc_fix[1613];
char doc_get_cdelt[452];
char doc_get_offset[206];
char doc_get_pc[391];
char doc_get_ps[433];
char doc_get_pv[716];
char doc_has_cd[911];
char doc_has_cdi_ja[103];
char doc_has_crota[652];
char doc_has_crotaia[107];
char doc_has_pc[213];
char doc_has_pci_ja[103];
char doc_have[175];
char doc_i[41];
char doc_imgpix_matrix[173];
char doc_is_unity[109];
char doc_kind[130];
char doc_lat[86];
char doc_latpole[75];
char doc_lattyp[236];
char doc_lng[87];
char doc_lngtyp[237];
char doc_lonpole[77];
char doc_m[59];
char doc_map[980];
char doc_mix[4806];
char doc_mjdavg[181];
char doc_mjdobs[181];
char doc_name[74];
char doc_naxis[761];
char doc_nc[172];
char doc_ndim[67];
char doc_obsgeo[187];
char doc_offset[47];
char doc_p0[257];
char doc_p2s[2005];
char doc_p4_pix2foc[652];
char doc_pc[1141];
char doc_phi0[289];
char doc_pix2foc[636];
char doc_piximg_matrix[128];
char doc_power[49];
char doc_print_contents[210];
char doc_print_contents_tabprm[224];
char doc_radesys[77];
char doc_restfrq[94];
char doc_restwav[94];
char doc_row[40];
char doc_s2p[1910];
char doc_scale[56];
char doc_sense[245];
char doc_set[1206];
char doc_set_ps[414];
char doc_set_pv[409];
char doc_set_tabprm[325];
char doc_sip[84];
char doc_sip_foc2pix[649];
char doc_sip_pix2foc[649];
char doc_spcfix[272];
char doc_spec[68];
char doc_specsys[145];
char doc_sptr[1373];
char doc_ssysobs[253];
char doc_ssyssrc[150];
char doc_sub[3436];
char doc_tab[112];
char doc_theta0[289];
char doc_to_header[2229];
char doc_ttype[108];
char doc_unitfix[1098];
char doc_velangl[186];
char doc_velosys[316];
char doc_want[173];
char doc_wcs[83];
char doc_zsource[98];

void fill_docstrings(void)
{
   strncpy(doc_DistortionLookupTable + 0, "DistortionLookupTable(*table*, *crpix*, *crval*, *cdelt*)\n\nRepresents a single lookup table for a `Paper IV`_ distortion\ntransformation.\n\nParameters\n----------\ntable : 2-dimensional array\n    The distortion lookup table.\n\ncrpix : 2-tuple\n    The distortion", 256);
   strncpy(doc_DistortionLookupTable + 256, " array reference pixel\n\ncrval : 2-tuple\n    The image array pixel coordinate\n\ncdelt : 2-tuple\n    The grid step size\n\x00", 118);

   strncpy(doc_K + 0, "``int array[M]`` (read-only) The lengths of the axes of the coordinate\narray.\n\nAn array of length `M` whose elements record the lengths of the axes of\nthe coordinate array and of each indexing vector.\n\x00", 202);

   strncpy(doc_M + 0, "``int`` (read-only) Number of tabular coordinate axes.\n\x00", 56);

   strncpy(doc_Sip + 0, "Sip(*a, b, ap, bp, crpix*)\n\nThe `~astropy.wcs.Sip` class performs polynomial distortion correction\nusing the `SIP`_ convention in both directions.\n\nParameters\n----------\na : double array[m+1][m+1]\n    The ``A_i_j`` polynomial for pixel to focal plane trans", 256);
   strncpy(doc_Sip + 256, "formation.\n    Its size must be (*m* + 1, *m* + 1) where *m* = ``A_ORDER``.\n\nb : double array[m+1][m+1]\n    The ``B_i_j`` polynomial for pixel to focal plane transformation.\n    Its size must be (*m* + 1, *m* + 1) where *m* = ``B_ORDER``.\n\nap : double arra", 256);
   strncpy(doc_Sip + 512, "y[m+1][m+1]\n    The ``AP_i_j`` polynomial for pixel to focal plane transformation.\n    Its size must be (*m* + 1, *m* + 1) where *m* = ``AP_ORDER``.\n\nbp : double array[m+1][m+1]\n    The ``BP_i_j`` polynomial for pixel to focal plane transformation.\n    Its", 256);
   strncpy(doc_Sip + 768, " size must be (*m* + 1, *m* + 1) where *m* = ``BP_ORDER``.\n\ncrpix : double array[2]\n    The reference pixel.\n\nNotes\n-----\nShupe, D. L., M. Moshir, J. Li, D. Makovoz and R. Narron.  2005.\n\"The SIP Convention for Representing Distortion in FITS Image\nHeaders", 256);
   strncpy(doc_Sip + 1024, ".\"  ADASS XIV.\n\x00", 16);

   strncpy(doc_Tabprm + 0, "A class to store the information related to tabular coordinates,\ni.e., coordinates that are defined via a lookup table.\n\nThis class can not be constructed directly from Python, but instead is\nreturned from `~astropy.wcs.Wcsprm.tab`.\n\x00", 234);

   strncpy(doc_UnitConverter + 0, "UnitConverter(have, want, translate_units=\'\')\n\nAn object for converting from one system of units to another.\n\nUse the returned object\'s `~astropy.wcs.UnitConverter.convert` method\nto convert values from *have* to *want*.\n\nThis function is permissive in acc", 256);
   strncpy(doc_UnitConverter + 256, "epting whitespace in all contexts in\na units specification where it does not create ambiguity (e.g. not\nbetween a metric prefix and a basic unit string), including in strings\nlike ``\"log (m ** 2)\"`` which is formally disallowed.\n\nParameters\n----------\n\nhav", 256);
   strncpy(doc_UnitConverter + 512, "e : string\n    :ref:`fits-unit` to convert from, with or without surrounding\n    square brackets (for inline specifications); text following the\n    closing bracket is ignored.\n\nwant : string\n    :ref:`fits-unit` to convert to, with or without surrounding ", 256);
   strncpy(doc_UnitConverter + 768, "square\n    brackets (for inline specifications); text following the closing\n    bracket is ignored.\n\nctrl : string, optional\n    Do potentially unsafe translations of non-standard unit strings.\n\n    Although ``\"S\"`` is commonly used to represent seconds, i", 256);
   strncpy(doc_UnitConverter + 1024, "ts\n    recognizes ``\"S\"`` formally as Siemens, however rarely that may\n    be translation to ``\"s\"`` is potentially unsafe since the\n    standard used.  The same applies to ``\"H\"`` for hours (Henry),\n    and ``\"D\"`` for days (Debye).\n\n    This string contr", 256);
   strncpy(doc_UnitConverter + 1280, "ols what to do in such cases, and is\n    case-insensitive.\n\n    - If the string contains ``\"s\"``, translate ``\"S\"`` to ``\"s\"``.\n\n    - If the string contains ``\"h\"``, translate ``\"H\"`` to ``\"h\"``.\n\n    - If the string contains ``\"d\"``, translate ``\"D\"`` to", 256);
   strncpy(doc_UnitConverter + 1536, " ``\"d\"``.\n\n    Thus ``\'\'`` doesn\'t do any unsafe translations, whereas ``\'shd\'``\n    does all of them.\n\n    See :ref:`fits-unit` for more information.\n\nRaises\n------\nValueError\n    Invalid numeric multiplier.\n\nSyntaxError\n    Dangling binary operator.\n\nSyn", 256);
   strncpy(doc_UnitConverter + 1792, "taxError\n    Invalid symbol in INITIAL context.\n\nSyntaxError\n    Function in invalid context.\n\nSyntaxError\n    Invalid symbol in EXPON context.\n\nSyntaxError\n    Unbalanced bracket.\n\nSyntaxError\n    Unbalanced parenthesis.\n\nSyntaxError\n    Consecutive binar", 256);
   strncpy(doc_UnitConverter + 2048, "y operators.\n\nSyntaxError\n    Internal parser error.\n\nSyntaxError\n    Non-conformant unit specifications.\n\nSyntaxError\n    Non-conformant functions.\n\nValueError\n    Potentially unsafe translation.\n\x00", 198);

   strncpy(doc_Wcs + 0, "Wcs(*sip, cpdis, wcsprm, det2im*)\n\nWcs objects amalgamate basic WCS (as provided by `wcslib`_), with\n`SIP`_ and `Paper IV`_ distortion operations.\n\nTo perform all distortion corrections and WCS tranformation, use\n`all_pix2world`.\n\nParameters\n----------\nsip", 256);
   strncpy(doc_Wcs + 256, " : `~astropy.wcs.Sip` object or `None`\n\ncpdis : A pair of `~astropy.wcs.DistortionLookupTable` objects, or\n  ``(None, None)``.\n\nwcsprm : `~astropy.wcs.Wcsprm` object\n\ndet2im : A pair of `~astropy.wcs.DistortionLookupTable` objects, or\n   ``(None, None)``.\n", 256);
   strncpy(doc_Wcs + 512, "\x00", 1);

   strncpy(doc_Wcsprm + 0, "Wcsprm(header=None, key=\' \', relax=False, naxis=2, keysel=0, colsel=None)\n\n`~astropy.wcs.Wcsprm` is a direct wrapper around `wcslib`_, and\nprovides access to the core WCS transformations that it supports.\n\nThe FITS header parsing enforces correct FITS \"key", 256);
   strncpy(doc_Wcsprm + 256, "word = value\" syntax\nwith regard to the equals sign occurring in columns 9 and 10.\nHowever, it does recognize free-format character (NOST 100-2.0,\nSect. 5.2.1), integer (Sect. 5.2.3), and floating-point values\n(Sect. 5.2.4) for all keywords.\n\nParameters\n--", 256);
   strncpy(doc_Wcsprm + 512, "--------\nheader : An astropy.io.fits header, string, or `None`.\n  If ``None``, the object will be initialized to default values.\n\nkey : string, optional\n    The key referring to a particular WCS transform in the header.\n    This may be either ``\' \'`` or ``", 256);
   strncpy(doc_Wcsprm + 768, "\'A\'``-``\'Z\'`` and corresponds to\n    the ``\"a\"`` part of ``\"CTYPEia\"``.  (*key* may only be\n    provided if *header* is also provided.)\n\nrelax : bool or int, optional\n\n    Degree of permissiveness:\n\n    - `False`: Recognize only FITS keywords defined by th", 256);
   strncpy(doc_Wcsprm + 1024, "e published\n      WCS standard.\n\n    - `True`: Admit all recognized informal extensions of the WCS\n      standard.\n\n    - `int`: a bit field selecting specific extensions to accept.  See\n      :ref:`relaxread` for details.\n\nnaxis : int, optional\n    The nu", 256);
   strncpy(doc_Wcsprm + 1280, "mber of world coordinates axes for the object.  (*naxis* may\n    only be provided if *header* is `None`.)\n\nkeysel : sequence of flag bits, optional\n    Vector of flag bits that may be used to restrict the keyword types\n    considered:\n\n        - ``WCSHDR_I", 256);
   strncpy(doc_Wcsprm + 1536, "MGHEAD``: Image header keywords.\n\n        - ``WCSHDR_BIMGARR``: Binary table image array.\n\n        - ``WCSHDR_PIXLIST``: Pixel list keywords.\n\n    If zero, there is no restriction.  If -1, the underlying wcslib\n    function ``wcspih()`` is called, rather t", 256);
   strncpy(doc_Wcsprm + 1792, "han ``wcstbh()``.\n\ncolsel : sequence of int\n    A sequence of table column numbers used to restrict the keywords\n    considered.  `None` indicates no restriction.\n\nRaises\n------\nMemoryError\n     Memory allocation failed.\n\nValueError\n     Invalid key.\n\nKeyE", 256);
   strncpy(doc_Wcsprm + 2048, "rror\n     Key not found in FITS header.\n\x00", 41);

   strncpy(doc_Wtbarr + 0, "Classes to construct coordinate lookup tables from a binary table\nextension (BINTABLE).\n\nThis class can not be constructed directly from Python, but instead is\nreturned from `~astropy.wcs.Wcsprm.wtb`.\n\x00", 202);

   strncpy(doc_a + 0, "``double array[a_order+1][a_order+1]`` Focal plane transformation\nmatrix.\n\nThe `SIP`_ ``A_i_j`` matrix used for pixel to focal plane\ntransformation.\n\nIts values may be changed in place, but it may not be resized, without\ncreating a new `~astropy.wcs.Sip` o", 256);
   strncpy(doc_a + 256, "bject.\n\x00", 8);

   strncpy(doc_a_order + 0, "``int`` (read-only) Order of the polynomial (``A_ORDER``).\n\x00", 60);

   strncpy(doc_all_pix2world + 0, "all_pix2world(pixcrd, origin) -> ``double array[ncoord][nelem]``\n\nTransforms pixel coordinates to world coordinates.\n\nDoes the following:\n\n    - Detector to image plane correction (optionally)\n\n    - SIP distortion correction (optionally)\n\n    - Paper IV d", 256);
   strncpy(doc_all_pix2world + 256, "istortion correction (optionally)\n\n    - wcslib WCS transformation\n\nThe first three (the distortion corrections) are done in parallel.\n\nParameters\n----------\npixcrd : double array[ncoord][nelem]\n    Array of pixel coordinates.\n\n\norigin : int\n    Specifies ", 256);
   strncpy(doc_all_pix2world + 512, "the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nworld : double array[ncoord][nelem]\n    Returns an array of world coordinates.\n\nRaises\n------\nMemory", 256);
   strncpy(doc_all_pix2world + 768, "Error\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nValueError\n    Invalid coor", 256);
   strncpy(doc_all_pix2world + 1024, "dinate transformation parameters.\n\nValueError\n    x- and y-coordinate arrays are not the same size.\n\nInvalidTransformError\n    Invalid coordinate transformation.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\x00", 244);

   strncpy(doc_alt + 0, "``str`` Character code for alternate coordinate descriptions.\n\nFor example, the ``\"a\"`` in keyword names such as ``CTYPEia``.  This\nis a space character for the primary coordinate description, or one of\nthe 26 upper-case letters, A-Z.\n\x00", 236);

   strncpy(doc_ap + 0, "``double array[ap_order+1][ap_order+1]`` Focal plane to pixel\ntransformation matrix.\n\nThe `SIP`_ ``AP_i_j`` matrix used for focal plane to pixel\ntransformation.  Its values may be changed in place, but it may not be\nresized, without creating a new `~astrop", 256);
   strncpy(doc_ap + 256, "y.wcs.Sip` object.\n\x00", 20);

   strncpy(doc_ap_order + 0, "``int`` (read-only) Order of the polynomial (``AP_ORDER``).\n\x00", 61);

   strncpy(doc_axis_types + 0, "``int array[naxis]`` An array of four-digit type codes for each axis.\n\n- First digit (i.e. 1000s):\n\n  - 0: Non-specific coordinate type.\n\n  - 1: Stokes coordinate.\n\n  - 2: Celestial coordinate (including ``CUBEFACE``).\n\n  - 3: Spectral coordinate.\n\n- Secon", 256);
   strncpy(doc_axis_types + 256, "d digit (i.e. 100s):\n\n  - 0: Linear axis.\n\n  - 1: Quantized axis (``STOKES``, ``CUBEFACE``).\n\n  - 2: Non-linear celestial axis.\n\n  - 3: Non-linear spectral axis.\n\n  - 4: Logarithmic axis.\n\n  - 5: Tabular axis.\n\n- Third digit (i.e. 10s):\n\n  - 0: Group numbe", 256);
   strncpy(doc_axis_types + 512, "r, e.g. lookup table number\n\n- The fourth digit is used as a qualifier depending on the axis type.\n\n  - For celestial axes:\n\n    - 0: Longitude coordinate.\n\n    - 1: Latitude coordinate.\n\n    - 2: ``CUBEFACE`` number.\n\n  - For lookup tables: the axis numbe", 256);
   strncpy(doc_axis_types + 768, "r in a multidimensional table.\n\n``CTYPEia`` in ``\"4-3\"`` form with unrecognized algorithm code will\nhave its type set to -1 and generate an error.\n\x00", 148);

   strncpy(doc_b + 0, "``double array[b_order+1][b_order+1]`` Pixel to focal plane\ntransformation matrix.\n\nThe `SIP`_ ``B_i_j`` matrix used for pixel to focal plane\ntransformation.  Its values may be changed in place, but it may not be\nresized, without creating a new `~astropy.w", 256);
   strncpy(doc_b + 256, "cs.Sip` object.\n\x00", 17);

   strncpy(doc_b_order + 0, "``int`` (read-only) Order of the polynomial (``B_ORDER``).\n\x00", 60);

   strncpy(doc_bp + 0, "``double array[bp_order+1][bp_order+1]`` Focal plane to pixel\ntransformation matrix.\n\nThe `SIP`_ ``BP_i_j`` matrix used for focal plane to pixel\ntransformation.  Its values may be changed in place, but it may not be\nresized, without creating a new `~astrop", 256);
   strncpy(doc_bp + 256, "y.wcs.Sip` object.\n\x00", 20);

   strncpy(doc_bp_order + 0, "``int`` (read-only) Order of the polynomial (``BP_ORDER``).\n\x00", 61);

   strncpy(doc_cd + 0, "``double array[naxis][naxis]`` The ``CDi_ja`` linear transformation\nmatrix.\n\nFor historical compatibility, three alternate specifications of the\nlinear transforations are available in wcslib.  The canonical\n``PCi_ja`` with ``CDELTia``, and the deprecated `", 256);
   strncpy(doc_cd + 256, "`CDi_ja`` and\n``CROTAia`` keywords.  Although the deprecated versions may not\nformally co-exist with ``PCi_ja``, the approach here is simply to\nignore them if given in conjunction with ``PCi_ja``.\n\n`~astropy.wcs.Wcsprm.has_pc`, `~astropy.wcs.Wcsprm.has_cd`", 256);
   strncpy(doc_cd + 512, " and\n`~astropy.wcs.Wcsprm.has_crota` can be used to determine which of\nthese alternatives are present in the header.\n\nThese alternate specifications of the linear transformation matrix are\ntranslated immediately to ``PCi_ja`` by `~astropy.wcs.Wcsprm.set` a", 256);
   strncpy(doc_cd + 768, "nd\nare nowhere visible to the lower-level routines.  In particular,\n`~astropy.wcs.Wcsprm.set` resets `~astropy.wcs.Wcsprm.cdelt` to unity\nif ``CDi_ja`` is present (and no ``PCi_ja``).  If no ``CROTAia`` is\nassociated with the latitude axis, `~astropy.wcs.W", 256);
   strncpy(doc_cd + 1024, "csprm.set` reverts\nto a unity ``PCi_ja`` matrix.\n\x00", 50);

   strncpy(doc_cdelt + 0, "``double array[naxis]`` Coordinate increments (``CDELTia``) for each\ncoord axis.\n\nIf a ``CDi_ja`` linear transformation matrix is present, a warning is\nraised and `~astropy.wcs.Wcsprm.cdelt` is ignored.  The ``CDi_ja``\nmatrix may be deleted by::\n\n  del wcs", 256);
   strncpy(doc_cdelt + 256, ".wcs.cd\n\nAn undefined value is represented by NaN.\n\x00", 52);

   strncpy(doc_cdfix + 0, "cdfix()\n\nFix erroneously omitted ``CDi_ja`` keywords.\n\nSets the diagonal element of the ``CDi_ja`` matrix to unity if all\n``CDi_ja`` keywords associated with a given axis were omitted.\nAccording to Paper I, if any ``CDi_ja`` keywords at all are given in a\n", 256);
   strncpy(doc_cdfix + 256, "FITS header then those not given default to zero.  This results in a\nsingular matrix with an intersecting row and column of zeros.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00", 224);

   strncpy(doc_cel_offset + 0, "``boolean`` Is there an offset?\n\nIf `True`, an offset will be applied to ``(x, y)`` to force ``(x, y) =\n(0, 0)`` at the fiducial point, (phi_0, theta_0).  Default is `False`.\n\x00", 176);

   strncpy(doc_celfix + 0, "Translates AIPS-convention celestial projection types, ``-NCP`` and\n``-GLS``.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00", 171);

   strncpy(doc_cname + 0, "``list of strings`` A list of the coordinate axis names, from\n``CNAMEia``.\n\x00", 76);

   strncpy(doc_colax + 0, "``int array[naxis]`` An array recording the column numbers for each\naxis in a pixel list.\n\x00", 91);

   strncpy(doc_colnum + 0, "``int`` Column of FITS binary table associated with this WCS.\n\nWhere the coordinate representation is associated with an image-array\ncolumn in a FITS binary table, this property may be used to record the\nrelevant column number.\n\nIt should be set to zero fo", 256);
   strncpy(doc_colnum + 256, "r an image header or pixel list.\n\x00", 34);

   strncpy(doc_convert + 0, "convert(array)\n\nPerform the unit conversion on the elements of the given *array*,\nreturning an array of the same shape.\n\x00", 121);

   strncpy(doc_coord + 0, "``double array[K_M]...[K_2][K_1][M]`` The tabular coordinate array.\n\nHas the dimensions::\n\n    (K_M, ... K_2, K_1, M)\n\n(see `~astropy.wcs._astropy.wcs.Tabprm.K`) i.e. with the `M` dimension\nvarying fastest so that the `M` elements of a coordinate vector ar", 256);
   strncpy(doc_coord + 256, "e\nstored contiguously in memory.\n\x00", 34);

   strncpy(doc_copy + 0, "Creates a deep copy of the WCS object.\n\x00", 40);

   strncpy(doc_cpdis1 + 0, "`~astropy.wcs.DistortionLookupTable`\n\nThe pre-linear transformation distortion lookup table, ``CPDIS1``.\n\x00", 106);

   strncpy(doc_cpdis2 + 0, "`~astropy.wcs.DistortionLookupTable`\n\nThe pre-linear transformation distortion lookup table, ``CPDIS2``.\n\x00", 106);

   strncpy(doc_crder + 0, "``double array[naxis]`` The random error in each coordinate axis,\n``CRDERia``.\n\nAn undefined value is represented by NaN.\n\x00", 123);

   strncpy(doc_crota + 0, "``double array[naxis]`` ``CROTAia`` keyvalues for each coordinate\naxis.\n\nFor historical compatibility, three alternate specifications of the\nlinear transforations are available in wcslib.  The canonical\n``PCi_ja`` with ``CDELTia``, and the deprecated ``CDi", 256);
   strncpy(doc_crota + 256, "_ja`` and\n``CROTAia`` keywords.  Although the deprecated versions may not\nformally co-exist with ``PCi_ja``, the approach here is simply to\nignore them if given in conjunction with ``PCi_ja``.\n\n`~astropy.wcs.Wcsprm.has_pc`, `~astropy.wcs.Wcsprm.has_cd` and", 256);
   strncpy(doc_crota + 512, "\n`~astropy.wcs.Wcsprm.has_crota` can be used to determine which of\nthese alternatives are present in the header.\n\nThese alternate specifications of the linear transformation matrix are\ntranslated immediately to ``PCi_ja`` by `~astropy.wcs.Wcsprm.set` and\na", 256);
   strncpy(doc_crota + 768, "re nowhere visible to the lower-level routines.  In particular,\n`~astropy.wcs.Wcsprm.set` resets `~astropy.wcs.Wcsprm.cdelt` to unity\nif ``CDi_ja`` is present (and no ``PCi_ja``).  If no ``CROTAia`` is\nassociated with the latitude axis, `~astropy.wcs.Wcspr", 256);
   strncpy(doc_crota + 1024, "m.set` reverts\nto a unity ``PCi_ja`` matrix.\n\x00", 46);

   strncpy(doc_crpix + 0, "``double array[naxis]`` Coordinate reference pixels (``CRPIXja``) for\neach pixel axis.\n\x00", 88);

   strncpy(doc_crval + 0, "``double array[naxis]`` Coordinate reference values (``CRVALia``) for\neach coordinate axis.\n\x00", 93);

   strncpy(doc_crval_tabprm + 0, "``double array[M]`` Index values for the reference pixel for each of\nthe tabular coord axes.\n\x00", 94);

   strncpy(doc_csyer + 0, "``double array[naxis]`` The systematic error in the coordinate value\naxes, ``CSYERia``.\n\nAn undefined value is represented by NaN.\n\x00", 132);

   strncpy(doc_ctype + 0, "``list of strings[naxis]`` List of ``CTYPEia`` keyvalues.\n\nThe `~astropy.wcs.Wcsprm.ctype` keyword values must be in upper case\nand there must be zero or one pair of matched celestial axis types,\nand zero or one spectral axis.\n\x00", 228);

   strncpy(doc_cubeface + 0, "``int`` Index into the ``pixcrd`` (pixel coordinate) array for the\n``CUBEFACE`` axis.\n\nThis is used for quadcube projections where the cube faces are stored\non a separate axis.\n\nThe quadcube projections (``TSC``, ``CSC``, ``QSC``) may be\nrepresented in FIT", 256);
   strncpy(doc_cubeface + 256, "S in either of two ways:\n\n    - The six faces may be laid out in one plane and numbered as\n      follows::\n\n\n                                       0\n\n                              4  3  2  1  4  3  2\n\n                                       5\n\n      Faces ", 256);
   strncpy(doc_cubeface + 512, "2, 3 and 4 may appear on one side or the other (or both).\n      The world-to-pixel routines map faces 2, 3 and 4 to the left but\n      the pixel-to-world routines accept them on either side.\n\n    - The ``COBE`` convention in which the six faces are stored ", 256);
   strncpy(doc_cubeface + 768, "in a\n      three-dimensional structure using a ``CUBEFACE`` axis indexed\n      from 0 to 5 as above.\n\nThese routines support both methods; `~astropy.wcs.Wcsprm.set`\ndetermines which is being used by the presence or absence of a\n``CUBEFACE`` axis in `~astro", 256);
   strncpy(doc_cubeface + 1024, "py.wcs.Wcsprm.ctype`.\n`~astropy.wcs.Wcsprm.p2s` and `~astropy.wcs.Wcsprm.s2p` translate the\n``CUBEFACE`` axis representation to the single plane representation\nunderstood by the lower-level projection routines.\n\x00", 212);

   strncpy(doc_cunit + 0, "``list of strings[naxis]`` List of ``CUNITia`` keyvalues.\n\nThese define the units of measurement of the ``CRVALia``, ``CDELTia``\nand ``CDi_ja`` keywords.\n\nAs ``CUNITia`` is an optional header keyword,\n`~astropy.wcs.Wcsprm.cunit` may be left blank but other", 256);
   strncpy(doc_cunit + 256, "wise is\nexpected to contain a standard units specification as defined by WCS\nPaper I.  `~astropy.wcs.Wcsprm.unitfix` is available to translate\ncommonly used non-standard units specifications but this must be done\nas a separate step before invoking `~astrop", 256);
   strncpy(doc_cunit + 512, "y.wcs.Wcsprm.set`.\n\nFor celestial axes, if `~astropy.wcs.Wcsprm.cunit` is not blank,\n`~astropy.wcs.Wcsprm.set` uses `wcsunits` to parse it and scale\n`~astropy.wcs.Wcsprm.cdelt`, `~astropy.wcs.Wcsprm.crval`, and\n`~astropy.wcs.Wcsprm.cd` to decimal degrees. ", 256);
   strncpy(doc_cunit + 768, " It then resets\n`~astropy.wcs.Wcsprm.cunit` to ``\"deg\"``.\n\nFor spectral axes, if `~astropy.wcs.Wcsprm.cunit` is not blank,\n`~astropy.wcs.Wcsprm.set` uses `wcsunits` to parse it and scale\n`~astropy.wcs.Wcsprm.cdelt`, `~astropy.wcs.Wcsprm.crval`, and\n`~astro", 256);
   strncpy(doc_cunit + 1024, "py.wcs.Wcsprm.cd` to SI units.  It then resets\n`~astropy.wcs.Wcsprm.cunit` accordingly.\n\n`~astropy.wcs.Wcsprm.set` ignores `~astropy.wcs.Wcsprm.cunit` for\nother coordinate types; `~astropy.wcs.Wcsprm.cunit` may be used to\nlabel coordinate values.\n\x00", 248);

   strncpy(doc_cylfix + 0, "cylfix()\n\nFixes WCS keyvalues for malformed cylindrical projections.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00", 162);

   strncpy(doc_data + 0, "``float array`` The array data for the\n`~astropy.wcs.DistortionLookupTable`.\n\x00", 78);

   strncpy(doc_data_wtbarr + 0, "``double array``\n\nThe array data for the BINTABLE.\n\x00", 52);

   strncpy(doc_dateavg + 0, "``string`` Representative mid-point of the date of observation.\n\nIn ISO format, ``yyyy-mm-ddThh:mm:ss``.\n\nSee also\n--------\nastropy.wcs.Wcsprm.dateobs\n\x00", 152);

   strncpy(doc_dateobs + 0, "``string`` Start of the date of observation.\n\nIn ISO format, ``yyyy-mm-ddThh:mm:ss``.\n\nSee also\n--------\nastropy.wcs.Wcsprm.dateavg\n\x00", 133);

   strncpy(doc_datfix + 0, "datfix()\n\nTranslates the old ``DATE-OBS`` date format to year-2000 standard form\n``(yyyy-mm-ddThh:mm:ss)`` and derives ``MJD-OBS`` from it if not\nalready set.\n\nAlternatively, if `~astropy.wcs.Wcsprm.mjdobs` is set and\n`~astropy.wcs.Wcsprm.dateobs` isn\'t, t", 256);
   strncpy(doc_datfix + 256, "hen `~astropy.wcs.Wcsprm.datfix`\nderives `~astropy.wcs.Wcsprm.dateobs` from it.  If both are set but\ndisagree by more than half a day then `ValueError` is raised.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00", 256);

   strncpy(doc_delta + 0, "``double array[M]`` (read-only) Interpolated indices into the coord\narray.\n\nArray of interpolated indices into the coordinate array such that\nUpsilon_m, as defined in Paper III, is equal to\n(`~astropy.wcs._astropy.wcs.Tabprm.p0` [m] + 1) + delta[m].\n\x00", 251);

   strncpy(doc_det2im + 0, "Convert detector coordinates to image plane coordinates.\n\x00", 58);

   strncpy(doc_det2im1 + 0, "A `~astropy.wcs.DistortionLookupTable` object for detector to image plane\ncorrection in the *x*-axis.\n\x00", 103);

   strncpy(doc_det2im2 + 0, "A `~astropy.wcs.DistortionLookupTable` object for detector to image plane\ncorrection in the *y*-axis.\n\x00", 103);

   strncpy(doc_dims + 0, "``int array[ndim]`` (read-only)\n\nThe dimensions of the tabular array\n`~astropy.wcs._astropy.wcs.Wtbarr.data`.\n\x00", 111);

   strncpy(doc_equinox + 0, "``double`` The equinox associated with dynamical equatorial or\necliptic coordinate systems.\n\n``EQUINOXa`` (or ``EPOCH`` in older headers).  Not applicable to ICRS\nequatorial or ecliptic coordinates.\n\nAn undefined value is represented by NaN.\n\x00", 243);

   strncpy(doc_extlev + 0, "``int`` (read-only)\n\n``EXTLEV`` identifying the binary table extension.\n\x00", 73);

   strncpy(doc_extnam + 0, "``str`` (read-only)\n\n``EXTNAME`` identifying the binary table extension.\n\x00", 74);

   strncpy(doc_extrema + 0, "``double array[K_M]...[K_2][2][M]`` (read-only)\n\nAn array recording the minimum and maximum value of each element of\nthe coordinate vector in each row of the coordinate array, with the\ndimensions::\n\n    (K_M, ... K_2, 2, M)\n\n(see `~astropy.wcs._astropy.wcs", 256);
   strncpy(doc_extrema + 256, ".Tabprm.K`).  The minimum is recorded\nin the first element of the compressed K_1 dimension, then the\nmaximum.  This array is used by the inverse table lookup function to\nspeed up table searches.\n\x00", 196);

   strncpy(doc_extver + 0, "``int`` (read-only)\n\n``EXTVER`` identifying the binary table extension.\n\x00", 73);

   strncpy(doc_find_all_wcs + 0, "find_all_wcs(relax=0, keysel=0)\n\nFind all WCS transformations in the header.\n\nParameters\n----------\n\nheader : str\n    The raw FITS header data.\n\nrelax : bool or int\n    Degree of permissiveness:\n\n    - `False`: Recognize only FITS keywords defined by the p", 256);
   strncpy(doc_find_all_wcs + 256, "ublished\n      WCS standard.\n\n    - `True`: Admit all recognized informal extensions of the WCS\n      standard.\n\n    - `int`: a bit field selecting specific extensions to accept.  See\n      :ref:`relaxread` for details.\n\nkeysel : sequence of flags\n    Used", 256);
   strncpy(doc_find_all_wcs + 512, " to restrict the keyword types considered:\n\n    - ``WCSHDR_IMGHEAD``: Image header keywords.\n\n    - ``WCSHDR_BIMGARR``: Binary table image array.\n\n    - ``WCSHDR_PIXLIST``: Pixel list keywords.\n\n    If zero, there is no restriction.  If -1, `wcspih` is cal", 256);
   strncpy(doc_find_all_wcs + 768, "led,\n    rather than `wcstbh`.\n\nReturns\n-------\nwcs_list : list of `~astropy.wcs._astropy.wcs._Wcsprm` objects\n\x00", 112);

   strncpy(doc_fix + 0, "fix(translate_units=\'\', naxis=0)\n\nApplies all of the corrections handled separately by\n`~astropy.wcs.Wcsprm.datfix`, `~astropy.wcs.Wcsprm.unitfix`,\n`~astropy.wcs.Wcsprm.celfix`, `~astropy.wcs.Wcsprm.spcfix`,\n`~astropy.wcs.Wcsprm.cylfix` and `~astropy.wcs.W", 256);
   strncpy(doc_fix + 256, "csprm.cdfix`.\n\nParameters\n----------\n\ntranslate_units : str\n    Do potentially unsafe translations of non-standard unit strings.\n\n    Although ``\"S\"`` is commonly used to represent seconds, its\n    translation to ``\"s\"`` is potentially unsafe since the sta", 256);
   strncpy(doc_fix + 512, "ndard\n    recognizes ``\"S\"`` formally as Siemens, however rarely that may be\n    used.  The same applies to ``\"H\"`` for hours (Henry), and ``\"D\"``\n    for days (Debye).\n\n    This string controls what to do in such cases, and is\n    case-insensitive.\n\n    -", 256);
   strncpy(doc_fix + 768, " If the string contains ``\"s\"``, translate ``\"S\"`` to ``\"s\"``.\n\n    - If the string contains ``\"h\"``, translate ``\"H\"`` to ``\"h\"``.\n\n    - If the string contains ``\"d\"``, translate ``\"D\"`` to ``\"d\"``.\n\n    Thus ``\'\'`` doesn\'t do any unsafe translations, wh", 256);
   strncpy(doc_fix + 1024, "ereas ``\'shd\'``\n    does all of them.\n\nnaxis : int array[naxis]\n    Image axis lengths.  If this array is set to zero or ``None``,\n    then `~astropy.wcs.Wcsprm.cylfix` will not be invoked.\n\nReturns\n-------\nstatus : dict\n\n    Returns a dictionary containin", 256);
   strncpy(doc_fix + 1280, "g the following keys, each referring\n    to a status string for each of the sub-fix functions that were\n    called:\n\n    - `~astropy.wcs.Wcsprm.cdfix`\n\n    - `~astropy.wcs.Wcsprm.datfix`\n\n    - `~astropy.wcs.Wcsprm.unitfix`\n\n    - `~astropy.wcs.Wcsprm.celf", 256);
   strncpy(doc_fix + 1536, "ix`\n\n    - `~astropy.wcs.Wcsprm.spcfix`\n\n    - `~astropy.wcs.Wcsprm.cylfix`\n\x00", 77);

   strncpy(doc_get_cdelt + 0, "get_cdelt() -> double array[naxis]\n\nCoordinate increments (``CDELTia``) for each coord axis.\n\nReturns the ``CDELT`` offsets in read-only form.  Unlike the\n`~astropy.wcs.Wcsprm.cdelt` property, this works even when the header\nspecifies the linear transforma", 256);
   strncpy(doc_get_cdelt + 256, "tion matrix in one of the deprecated\n``CDi_ja`` or ``CROTAia`` forms.  This is useful when you want access\nto the linear transformation matrix, but don\'t care how it was\nspecified in the header.\n\x00", 196);

   strncpy(doc_get_offset + 0, "get_offset(x, y) -> (x, y)\n\nReturns the offset as defined in the distortion lookup table.\n\nReturns\n-------\ncoordinate : coordinate pair\n    The offset from the distortion table for pixel point (*x*, *y*).\n\x00", 206);

   strncpy(doc_get_pc + 0, "get_pc() -> double array[naxis][naxis]\n\nReturns the ``PC`` matrix in read-only form.  Unlike the\n`~astropy.wcs.Wcsprm.pc` property, this works even when the header\nspecifies the linear transformation matrix in one of the deprecated\n``CDi_ja`` or ``CROTAia`", 256);
   strncpy(doc_get_pc + 256, "` forms.  This is useful when you want access\nto the linear transformation matrix, but don\'t care how it was\nspecified in the header.\n\x00", 135);

   strncpy(doc_get_ps + 0, "get_ps() -> list of tuples\n\nReturns ``PSi_ma`` keywords for each *i* and *m*.\n\nReturns\n-------\nps : list of tuples\n\n    Returned as a list of tuples of the form (*i*, *m*, *value*):\n\n    - *i*: int.  Axis number, as in ``PSi_ma``, (i.e. 1-relative)\n\n    - ", 256);
   strncpy(doc_get_ps + 256, "*m*: int.  Parameter number, as in ``PSi_ma``, (i.e. 0-relative)\n\n    - *value*: string.  Parameter value.\n\nSee also\n--------\nastropy.wcs.Wcsprm.set_ps : Set ``PSi_ma`` values\n\x00", 177);

   strncpy(doc_get_pv + 0, "get_pv() -> list of tuples\n\nReturns ``PVi_ma`` keywords for each *i* and *m*.\n\nReturns\n-------\n\n    Returned as a list of tuples of the form (*i*, *m*, *value*):\n\n    - *i*: int.  Axis number, as in ``PVi_ma``, (i.e. 1-relative)\n\n    - *m*: int.  Parameter", 256);
   strncpy(doc_get_pv + 256, " number, as in ``PVi_ma``, (i.e. 0-relative)\n\n    - *value*: string. Parameter value.\n\nSee also\n--------\nastropy.wcs.Wcsprm.set_pv : Set ``PVi_ma`` values\n\nNotes\n-----\n\nNote that, if they were not given, `~astropy.wcs.Wcsprm.set` resets\nthe entries for ``P", 256);
   strncpy(doc_get_pv + 512, "Vi_1a``, ``PVi_2a``, ``PVi_3a``, and ``PVi_4a`` for\nlongitude axis *i* to match (``phi_0``, ``theta_0``), the native\nlongitude and latitude of the reference point given by ``LONPOLEa``\nand ``LATPOLEa``.\n\x00", 204);

   strncpy(doc_has_cd + 0, "has_cd() -> bool\n\nReturns `True` if ``CDi_ja`` is present.\n\n``CDi_ja`` is an alternate specification of the linear transformation\nmatrix, maintained for historical compatibility.\n\nMatrix elements in the IRAF convention are equivalent to the product\n``CDi_j", 256);
   strncpy(doc_has_cd + 256, "a = CDELTia * PCi_ja``, but the defaults differ from that of\nthe ``PCi_ja`` matrix.  If one or more ``CDi_ja`` keywords are present\nthen all unspecified ``CDi_ja`` default to zero.  If no ``CDi_ja`` (or\n``CROTAia``) keywords are present, then the header is", 256);
   strncpy(doc_has_cd + 512, " assumed to be in\n``PCi_ja`` form whether or not any ``PCi_ja`` keywords are present\nsince this results in an interpretation of ``CDELTia`` consistent with\nthe original FITS specification.\n\nWhile ``CDi_ja`` may not formally co-exist with ``PCi_ja``, it may", 256);
   strncpy(doc_has_cd + 768, "\nco-exist with ``CDELTia`` and ``CROTAia`` which are to be ignored.\n\nSee also\n--------\nastropy.wcs.Wcsprm.cd : Get the raw ``CDi_ja`` values.\n\x00", 143);

   strncpy(doc_has_cdi_ja + 0, "has_cdi_ja() -> bool\n\nAlias for `~astropy.wcs.Wcsprm.has_cd`.  Maintained for backward\ncompatibility.\n\x00", 103);

   strncpy(doc_has_crota + 0, "has_crota() -> bool\n\nReturns `True` if ``CROTAia`` is present.\n\n``CROTAia`` is an alternate specification of the linear transformation\nmatrix, maintained for historical compatibility.\n\nIn the AIPS convention, ``CROTAia`` may only be associated with the\nlat", 256);
   strncpy(doc_has_crota + 256, "itude axis of a celestial axis pair.  It specifies a rotation in\nthe image plane that is applied *after* the ``CDELTia``; any other\n``CROTAia`` keywords are ignored.\n\n``CROTAia`` may not formally co-exist with ``PCi_ja``.  ``CROTAia`` and\n``CDELTia`` may f", 256);
   strncpy(doc_has_crota + 512, "ormally co-exist with ``CDi_ja`` but if so are to be\nignored.\n\nSee also\n--------\nastropy.wcs.Wcsprm.crota : Get the raw ``CROTAia`` values\n\x00", 140);

   strncpy(doc_has_crotaia + 0, "has_crotaia() -> bool\n\nAlias for `~astropy.wcs.Wcsprm.has_crota`.  Maintained for backward\ncompatibility.\n\x00", 107);

   strncpy(doc_has_pc + 0, "has_pc() -> bool\n\nReturns `True` if ``PCi_ja`` is present.  ``PCi_ja`` is the\nrecommended way to specify the linear transformation matrix.\n\nSee also\n--------\nastropy.wcs.Wcsprm.pc : Get the raw ``PCi_ja`` values\n\x00", 213);

   strncpy(doc_has_pci_ja + 0, "has_pci_ja() -> bool\n\nAlias for `~astropy.wcs.Wcsprm.has_pc`.  Maintained for backward\ncompatibility.\n\x00", 103);

   strncpy(doc_have + 0, "``string`` The name of the unit being converted from.\n\nThis value always uses standard unit names, even if the\n`UnitConverter` was initialized with a non-standard unit name.\n\x00", 175);

   strncpy(doc_i + 0, "``int`` (read-only)\n\nImage axis number.\n\x00", 41);

   strncpy(doc_imgpix_matrix + 0, "``double array[2][2]`` (read-only) Inverse of the ``CDELT`` or ``PC``\nmatrix.\n\nInverse containing the product of the ``CDELTia`` diagonal matrix and\nthe ``PCi_ja`` matrix.\n\x00", 173);

   strncpy(doc_is_unity + 0, "is_unity() -> bool\n\nReturns `True` if the linear transformation matrix\n(`~astropy.wcs.Wcsprm.cd`) is unity.\n\x00", 109);

   strncpy(doc_kind + 0, "``str`` (read-only)\n\nCharacter identifying the wcstab array type:\n\n    - ``\'c\'``: coordinate array,\n    - ``\'i\'``: index vector.\n\x00", 130);

   strncpy(doc_lat + 0, "``int`` (read-only) The index into the world coord array containing\nlatitude values.\n\x00", 86);

   strncpy(doc_latpole + 0, "``double`` The native latitude of the celestial pole, ``LATPOLEa`` (deg).\n\x00", 75);

   strncpy(doc_lattyp + 0, "``string`` (read-only) Celestial axis type for latitude.\n\nFor example, \"RA\", \"DEC\", \"GLON\", \"GLAT\", etc. extracted from \"RA--\",\n\"DEC-\", \"GLON\", \"GLAT\", etc. in the first four characters of\n``CTYPEia`` but with trailing dashes removed.\n\x00", 236);

   strncpy(doc_lng + 0, "``int`` (read-only) The index into the world coord array containing\nlongitude values.\n\x00", 87);

   strncpy(doc_lngtyp + 0, "``string`` (read-only) Celestial axis type for longitude.\n\nFor example, \"RA\", \"DEC\", \"GLON\", \"GLAT\", etc. extracted from \"RA--\",\n\"DEC-\", \"GLON\", \"GLAT\", etc. in the first four characters of\n``CTYPEia`` but with trailing dashes removed.\n\x00", 237);

   strncpy(doc_lonpole + 0, "``double`` The native longitude of the celestial pole.\n\n``LONPOLEa`` (deg).\n\x00", 77);

   strncpy(doc_m + 0, "``int`` (read-only)\n\nArray axis number for index vectors.\n\x00", 59);

   strncpy(doc_map + 0, "``int array[M]`` Association between axes.\n\nA vector of length `~astropy.wcs._astropy.wcs.Tabprm.M` that defines\nthe association between axis *m* in the *M*-dimensional coordinate\narray (1 <= *m* <= *M*) and the indices of the intermediate world\ncoordinate", 256);
   strncpy(doc_map + 256, " and world coordinate arrays.\n\nWhen the intermediate and world coordinate arrays contain the full\ncomplement of coordinate elements in image-order, as will usually be\nthe case, then ``map[m-1] == i-1`` for axis *i* in the *N*-dimensional\nimage (1 <= *i* <=", 256);
   strncpy(doc_map + 512, " *N*).  In terms of the FITS keywords::\n\n    map[PVi_3a - 1] == i - 1.\n\nHowever, a different association may result if the intermediate\ncoordinates, for example, only contains a (relevant) subset of\nintermediate world coordinate elements.  For example, if ", 256);
   strncpy(doc_map + 768, "*M* == 1 for\nan image with *N* > 1, it is possible to fill the intermediate\ncoordinates with the relevant coordinate element with ``nelem`` set to\n1.  In this case ``map[0] = 0`` regardless of the value of *i*.\n\x00", 212);

   strncpy(doc_mix + 0, "mix(mixpix, mixcel, vspan, vstep, viter, world, pixcrd, origin)\n\nGiven either the celestial longitude or latitude plus an element of\nthe pixel coordinate, solves for the remaining elements by iterating\non the unknown celestial coordinate element using\n`~as", 256);
   strncpy(doc_mix + 256, "tropy.wcs.Wcsprm.s2p`.\n\nParameters\n----------\nmixpix : int\n    Which element on the pixel coordinate is given.\n\nmixcel : int\n    Which element of the celestial coordinate is given. If *mixcel* =\n    ``1``, celestial longitude is given in ``world[self.lng]`", 256);
   strncpy(doc_mix + 512, "`,\n    latitude returned in ``world[self.lat]``.  If *mixcel* = ``2``,\n    celestial latitude is given in ``world[self.lat]``, longitude\n    returned in ``world[self.lng]``.\n\nvspan : pair of floats\n    Solution interval for the celestial coordinate, in deg", 256);
   strncpy(doc_mix + 768, "rees.  The\n    ordering of the two limits is irrelevant.  Longitude ranges may be\n    specified with any convenient normalization, for example\n    ``(-120,+120)`` is the same as ``(240,480)``, except that the\n    solution will be returned with the same nor", 256);
   strncpy(doc_mix + 1024, "malization, i.e. lie\n    within the interval specified.\n\nvstep : float\n    Step size for solution search, in degrees.  If ``0``, a sensible,\n    although perhaps non-optimal default will be used.\n\nviter : int\n    If a solution is not found then the step si", 256);
   strncpy(doc_mix + 1280, "ze will be halved and\n    the search recommenced.  *viter* controls how many times the step\n    size is halved.  The allowed range is 5 - 10.\n\nworld : double array[naxis]\n    World coordinate elements.  ``world[self.lng]`` and\n    ``world[self.lat]`` are t", 256);
   strncpy(doc_mix + 1536, "he celestial longitude and latitude, in\n    degrees.  Which is given and which returned depends on the value\n    of *mixcel*.  All other elements are given.  The results will be\n    written to this array in-place.\n\npixcrd : double array[naxis].\n    Pixel c", 256);
   strncpy(doc_mix + 1792, "oordinates.  The element indicated by *mixpix* is given and\n    the remaining elements will be written in-place.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexin", 256);
   strncpy(doc_mix + 2048, "g with\n    origin at 0.\n\n\nReturns\n-------\nresult : dict\n\n    Returns a dictionary with the following keys:\n\n    - *phi* (double array[naxis])\n\n    - *theta* (double array[naxis])\n\n        - Longitude and latitude in the native coordinate system of\n        ", 256);
   strncpy(doc_mix + 2304, "  the projection, in degrees.\n\n    - *imgcrd* (double array[naxis])\n\n        - Image coordinate elements.  ``imgcrd[self.lng]`` and\n          ``imgcrd[self.lat]`` are the projected *x*- and\n          *y*-coordinates, in decimal degrees.\n\n    - *world* (dou", 256);
   strncpy(doc_mix + 2560, "ble array[naxis])\n\n        - Another reference to the *world* argument passed in.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or un", 256);
   strncpy(doc_mix + 2816, "recognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nInvalidTransformError\n    Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\nInvalidCoordinateError\n   ", 256);
   strncpy(doc_mix + 3072, " Invalid world coordinate.\n\nNoSolutionError\n    No solution found in the specified interval.\n\nSee also\n--------\nastropy.wcs.Wcsprm.lat, astropy.wcs.Wcsprm.lng\n    Get the axes numbers for latitude and longitude\n\nNotes\n-----\n\nInitially, the specified soluti", 256);
   strncpy(doc_mix + 3328, "on interval is checked to see if it\'s a\n\"crossing\" interval.  If it isn\'t, a search is made for a crossing\nsolution by iterating on the unknown celestial coordinate starting at\nthe upper limit of the solution interval and decrementing by the\nspecified step", 256);
   strncpy(doc_mix + 3584, " size.  A crossing is indicated if the trial value of\nthe pixel coordinate steps through the value specified.  If a crossing\ninterval is found then the solution is determined by a modified form\nof \"regula falsi\" division of the crossing interval.  If no cr", 256);
   strncpy(doc_mix + 3840, "ossing\ninterval was found within the specified solution interval then a\nsearch is made for a \"non-crossing\" solution as may arise from a\npoint of tangency.  The process is complicated by having to make\nallowance for the discontinuities that occur in all ma", 256);
   strncpy(doc_mix + 4096, "p projections.\n\nOnce one solution has been determined others may be found by\nsubsequent invocations of `~astropy.wcs.Wcsprm.mix` with suitably\nrestricted solution intervals.\n\nNote the circumstance that arises when the solution point lies at a\nnative pole o", 256);
   strncpy(doc_mix + 4352, "f a projection in which the pole is represented as a\nfinite curve, for example the zenithals and conics.  In such cases two\nor more valid solutions may exist but `~astropy.wcs.Wcsprm.mix` only\never returns one.\n\nBecause of its generality, `~astropy.wcs.Wcs", 256);
   strncpy(doc_mix + 4608, "prm.mix` is very\ncompute-intensive.  For compute-limited applications, more efficient\nspecial-case solvers could be written for simple projections, for\nexample non-oblique cylindrical projections.\n\x00", 198);

   strncpy(doc_mjdavg + 0, "``double`` Modified Julian Date corresponding to ``DATE-AVG``.\n\n``(MJD = JD - 2400000.5)``.\n\nAn undefined value is represented by NaN.\n\nSee also\n--------\nastropy.wcs.Wcsprm.mjdobs\n\x00", 181);

   strncpy(doc_mjdobs + 0, "``double`` Modified Julian Date corresponding to ``DATE-OBS``.\n\n``(MJD = JD - 2400000.5)``.\n\nAn undefined value is represented by NaN.\n\nSee also\n--------\nastropy.wcs.Wcsprm.mjdavg\n\x00", 181);

   strncpy(doc_name + 0, "``string`` The name given to the coordinate representation\n``WCSNAMEa``.\n\x00", 74);

   strncpy(doc_naxis + 0, "``int`` (read-only) The number of axes (pixel and coordinate).\n\nGiven by the ``NAXIS`` or ``WCSAXESa`` keyvalues.\n\nThe number of coordinate axes is determined at parsing time, and can\nnot be subsequently changed.\n\nIt is determined from the highest of the f", 256);
   strncpy(doc_naxis + 256, "ollowing:\n\n  1. ``NAXIS``\n\n  2. ``WCSAXESa``\n\n  3. The highest axis number in any parameterized WCS keyword.  The\n     keyvalue, as well as the keyword, must be syntactically valid\n     otherwise it will not be considered.\n\nIf none of these keyword types i", 256);
   strncpy(doc_naxis + 512, "s present, i.e. if the header only\ncontains auxiliary WCS keywords for a particular coordinate\nrepresentation, then no coordinate description is constructed for it.\n\nThis value may differ for different coordinate representations of the\nsame image.\n\x00", 249);

   strncpy(doc_nc + 0, "``int`` (read-only) Total number of coord vectors in the coord array.\n\nTotal number of coordinate vectors in the coordinate array being the\nproduct K_1 * K_2 * ... * K_M.\n\x00", 172);

   strncpy(doc_ndim + 0, "``int`` (read-only)\n\nExpected dimensionality of the wcstab array.\n\x00", 67);

   strncpy(doc_obsgeo + 0, "``double array[3]`` Location of the observer in a standard terrestrial\nreference frame.\n\n``OBSGEO-X``, ``OBSGEO-Y``, ``OBSGEO-Z`` (in meters).\n\nAn undefined value is represented by NaN.\n\x00", 187);

   strncpy(doc_offset + 0, "``double`` The offset of the unit conversion.\n\x00", 47);

   strncpy(doc_p0 + 0, "``int array[M]`` Interpolated indices into the coordinate array.\n\nVector of length `~astropy.wcs._astropy.wcs.Tabprm.M` of interpolated\nindices into the coordinate array such that Upsilon_m, as defined in\nPaper III, is equal to ``(p0[m] + 1) + delta[m]``.\n", 256);
   strncpy(doc_p0 + 256, "\x00", 1);

   strncpy(doc_p2s + 0, "p2s(pixcrd, origin)\n\nConverts pixel to world coordinates.\n\nParameters\n----------\n\npixcrd : double array[ncoord][nelem]\n    Array of pixel coordinates.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origi", 256);
   strncpy(doc_p2s + 256, "n of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nresult : dict\n    Returns a dictionary with the following keys:\n\n    - *imgcrd*: double array[ncoord][nelem]\n\n      - Array of intermediate world coordinates.  For celestial ax", 256);
   strncpy(doc_p2s + 512, "es,\n        ``imgcrd[][self.lng]`` and ``imgcrd[][self.lat]`` are the\n        projected *x*-, and *y*-coordinates, in pseudo degrees.  For\n        spectral axes, ``imgcrd[][self.spec]`` is the intermediate\n        spectral coordinate, in SI units.\n\n    - *", 256);
   strncpy(doc_p2s + 768, "phi*: double array[ncoord]\n\n    - *theta*: double array[ncoord]\n\n      - Longitude and latitude in the native coordinate system of the\n        projection, in degrees.\n\n    - *world*: double array[ncoord][nelem]\n\n      - Array of world coordinates.  For cel", 256);
   strncpy(doc_p2s + 1024, "estial axes,\n        ``world[][self.lng]`` and ``world[][self.lat]`` are the\n        celestial longitude and latitude, in degrees.  For spectral\n        axes, ``world[][self.spec]`` is the intermediate spectral\n        coordinate, in SI units.\n\n    - *stat", 256);
   strncpy(doc_p2s + 1280, "*: int array[ncoord]\n\n      - Status return value for each coordinate. ``0`` for success,\n        ``1+`` for invalid pixel coordinate.\n\nRaises\n------\n\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singul", 256);
   strncpy(doc_p2s + 1536, "ar.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nValueError\n    *x*- and *y*-coordinate arrays are not the same size.\n\nInvalidTransformError\n    Invalid coordinate transformat", 256);
   strncpy(doc_p2s + 1792, "ion parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\nSee also\n--------\nastropy.wcs.Wcsprm.lat, astropy.wcs.Wcsprm.lng\n    Definition of the latitude andlongitude axes\n\x00", 213);

   strncpy(doc_p4_pix2foc + 0, "p4_pix2foc(*pixcrd, origin*) -> double array[ncoord][nelem]\n\nConvert pixel coordinates to focal plane coordinates using `Paper IV`_\nlookup-table distortion correction.\n\nParameters\n----------\npixcrd : double array[ncoord][nelem].\n    Array of pixel coordina", 256);
   strncpy(doc_p4_pix2foc + 256, "tes.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nfoccrd : double array[ncoord][nelem]\n    Returns an array of focal", 256);
   strncpy(doc_p4_pix2foc + 512, " plane coordinates.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nValueError\n    Invalid coordinate transformation parameters.\n\x00", 140);

   strncpy(doc_pc + 0, "``double array[naxis][naxis]`` The ``PCi_ja`` (pixel coordinate)\ntransformation matrix.\n\nThe order is::\n\n  [[PC1_1, PC1_2],\n   [PC2_1, PC2_2]]\n\nFor historical compatibility, three alternate specifications of the\nlinear transforations are available in wcsli", 256);
   strncpy(doc_pc + 256, "b.  The canonical\n``PCi_ja`` with ``CDELTia``, and the deprecated ``CDi_ja`` and\n``CROTAia`` keywords.  Although the deprecated versions may not\nformally co-exist with ``PCi_ja``, the approach here is simply to\nignore them if given in conjunction with ``PC", 256);
   strncpy(doc_pc + 512, "i_ja``.\n\n`~astropy.wcs.Wcsprm.has_pc`, `~astropy.wcs.Wcsprm.has_cd` and\n`~astropy.wcs.Wcsprm.has_crota` can be used to determine which of\nthese alternatives are present in the header.\n\nThese alternate specifications of the linear transformation matrix are\n", 256);
   strncpy(doc_pc + 768, "translated immediately to ``PCi_ja`` by `~astropy.wcs.Wcsprm.set` and\nare nowhere visible to the lower-level routines.  In particular,\n`~astropy.wcs.Wcsprm.set` resets `~astropy.wcs.Wcsprm.cdelt` to unity\nif ``CDi_ja`` is present (and no ``PCi_ja``).  If n", 256);
   strncpy(doc_pc + 1024, "o ``CROTAia`` is\nassociated with the latitude axis, `~astropy.wcs.Wcsprm.set` reverts\nto a unity ``PCi_ja`` matrix.\n\x00", 117);

   strncpy(doc_phi0 + 0, "``double`` The native latitude of the fiducial point.\n\nThe point whose celestial coordinates are given in ``ref[1:2]``.  If\nundefined (NaN) the initialization routine, `~astropy.wcs.Wcsprm.set`,\nwill set this to a projection-specific default.\n\nSee also\n---", 256);
   strncpy(doc_phi0 + 256, "-----\nastropy.wcs.Wcsprm.theta0\n\x00", 33);

   strncpy(doc_pix2foc + 0, "pix2foc(*pixcrd, origin*) -> double array[ncoord][nelem]\n\nPerform both `SIP`_ polynomial and `Paper IV`_ lookup-table distortion\ncorrection in parallel.\n\nParameters\n----------\npixcrd : double array[ncoord][nelem]\n    Array of pixel coordinates.\n\n\norigin : ", 256);
   strncpy(doc_pix2foc + 256, "int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nfoccrd : double array[ncoord][nelem]\n    Returns an array of focal plane coordinat", 256);
   strncpy(doc_pix2foc + 512, "es.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nValueError\n    Invalid coordinate transformation parameters.\n\x00", 124);

   strncpy(doc_piximg_matrix + 0, "``double array[2][2]`` (read-only) Matrix containing the product of\nthe ``CDELTia`` diagonal matrix and the ``PCi_ja`` matrix.\n\x00", 128);

   strncpy(doc_power + 0, "``double`` The exponent of the unit conversion.\n\x00", 49);

   strncpy(doc_print_contents + 0, "print_contents()\n\nPrint the contents of the `~astropy.wcs.Wcsprm` object to stdout.\nProbably only useful for debugging purposes, and may be removed in the\nfuture.\n\nTo get a string of the contents, use `repr`.\n\x00", 210);

   strncpy(doc_print_contents_tabprm + 0, "print_contents()\n\nPrint the contents of the `~astropy.wcs._astropy.wcs.Tabprm` object to\nstdout.  Probably only useful for debugging purposes, and may be\nremoved in the future.\n\nTo get a string of the contents, use `repr`.\n\x00", 224);

   strncpy(doc_radesys + 0, "``string`` The equatorial or ecliptic coordinate system type,\n``RADESYSa``.\n\x00", 77);

   strncpy(doc_restfrq + 0, "``double`` Rest frequency (Hz) from ``RESTFRQa``.\n\nAn undefined value is represented by NaN.\n\x00", 94);

   strncpy(doc_restwav + 0, "``double`` Rest wavelength (m) from ``RESTWAVa``.\n\nAn undefined value is represented by NaN.\n\x00", 94);

   strncpy(doc_row + 0, "``int`` (read-only)\n\nTable row number.\n\x00", 40);

   strncpy(doc_s2p + 0, "s2p(world, origin)\n\nTransforms world coordinates to pixel coordinates.\n\nParameters\n----------\nworld : double array[ncoord][nelem]\n    Array of world coordinates, in decimal degrees.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and ", 256);
   strncpy(doc_s2p + 256, "FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nresult : dict\n    Returns a dictionary with the following keys:\n\n    - *phi*: double array[ncoord]\n\n    - *theta*: double array[ncoord]\n\n        ", 256);
   strncpy(doc_s2p + 512, "- Longitude and latitude in the native coordinate system of\n          the projection, in degrees.\n\n    - *imgcrd*: double array[ncoord][nelem]\n\n       - Array of intermediate world coordinates.  For celestial axes,\n         ``imgcrd[][self.lng]`` and ``img", 256);
   strncpy(doc_s2p + 768, "crd[][self.lat]`` are the\n         projected *x*-, and *y*-coordinates, in pseudo \"degrees\".\n         For quadcube projections with a ``CUBEFACE`` axis, the face\n         number is also returned in ``imgcrd[][self.cubeface]``.  For\n         spectral axes, ", 256);
   strncpy(doc_s2p + 1024, "``imgcrd[][self.spec]`` is the intermediate\n         spectral coordinate, in SI units.\n\n    - *pixcrd*: double array[ncoord][nelem]\n\n        - Array of pixel coordinates.  Pixel coordinates are\n          zero-based.\n\n    - *stat*: int array[ncoord]\n\n      ", 256);
   strncpy(doc_s2p + 1280, "  - Status return value for each coordinate. ``0`` for success,\n          ``1+`` for invalid pixel coordinate.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisType", 256);
   strncpy(doc_s2p + 1536, "sError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nInvalidTransformError\n   Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.", 256);
   strncpy(doc_s2p + 1792, "\n\nSee also\n--------\nastropy.wcs.Wcsprm.lat, astropy.wcs.Wcsprm.lng\n    Definition of the latitude and longitude axes\n\x00", 118);

   strncpy(doc_scale + 0, "``double`` The scaling factor for the unit conversion.\n\x00", 56);

   strncpy(doc_sense + 0, "``int array[M]`` +1 if monotonically increasing, -1 if decreasing.\n\nA vector of length `~astropy.wcs._astropy.wcs.Tabprm.M` whose elements\nindicate whether the corresponding indexing vector is monotonically\nincreasing (+1), or decreasing (-1).\n\x00", 245);

   strncpy(doc_set + 0, "set()\n\nSets up a WCS object for use according to information supplied within\nit.\n\nNote that this routine need not be called directly; it will be invoked\nby `~astropy.wcs.Wcsprm.p2s` and `~astropy.wcs.Wcsprm.s2p` if\nnecessary.\n\nSome attributes that are base", 256);
   strncpy(doc_set + 256, "d on other attributes (such as\n`~astropy.wcs.Wcsprm.lattyp` on `~astropy.wcs.Wcsprm.ctype`) may not\nbe correct until after `~astropy.wcs.Wcsprm.set` is called.\n\n`~astropy.wcs.Wcsprm.set` strips off trailing blanks in all string\nmembers.\n\n`~astropy.wcs.Wcsp", 256);
   strncpy(doc_set + 512, "rm.set` recognizes the ``NCP`` projection and\nconverts it to the equivalent ``SIN`` projection and it also\nrecognizes ``GLS`` as a synonym for ``SFL``.  It does alias\ntranslation for the AIPS spectral types (``FREQ-LSR``, ``FELO-HEL``,\netc.) but without ch", 256);
   strncpy(doc_set + 768, "anging the input header keywords.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n  ", 256);
   strncpy(doc_set + 1024, "  Invalid parameter value.\n\nInvalidTransformError\n    Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\x00", 182);

   strncpy(doc_set_ps + 0, "set_ps(list)\n\nSets `PSi_ma` keywords for each *i* and *m*.\n\nParameters\n----------\nps : sequence of tuples\n\n    The input must be a sequence of tuples of the form (*i*, *m*,\n    *value*):\n\n    - *i*: int.  Axis number, as in ``PSi_ma``, (i.e. 1-relative)\n\n ", 256);
   strncpy(doc_set_ps + 256, "   - *m*: int.  Parameter number, as in ``PSi_ma``, (i.e. 0-relative)\n\n    - *value*: string.  Parameter value.\n\nSee also\n--------\nastropy.wcs.Wcsprm.get_ps\n\x00", 158);

   strncpy(doc_set_pv + 0, "set_pv(list)\n\nSets `PVi_ma` keywords for each *i* and *m*.\n\nParameters\n----------\npv : list of tuples\n\n    The input must be a sequence of tuples of the form (*i*, *m*,\n    *value*):\n\n    - *i*: int.  Axis number, as in ``PVi_ma``, (i.e. 1-relative)\n\n    -", 256);
   strncpy(doc_set_pv + 256, " *m*: int.  Parameter number, as in ``PVi_ma``, (i.e. 0-relative)\n\n    - *value*: float.  Parameter value.\n\nSee also\n--------\nastropy.wcs.Wcsprm.get_pv\n\x00", 153);

   strncpy(doc_set_tabprm + 0, "set()\n\nAllocates memory for work arrays.\n\nAlso sets up the class according to information supplied within it.\n\nNote that this routine need not be called directly; it will be invoked\nby functions that need it.\n\nRaises\n------\nMemoryError\n    Memory allocatio", 256);
   strncpy(doc_set_tabprm + 256, "n failed.\n\nInvalidTabularParameters\n    Invalid tabular parameters.\n\x00", 69);

   strncpy(doc_sip + 0, "Get/set the `~astropy.wcs.Sip` object for performing `SIP`_ distortion\ncorrection.\n\x00", 84);

   strncpy(doc_sip_foc2pix + 0, "sip_foc2pix(*foccrd, origin*) -> double array[ncoord][nelem]\n\nConvert focal plane coordinates to pixel coordinates using the `SIP`_\npolynomial distortion convention.\n\nParameters\n----------\nfoccrd : double array[ncoord][nelem]\n    Array of focal plane coord", 256);
   strncpy(doc_sip_foc2pix + 256, "inates.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\npixcrd : double array[ncoord][nelem]\n    Returns an array of pi", 256);
   strncpy(doc_sip_foc2pix + 512, "xel coordinates.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nValueError\n    Invalid coordinate transformation parameters.\n\x00", 137);

   strncpy(doc_sip_pix2foc + 0, "sip_pix2foc(*pixcrd, origin*) -> double array[ncoord][nelem]\n\nConvert pixel coordinates to focal plane coordinates using the `SIP`_\npolynomial distortion convention.\n\nParameters\n----------\npixcrd : double array[ncoord][nelem]\n    Array of pixel coordinates", 256);
   strncpy(doc_sip_pix2foc + 256, ".\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nfoccrd : double array[ncoord][nelem]\n    Returns an array of focal pl", 256);
   strncpy(doc_sip_pix2foc + 512, "ane coordinates.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nValueError\n    Invalid coordinate transformation parameters.\n\x00", 137);

   strncpy(doc_spcfix + 0, "spcfix() -> int\n\nTranslates AIPS-convention spectral coordinate types.  {``FREQ``,\n``VELO``, ``FELO``}-{``OBS``, ``HEL``, ``LSR``} (e.g. ``FREQ-LSR``,\n``VELO-OBS``, ``FELO-HEL``)\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no ch", 256);
   strncpy(doc_spcfix + 256, "ange required.\n\x00", 16);

   strncpy(doc_spec + 0, "``int`` (read-only) The index containing the spectral axis values.\n\x00", 68);

   strncpy(doc_specsys + 0, "``string`` Spectral reference frame (standard of rest), ``SPECSYSa``.\n\nSee also\n--------\nastropy.wcs.Wcsprm.ssysobs, astropy.wcs.Wcsprm.velosys\n\x00", 145);

   strncpy(doc_sptr + 0, "sptr(ctype, i=-1)\n\nTranslates the spectral axis in a WCS object.\n\nFor example, a ``FREQ`` axis may be translated into ``ZOPT-F2W`` and\nvice versa.\n\nParameters\n----------\nctype : string\n    Required spectral ``CTYPEia``, maximum of 8 characters.  The first\n", 256);
   strncpy(doc_sptr + 256, "    four characters are required to be given and are never modified.\n    The remaining four, the algorithm code, are completely determined\n    by, and must be consistent with, the first four characters.\n    Wildcarding may be used, i.e.  if the final three", 256);
   strncpy(doc_sptr + 512, " characters are\n    specified as ``\"???\"``, or if just the eighth character is\n    specified as ``\"?\"``, the correct algorithm code will be\n    substituted and returned.\n\ni : int\n    Index of the spectral axis (0-relative).  If ``i < 0`` (or not\n    provid", 256);
   strncpy(doc_sptr + 768, "ed), it will be set to the first spectral axis identified\n    from the ``CTYPE`` keyvalues in the FITS header.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisType", 256);
   strncpy(doc_sptr + 1024, "sError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nInvalidTransformError\n    Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters", 256);
   strncpy(doc_sptr + 1280, ".\n\nInvalidSubimageSpecificationError\n    Invalid subimage specification (no spectral axis).\n\x00", 93);

   strncpy(doc_ssysobs + 0, "``string`` Spectral reference frame.\n\nThe spectral reference frame in which there is no differential\nvariation in the spectral coordinate across the field-of-view,\n``SSYSOBSa``.\n\nSee also\n--------\nastropy.wcs.Wcsprm.specsys, astropy.wcs.Wcsprm.velosys\n\x00", 253);

   strncpy(doc_ssyssrc + 0, "``string`` Spectral reference frame for redshift.\n\nThe spectral reference frame (standard of rest) in which the redshift\nwas measured, ``SSYSSRCa``.\n\x00", 150);

   strncpy(doc_sub + 0, "sub(axes)\n\nExtracts the coordinate description for a subimage from a\n`~astropy.wcs.WCS` object.\n\nThe world coordinate system of the subimage must be separable in the\nsense that the world coordinates at any point in the subimage must\ndepend only on the pixe", 256);
   strncpy(doc_sub + 256, "l coordinates of the axes extracted.  In\npractice, this means that the ``PCi_ja`` matrix of the original image\nmust not contain non-zero off-diagonal terms that associate any of the\nsubimage axes with any of the non-subimage axes.\n\n`sub` can also add axes ", 256);
   strncpy(doc_sub + 512, "to a wcsprm object.  The new axes will be\ncreated using the defaults set by the Wcsprm constructor which produce\na simple, unnamed, linear axis with world coordinates equal to the\npixel coordinate.  These default values can be changed before\ninvoking `set`", 256);
   strncpy(doc_sub + 768, ".\n\nParameters\n----------\naxes : int or a sequence.\n\n    - If an int, include the first *N* axes in their original order.\n\n    - If a sequence, may contain a combination of image axis numbers\n      (1-relative) or special axis identifiers (see below).  Orde", 256);
   strncpy(doc_sub + 1024, "r is\n      significant; ``axes[0]`` is the axis number of the input image\n      that corresponds to the first axis in the subimage, etc.  Use an\n      axis number of 0 to create a new axis using the defaults.\n\n    - If ``0``, ``[]`` or ``None``, do a deep ", 256);
   strncpy(doc_sub + 1280, "copy.\n\n    Coordinate axes types may be specified using either strings or\n    special integer constants.  The available types are:\n\n    - ``\'longitude\'`` / ``WCSSUB_LONGITUDE``: Celestial longitude\n\n    - ``\'latitude\'`` / ``WCSSUB_LATITUDE``: Celestial lat", 256);
   strncpy(doc_sub + 1536, "itude\n\n    - ``\'cubeface\'`` / ``WCSSUB_CUBEFACE``: Quadcube ``CUBEFACE`` axis\n\n    - ``\'spectral\'`` / ``WCSSUB_SPECTRAL``: Spectral axis\n\n    - ``\'stokes\'`` / ``WCSSUB_STOKES``: Stokes axis\n\n    - ``\'celestial\'`` / ``WCSSUB_CELESTIAL``: An alias for the\n  ", 256);
   strncpy(doc_sub + 1792, "    combination of ``\'longitude\'``, ``\'latitude\'`` and ``\'cubeface\'``.\n\nReturns\n-------\nnew_wcs : `~astropy.wcs.WCS` object\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nInvalidSubimageSpecificationError\n    Invalid subimage specification (no s", 256);
   strncpy(doc_sub + 2048, "pectral axis).\n\nNonseparableSubimageCoordinateSystem\n    Non-separable subimage coordinate system.\n\nNotes\n-----\nCombinations of subimage axes of particular types may be extracted in\nthe same order as they occur in the input image by combining the\ninteger c", 256);
   strncpy(doc_sub + 2304, "onstants with the \'binary or\' (``|``) operator.  For\nexample::\n\n    wcs.sub([WCSSUB_LONGITUDE | WCSSUB_LATITUDE | WCSSUB_SPECTRAL])\n\nwould extract the longitude, latitude, and spectral axes in the same\norder as the input image.  If one of each were present", 256);
   strncpy(doc_sub + 2560, ", the resulting\nobject would have three dimensions.\n\nFor convenience, ``WCSSUB_CELESTIAL`` is defined as the combination\n``WCSSUB_LONGITUDE | WCSSUB_LATITUDE | WCSSUB_CUBEFACE``.\n\nThe codes may also be negated to extract all but the types specified,\nfor ex", 256);
   strncpy(doc_sub + 2816, "ample::\n\n    wcs.sub([\n      WCSSUB_LONGITUDE,\n      WCSSUB_LATITUDE,\n      WCSSUB_CUBEFACE,\n      -(WCSSUB_SPECTRAL | WCSSUB_STOKES)])\n\nThe last of these specifies all axis types other than spectral or\nStokes.  Extraction is done in the order specified by", 256);
   strncpy(doc_sub + 3072, " `axes`, i.e. a\nlongitude axis (if present) would be extracted first (via ``axes[0]``)\nand not subsequently (via ``axes[3]``).  Likewise for the latitude and\ncubeface axes in this example.\n\nThe number of dimensions in the returned object may be less than o", 256);
   strncpy(doc_sub + 3328, "r\ngreater than the length of `axes`.  However, it will never exceed the\nnumber of axes in the input image.\n\x00", 108);

   strncpy(doc_tab + 0, "``list of Tabprm`` Tabular coordinate objects.\n\nA list of tabular coordinate objects associated with this WCS.\n\x00", 112);

   strncpy(doc_theta0 + 0, "``double``  The native longitude of the fiducial point.\n\nThe point whose celestial coordinates are given in ``ref[1:2]``.  If\nundefined (NaN) the initialization routine, `~astropy.wcs.Wcsprm.set`,\nwill set this to a projection-specific default.\n\nSee also\n-", 256);
   strncpy(doc_theta0 + 256, "-------\nastropy.wcs.Wcsprm.phi0\n\x00", 33);

   strncpy(doc_to_header + 0, "to_header(relax=False)\n\n`to_header` translates a WCS object into a FITS header.\n\nThe details of the header depends on context:\n\n    - If the `~astropy.wcs.Wcsprm.colnum` member is non-zero then a\n      binary table image array header will be produced.\n\n   ", 256);
   strncpy(doc_to_header + 256, " - Otherwise, if the `~astropy.wcs.Wcsprm.colax` member is set\n      non-zero then a pixel list header will be produced.\n\n    - Otherwise, a primary image or image extension header will be\n      produced.\n\nThe output header will almost certainly differ fro", 256);
   strncpy(doc_to_header + 512, "m the input in a\nnumber of respects:\n\n    1. The output header only contains WCS-related keywords.  In\n       particular, it does not contain syntactically-required keywords\n       such as ``SIMPLE``, ``NAXIS``, ``BITPIX``, or ``END``.\n\n    2. Deprecated (", 256);
   strncpy(doc_to_header + 768, "e.g. ``CROTAn``) or non-standard usage will be\n       translated to standard (this is partially dependent on whether\n       `fix` was applied).\n\n    3. Quantities will be converted to the units used internally,\n       basically SI with the addition of degr", 256);
   strncpy(doc_to_header + 1024, "ees.\n\n    4. Floating-point quantities may be given to a different decimal\n       precision.\n\n    5. Elements of the ``PCi_j`` matrix will be written if and only if\n       they differ from the unit matrix.  Thus, if the matrix is unity\n       then no eleme", 256);
   strncpy(doc_to_header + 1280, "nts will be written.\n\n    6. Additional keywords such as ``WCSAXES``, ``CUNITia``,\n       ``LONPOLEa`` and ``LATPOLEa`` may appear.\n\n    7. The original keycomments will be lost, although\n       `~astropy.wcs.Wcsprm.to_header` tries hard to write meaningfu", 256);
   strncpy(doc_to_header + 1536, "l\n       comments.\n\n    8. Keyword order may be changed.\n\nKeywords can be translated between the image array, binary table, and\npixel lists forms by manipulating the `~astropy.wcs.Wcsprm.colnum` or\n`~astropy.wcs.Wcsprm.colax` members of the `~astropy.wcs.W", 256);
   strncpy(doc_to_header + 1792, "csprm.WCS`\nobject.\n\nParameters\n----------\n\nrelax : bool or int\n    Degree of permissiveness:\n\n    - `False`: Recognize only FITS keywords defined by the published\n      WCS standard.\n\n    - `True`: Admit all recognized informal extensions of the WCS\n      ", 256);
   strncpy(doc_to_header + 2048, "standard.\n\n    - `int`: a bit field selecting specific extensions to write.\n      See :ref:`relaxwrite` for details.\n\nReturns\n-------\nheader : str\n    Raw FITS header as a string.\n\x00", 181);

   strncpy(doc_ttype + 0, "``str`` (read-only)\n\n``TTYPEn`` identifying the column of the binary table that contains\nthe wcstab array.\n\x00", 108);

   strncpy(doc_unitfix + 0, "unitfix(translate_units=\'\')\n\nTranslates non-standard ``CUNITia`` keyvalues.\n\nFor example, ``DEG`` -> ``deg``, also stripping off unnecessary\nwhitespace.\n\nParameters\n----------\ntranslate_units : string, optional\n    Do potentially unsafe translations of non", 256);
   strncpy(doc_unitfix + 256, "-standard unit strings.\n\n    Although ``\"S\"`` is commonly used to represent seconds, its\n    recognizes ``\"S\"`` formally as Siemens, however rarely that may\n    be translation to ``\"s\"`` is potentially unsafe since the\n    standard used.  The same applies ", 256);
   strncpy(doc_unitfix + 512, "to ``\"H\"`` for hours (Henry),\n    and ``\"D\"`` for days (Debye).\n\n    This string controls what to do in such cases, and is\n    case-insensitive.\n\n    - If the string contains ``\"s\"``, translate ``\"S\"`` to ``\"s\"``.\n\n    - If the string contains ``\"h\"``, tra", 256);
   strncpy(doc_unitfix + 768, "nslate ``\"H\"`` to ``\"h\"``.\n\n    - If the string contains ``\"d\"``, translate ``\"D\"`` to ``\"d\"``.\n\n    Thus ``\'\'`` doesn\'t do any unsafe translations, whereas ``\'shd\'``\n    does all of them.\n\n    See :ref:`fits-unit` for more information.\n\nReturns\n-------\nsu", 256);
   strncpy(doc_unitfix + 1024, "ccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00", 74);

   strncpy(doc_velangl + 0, "``double`` Velocity angle.\n\nThe angle in degrees that should be used to decompose an observed\nvelocity into radial and transverse components.\n\nAn undefined value is represented by NaN.\n\x00", 186);

   strncpy(doc_velosys + 0, "``double`` Relative radial velocity.\n\nThe relative radial velocity (m/s) between the observer and the\nselected standard of rest in the direction of the celestial reference\ncoordinate, ``VELOSYSa``.\n\nAn undefined value is represented by NaN.\n\nSee also\n-----", 256);
   strncpy(doc_velosys + 256, "---\nastropy.wcs.Wcsprm.specsys, astropy.wcs.Wcsprm.ssysobs\n\x00", 60);

   strncpy(doc_want + 0, "``string`` The name of the unit being converted to.\n\nThis value always uses standard unit names, even if the\n`UnitConverter` was initialized with a non-standard unit name.\n\x00", 173);

   strncpy(doc_wcs + 0, "A `~astropy.wcs.Wcsprm` object to perform the basic `wcslib`_ WCS\ntransformation.\n\x00", 83);

   strncpy(doc_zsource + 0, "``double`` The redshift, ``ZSOURCEa``, of the source.\n\nAn undefined value is represented by NaN.\n\x00", 98);


}

#else /* UNIX */
char doc_DistortionLookupTable[374] = "DistortionLookupTable(*table*, *crpix*, *crval*, *cdelt*)\n\nRepresents a single lookup table for a `Paper IV`_ distortion\ntransformation.\n\nParameters\n----------\ntable : 2-dimensional array\n    The distortion lookup table.\n\ncrpix : 2-tuple\n    The distortion array reference pixel\n\ncrval : 2-tuple\n    The image array pixel coordinate\n\ncdelt : 2-tuple\n    The grid step size\n\x00";

char doc_K[202] = "``int array[M]`` (read-only) The lengths of the axes of the coordinate\narray.\n\nAn array of length `M` whose elements record the lengths of the axes of\nthe coordinate array and of each indexing vector.\n\x00";

char doc_M[56] = "``int`` (read-only) Number of tabular coordinate axes.\n\x00";

char doc_Sip[1040] = "Sip(*a, b, ap, bp, crpix*)\n\nThe `~astropy.wcs.Sip` class performs polynomial distortion correction\nusing the `SIP`_ convention in both directions.\n\nParameters\n----------\na : double array[m+1][m+1]\n    The ``A_i_j`` polynomial for pixel to focal plane transformation.\n    Its size must be (*m* + 1, *m* + 1) where *m* = ``A_ORDER``.\n\nb : double array[m+1][m+1]\n    The ``B_i_j`` polynomial for pixel to focal plane transformation.\n    Its size must be (*m* + 1, *m* + 1) where *m* = ``B_ORDER``.\n\nap : double array[m+1][m+1]\n    The ``AP_i_j`` polynomial for pixel to focal plane transformation.\n    Its size must be (*m* + 1, *m* + 1) where *m* = ``AP_ORDER``.\n\nbp : double array[m+1][m+1]\n    The ``BP_i_j`` polynomial for pixel to focal plane transformation.\n    Its size must be (*m* + 1, *m* + 1) where *m* = ``BP_ORDER``.\n\ncrpix : double array[2]\n    The reference pixel.\n\nNotes\n-----\nShupe, D. L., M. Moshir, J. Li, D. Makovoz and R. Narron.  2005.\n\"The SIP Convention for Representing Distortion in FITS Image\nHeaders.\"  ADASS XIV.\n\x00";

char doc_Tabprm[234] = "A class to store the information related to tabular coordinates,\ni.e., coordinates that are defined via a lookup table.\n\nThis class can not be constructed directly from Python, but instead is\nreturned from `~astropy.wcs.Wcsprm.tab`.\n\x00";

char doc_UnitConverter[2246] = "UnitConverter(have, want, translate_units=\'\')\n\nAn object for converting from one system of units to another.\n\nUse the returned object\'s `~astropy.wcs.UnitConverter.convert` method\nto convert values from *have* to *want*.\n\nThis function is permissive in accepting whitespace in all contexts in\na units specification where it does not create ambiguity (e.g. not\nbetween a metric prefix and a basic unit string), including in strings\nlike ``\"log (m ** 2)\"`` which is formally disallowed.\n\nParameters\n----------\n\nhave : string\n    :ref:`fits-unit` to convert from, with or without surrounding\n    square brackets (for inline specifications); text following the\n    closing bracket is ignored.\n\nwant : string\n    :ref:`fits-unit` to convert to, with or without surrounding square\n    brackets (for inline specifications); text following the closing\n    bracket is ignored.\n\nctrl : string, optional\n    Do potentially unsafe translations of non-standard unit strings.\n\n    Although ``\"S\"`` is commonly used to represent seconds, its\n    recognizes ``\"S\"`` formally as Siemens, however rarely that may\n    be translation to ``\"s\"`` is potentially unsafe since the\n    standard used.  The same applies to ``\"H\"`` for hours (Henry),\n    and ``\"D\"`` for days (Debye).\n\n    This string controls what to do in such cases, and is\n    case-insensitive.\n\n    - If the string contains ``\"s\"``, translate ``\"S\"`` to ``\"s\"``.\n\n    - If the string contains ``\"h\"``, translate ``\"H\"`` to ``\"h\"``.\n\n    - If the string contains ``\"d\"``, translate ``\"D\"`` to ``\"d\"``.\n\n    Thus ``\'\'`` doesn\'t do any unsafe translations, whereas ``\'shd\'``\n    does all of them.\n\n    See :ref:`fits-unit` for more information.\n\nRaises\n------\nValueError\n    Invalid numeric multiplier.\n\nSyntaxError\n    Dangling binary operator.\n\nSyntaxError\n    Invalid symbol in INITIAL context.\n\nSyntaxError\n    Function in invalid context.\n\nSyntaxError\n    Invalid symbol in EXPON context.\n\nSyntaxError\n    Unbalanced bracket.\n\nSyntaxError\n    Unbalanced parenthesis.\n\nSyntaxError\n    Consecutive binary operators.\n\nSyntaxError\n    Internal parser error.\n\nSyntaxError\n    Non-conformant unit specifications.\n\nSyntaxError\n    Non-conformant functions.\n\nValueError\n    Potentially unsafe translation.\n\x00";

char doc_Wcs[513] = "Wcs(*sip, cpdis, wcsprm, det2im*)\n\nWcs objects amalgamate basic WCS (as provided by `wcslib`_), with\n`SIP`_ and `Paper IV`_ distortion operations.\n\nTo perform all distortion corrections and WCS tranformation, use\n`all_pix2world`.\n\nParameters\n----------\nsip : `~astropy.wcs.Sip` object or `None`\n\ncpdis : A pair of `~astropy.wcs.DistortionLookupTable` objects, or\n  ``(None, None)``.\n\nwcsprm : `~astropy.wcs.Wcsprm` object\n\ndet2im : A pair of `~astropy.wcs.DistortionLookupTable` objects, or\n   ``(None, None)``.\n\x00";

char doc_Wcsprm[2089] = "Wcsprm(header=None, key=\' \', relax=False, naxis=2, keysel=0, colsel=None)\n\n`~astropy.wcs.Wcsprm` is a direct wrapper around `wcslib`_, and\nprovides access to the core WCS transformations that it supports.\n\nThe FITS header parsing enforces correct FITS \"keyword = value\" syntax\nwith regard to the equals sign occurring in columns 9 and 10.\nHowever, it does recognize free-format character (NOST 100-2.0,\nSect. 5.2.1), integer (Sect. 5.2.3), and floating-point values\n(Sect. 5.2.4) for all keywords.\n\nParameters\n----------\nheader : An astropy.io.fits header, string, or `None`.\n  If ``None``, the object will be initialized to default values.\n\nkey : string, optional\n    The key referring to a particular WCS transform in the header.\n    This may be either ``\' \'`` or ``\'A\'``-``\'Z\'`` and corresponds to\n    the ``\"a\"`` part of ``\"CTYPEia\"``.  (*key* may only be\n    provided if *header* is also provided.)\n\nrelax : bool or int, optional\n\n    Degree of permissiveness:\n\n    - `False`: Recognize only FITS keywords defined by the published\n      WCS standard.\n\n    - `True`: Admit all recognized informal extensions of the WCS\n      standard.\n\n    - `int`: a bit field selecting specific extensions to accept.  See\n      :ref:`relaxread` for details.\n\nnaxis : int, optional\n    The number of world coordinates axes for the object.  (*naxis* may\n    only be provided if *header* is `None`.)\n\nkeysel : sequence of flag bits, optional\n    Vector of flag bits that may be used to restrict the keyword types\n    considered:\n\n        - ``WCSHDR_IMGHEAD``: Image header keywords.\n\n        - ``WCSHDR_BIMGARR``: Binary table image array.\n\n        - ``WCSHDR_PIXLIST``: Pixel list keywords.\n\n    If zero, there is no restriction.  If -1, the underlying wcslib\n    function ``wcspih()`` is called, rather than ``wcstbh()``.\n\ncolsel : sequence of int\n    A sequence of table column numbers used to restrict the keywords\n    considered.  `None` indicates no restriction.\n\nRaises\n------\nMemoryError\n     Memory allocation failed.\n\nValueError\n     Invalid key.\n\nKeyError\n     Key not found in FITS header.\n\x00";

char doc_Wtbarr[202] = "Classes to construct coordinate lookup tables from a binary table\nextension (BINTABLE).\n\nThis class can not be constructed directly from Python, but instead is\nreturned from `~astropy.wcs.Wcsprm.wtb`.\n\x00";

char doc_a[264] = "``double array[a_order+1][a_order+1]`` Focal plane transformation\nmatrix.\n\nThe `SIP`_ ``A_i_j`` matrix used for pixel to focal plane\ntransformation.\n\nIts values may be changed in place, but it may not be resized, without\ncreating a new `~astropy.wcs.Sip` object.\n\x00";

char doc_a_order[60] = "``int`` (read-only) Order of the polynomial (``A_ORDER``).\n\x00";

char doc_all_pix2world[1268] = "all_pix2world(pixcrd, origin) -> ``double array[ncoord][nelem]``\n\nTransforms pixel coordinates to world coordinates.\n\nDoes the following:\n\n    - Detector to image plane correction (optionally)\n\n    - SIP distortion correction (optionally)\n\n    - Paper IV distortion correction (optionally)\n\n    - wcslib WCS transformation\n\nThe first three (the distortion corrections) are done in parallel.\n\nParameters\n----------\npixcrd : double array[ncoord][nelem]\n    Array of pixel coordinates.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nworld : double array[ncoord][nelem]\n    Returns an array of world coordinates.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nValueError\n    Invalid coordinate transformation parameters.\n\nValueError\n    x- and y-coordinate arrays are not the same size.\n\nInvalidTransformError\n    Invalid coordinate transformation.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\x00";

char doc_alt[236] = "``str`` Character code for alternate coordinate descriptions.\n\nFor example, the ``\"a\"`` in keyword names such as ``CTYPEia``.  This\nis a space character for the primary coordinate description, or one of\nthe 26 upper-case letters, A-Z.\n\x00";

char doc_ap[276] = "``double array[ap_order+1][ap_order+1]`` Focal plane to pixel\ntransformation matrix.\n\nThe `SIP`_ ``AP_i_j`` matrix used for focal plane to pixel\ntransformation.  Its values may be changed in place, but it may not be\nresized, without creating a new `~astropy.wcs.Sip` object.\n\x00";

char doc_ap_order[61] = "``int`` (read-only) Order of the polynomial (``AP_ORDER``).\n\x00";

char doc_axis_types[916] = "``int array[naxis]`` An array of four-digit type codes for each axis.\n\n- First digit (i.e. 1000s):\n\n  - 0: Non-specific coordinate type.\n\n  - 1: Stokes coordinate.\n\n  - 2: Celestial coordinate (including ``CUBEFACE``).\n\n  - 3: Spectral coordinate.\n\n- Second digit (i.e. 100s):\n\n  - 0: Linear axis.\n\n  - 1: Quantized axis (``STOKES``, ``CUBEFACE``).\n\n  - 2: Non-linear celestial axis.\n\n  - 3: Non-linear spectral axis.\n\n  - 4: Logarithmic axis.\n\n  - 5: Tabular axis.\n\n- Third digit (i.e. 10s):\n\n  - 0: Group number, e.g. lookup table number\n\n- The fourth digit is used as a qualifier depending on the axis type.\n\n  - For celestial axes:\n\n    - 0: Longitude coordinate.\n\n    - 1: Latitude coordinate.\n\n    - 2: ``CUBEFACE`` number.\n\n  - For lookup tables: the axis number in a multidimensional table.\n\n``CTYPEia`` in ``\"4-3\"`` form with unrecognized algorithm code will\nhave its type set to -1 and generate an error.\n\x00";

char doc_b[273] = "``double array[b_order+1][b_order+1]`` Pixel to focal plane\ntransformation matrix.\n\nThe `SIP`_ ``B_i_j`` matrix used for pixel to focal plane\ntransformation.  Its values may be changed in place, but it may not be\nresized, without creating a new `~astropy.wcs.Sip` object.\n\x00";

char doc_b_order[60] = "``int`` (read-only) Order of the polynomial (``B_ORDER``).\n\x00";

char doc_bp[276] = "``double array[bp_order+1][bp_order+1]`` Focal plane to pixel\ntransformation matrix.\n\nThe `SIP`_ ``BP_i_j`` matrix used for focal plane to pixel\ntransformation.  Its values may be changed in place, but it may not be\nresized, without creating a new `~astropy.wcs.Sip` object.\n\x00";

char doc_bp_order[61] = "``int`` (read-only) Order of the polynomial (``BP_ORDER``).\n\x00";

char doc_cd[1074] = "``double array[naxis][naxis]`` The ``CDi_ja`` linear transformation\nmatrix.\n\nFor historical compatibility, three alternate specifications of the\nlinear transforations are available in wcslib.  The canonical\n``PCi_ja`` with ``CDELTia``, and the deprecated ``CDi_ja`` and\n``CROTAia`` keywords.  Although the deprecated versions may not\nformally co-exist with ``PCi_ja``, the approach here is simply to\nignore them if given in conjunction with ``PCi_ja``.\n\n`~astropy.wcs.Wcsprm.has_pc`, `~astropy.wcs.Wcsprm.has_cd` and\n`~astropy.wcs.Wcsprm.has_crota` can be used to determine which of\nthese alternatives are present in the header.\n\nThese alternate specifications of the linear transformation matrix are\ntranslated immediately to ``PCi_ja`` by `~astropy.wcs.Wcsprm.set` and\nare nowhere visible to the lower-level routines.  In particular,\n`~astropy.wcs.Wcsprm.set` resets `~astropy.wcs.Wcsprm.cdelt` to unity\nif ``CDi_ja`` is present (and no ``PCi_ja``).  If no ``CROTAia`` is\nassociated with the latitude axis, `~astropy.wcs.Wcsprm.set` reverts\nto a unity ``PCi_ja`` matrix.\n\x00";

char doc_cdelt[308] = "``double array[naxis]`` Coordinate increments (``CDELTia``) for each\ncoord axis.\n\nIf a ``CDi_ja`` linear transformation matrix is present, a warning is\nraised and `~astropy.wcs.Wcsprm.cdelt` is ignored.  The ``CDi_ja``\nmatrix may be deleted by::\n\n  del wcs.wcs.cd\n\nAn undefined value is represented by NaN.\n\x00";

char doc_cdfix[480] = "cdfix()\n\nFix erroneously omitted ``CDi_ja`` keywords.\n\nSets the diagonal element of the ``CDi_ja`` matrix to unity if all\n``CDi_ja`` keywords associated with a given axis were omitted.\nAccording to Paper I, if any ``CDi_ja`` keywords at all are given in a\nFITS header then those not given default to zero.  This results in a\nsingular matrix with an intersecting row and column of zeros.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00";

char doc_cel_offset[176] = "``boolean`` Is there an offset?\n\nIf `True`, an offset will be applied to ``(x, y)`` to force ``(x, y) =\n(0, 0)`` at the fiducial point, (phi_0, theta_0).  Default is `False`.\n\x00";

char doc_celfix[171] = "Translates AIPS-convention celestial projection types, ``-NCP`` and\n``-GLS``.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00";

char doc_cname[76] = "``list of strings`` A list of the coordinate axis names, from\n``CNAMEia``.\n\x00";

char doc_colax[91] = "``int array[naxis]`` An array recording the column numbers for each\naxis in a pixel list.\n\x00";

char doc_colnum[290] = "``int`` Column of FITS binary table associated with this WCS.\n\nWhere the coordinate representation is associated with an image-array\ncolumn in a FITS binary table, this property may be used to record the\nrelevant column number.\n\nIt should be set to zero for an image header or pixel list.\n\x00";

char doc_convert[121] = "convert(array)\n\nPerform the unit conversion on the elements of the given *array*,\nreturning an array of the same shape.\n\x00";

char doc_coord[290] = "``double array[K_M]...[K_2][K_1][M]`` The tabular coordinate array.\n\nHas the dimensions::\n\n    (K_M, ... K_2, K_1, M)\n\n(see `~astropy.wcs._astropy.wcs.Tabprm.K`) i.e. with the `M` dimension\nvarying fastest so that the `M` elements of a coordinate vector are\nstored contiguously in memory.\n\x00";

char doc_copy[40] = "Creates a deep copy of the WCS object.\n\x00";

char doc_cpdis1[106] = "`~astropy.wcs.DistortionLookupTable`\n\nThe pre-linear transformation distortion lookup table, ``CPDIS1``.\n\x00";

char doc_cpdis2[106] = "`~astropy.wcs.DistortionLookupTable`\n\nThe pre-linear transformation distortion lookup table, ``CPDIS2``.\n\x00";

char doc_crder[123] = "``double array[naxis]`` The random error in each coordinate axis,\n``CRDERia``.\n\nAn undefined value is represented by NaN.\n\x00";

char doc_crota[1070] = "``double array[naxis]`` ``CROTAia`` keyvalues for each coordinate\naxis.\n\nFor historical compatibility, three alternate specifications of the\nlinear transforations are available in wcslib.  The canonical\n``PCi_ja`` with ``CDELTia``, and the deprecated ``CDi_ja`` and\n``CROTAia`` keywords.  Although the deprecated versions may not\nformally co-exist with ``PCi_ja``, the approach here is simply to\nignore them if given in conjunction with ``PCi_ja``.\n\n`~astropy.wcs.Wcsprm.has_pc`, `~astropy.wcs.Wcsprm.has_cd` and\n`~astropy.wcs.Wcsprm.has_crota` can be used to determine which of\nthese alternatives are present in the header.\n\nThese alternate specifications of the linear transformation matrix are\ntranslated immediately to ``PCi_ja`` by `~astropy.wcs.Wcsprm.set` and\nare nowhere visible to the lower-level routines.  In particular,\n`~astropy.wcs.Wcsprm.set` resets `~astropy.wcs.Wcsprm.cdelt` to unity\nif ``CDi_ja`` is present (and no ``PCi_ja``).  If no ``CROTAia`` is\nassociated with the latitude axis, `~astropy.wcs.Wcsprm.set` reverts\nto a unity ``PCi_ja`` matrix.\n\x00";

char doc_crpix[88] = "``double array[naxis]`` Coordinate reference pixels (``CRPIXja``) for\neach pixel axis.\n\x00";

char doc_crval[93] = "``double array[naxis]`` Coordinate reference values (``CRVALia``) for\neach coordinate axis.\n\x00";

char doc_crval_tabprm[94] = "``double array[M]`` Index values for the reference pixel for each of\nthe tabular coord axes.\n\x00";

char doc_csyer[132] = "``double array[naxis]`` The systematic error in the coordinate value\naxes, ``CSYERia``.\n\nAn undefined value is represented by NaN.\n\x00";

char doc_ctype[228] = "``list of strings[naxis]`` List of ``CTYPEia`` keyvalues.\n\nThe `~astropy.wcs.Wcsprm.ctype` keyword values must be in upper case\nand there must be zero or one pair of matched celestial axis types,\nand zero or one spectral axis.\n\x00";

char doc_cubeface[1236] = "``int`` Index into the ``pixcrd`` (pixel coordinate) array for the\n``CUBEFACE`` axis.\n\nThis is used for quadcube projections where the cube faces are stored\non a separate axis.\n\nThe quadcube projections (``TSC``, ``CSC``, ``QSC``) may be\nrepresented in FITS in either of two ways:\n\n    - The six faces may be laid out in one plane and numbered as\n      follows::\n\n\n                                       0\n\n                              4  3  2  1  4  3  2\n\n                                       5\n\n      Faces 2, 3 and 4 may appear on one side or the other (or both).\n      The world-to-pixel routines map faces 2, 3 and 4 to the left but\n      the pixel-to-world routines accept them on either side.\n\n    - The ``COBE`` convention in which the six faces are stored in a\n      three-dimensional structure using a ``CUBEFACE`` axis indexed\n      from 0 to 5 as above.\n\nThese routines support both methods; `~astropy.wcs.Wcsprm.set`\ndetermines which is being used by the presence or absence of a\n``CUBEFACE`` axis in `~astropy.wcs.Wcsprm.ctype`.\n`~astropy.wcs.Wcsprm.p2s` and `~astropy.wcs.Wcsprm.s2p` translate the\n``CUBEFACE`` axis representation to the single plane representation\nunderstood by the lower-level projection routines.\n\x00";

char doc_cunit[1272] = "``list of strings[naxis]`` List of ``CUNITia`` keyvalues.\n\nThese define the units of measurement of the ``CRVALia``, ``CDELTia``\nand ``CDi_ja`` keywords.\n\nAs ``CUNITia`` is an optional header keyword,\n`~astropy.wcs.Wcsprm.cunit` may be left blank but otherwise is\nexpected to contain a standard units specification as defined by WCS\nPaper I.  `~astropy.wcs.Wcsprm.unitfix` is available to translate\ncommonly used non-standard units specifications but this must be done\nas a separate step before invoking `~astropy.wcs.Wcsprm.set`.\n\nFor celestial axes, if `~astropy.wcs.Wcsprm.cunit` is not blank,\n`~astropy.wcs.Wcsprm.set` uses `wcsunits` to parse it and scale\n`~astropy.wcs.Wcsprm.cdelt`, `~astropy.wcs.Wcsprm.crval`, and\n`~astropy.wcs.Wcsprm.cd` to decimal degrees.  It then resets\n`~astropy.wcs.Wcsprm.cunit` to ``\"deg\"``.\n\nFor spectral axes, if `~astropy.wcs.Wcsprm.cunit` is not blank,\n`~astropy.wcs.Wcsprm.set` uses `wcsunits` to parse it and scale\n`~astropy.wcs.Wcsprm.cdelt`, `~astropy.wcs.Wcsprm.crval`, and\n`~astropy.wcs.Wcsprm.cd` to SI units.  It then resets\n`~astropy.wcs.Wcsprm.cunit` accordingly.\n\n`~astropy.wcs.Wcsprm.set` ignores `~astropy.wcs.Wcsprm.cunit` for\nother coordinate types; `~astropy.wcs.Wcsprm.cunit` may be used to\nlabel coordinate values.\n\x00";

char doc_cylfix[162] = "cylfix()\n\nFixes WCS keyvalues for malformed cylindrical projections.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00";

char doc_data[78] = "``float array`` The array data for the\n`~astropy.wcs.DistortionLookupTable`.\n\x00";

char doc_data_wtbarr[52] = "``double array``\n\nThe array data for the BINTABLE.\n\x00";

char doc_dateavg[152] = "``string`` Representative mid-point of the date of observation.\n\nIn ISO format, ``yyyy-mm-ddThh:mm:ss``.\n\nSee also\n--------\nastropy.wcs.Wcsprm.dateobs\n\x00";

char doc_dateobs[133] = "``string`` Start of the date of observation.\n\nIn ISO format, ``yyyy-mm-ddThh:mm:ss``.\n\nSee also\n--------\nastropy.wcs.Wcsprm.dateavg\n\x00";

char doc_datfix[512] = "datfix()\n\nTranslates the old ``DATE-OBS`` date format to year-2000 standard form\n``(yyyy-mm-ddThh:mm:ss)`` and derives ``MJD-OBS`` from it if not\nalready set.\n\nAlternatively, if `~astropy.wcs.Wcsprm.mjdobs` is set and\n`~astropy.wcs.Wcsprm.dateobs` isn\'t, then `~astropy.wcs.Wcsprm.datfix`\nderives `~astropy.wcs.Wcsprm.dateobs` from it.  If both are set but\ndisagree by more than half a day then `ValueError` is raised.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00";

char doc_delta[251] = "``double array[M]`` (read-only) Interpolated indices into the coord\narray.\n\nArray of interpolated indices into the coordinate array such that\nUpsilon_m, as defined in Paper III, is equal to\n(`~astropy.wcs._astropy.wcs.Tabprm.p0` [m] + 1) + delta[m].\n\x00";

char doc_det2im[58] = "Convert detector coordinates to image plane coordinates.\n\x00";

char doc_det2im1[103] = "A `~astropy.wcs.DistortionLookupTable` object for detector to image plane\ncorrection in the *x*-axis.\n\x00";

char doc_det2im2[103] = "A `~astropy.wcs.DistortionLookupTable` object for detector to image plane\ncorrection in the *y*-axis.\n\x00";

char doc_dims[111] = "``int array[ndim]`` (read-only)\n\nThe dimensions of the tabular array\n`~astropy.wcs._astropy.wcs.Wtbarr.data`.\n\x00";

char doc_equinox[243] = "``double`` The equinox associated with dynamical equatorial or\necliptic coordinate systems.\n\n``EQUINOXa`` (or ``EPOCH`` in older headers).  Not applicable to ICRS\nequatorial or ecliptic coordinates.\n\nAn undefined value is represented by NaN.\n\x00";

char doc_extlev[73] = "``int`` (read-only)\n\n``EXTLEV`` identifying the binary table extension.\n\x00";

char doc_extnam[74] = "``str`` (read-only)\n\n``EXTNAME`` identifying the binary table extension.\n\x00";

char doc_extrema[452] = "``double array[K_M]...[K_2][2][M]`` (read-only)\n\nAn array recording the minimum and maximum value of each element of\nthe coordinate vector in each row of the coordinate array, with the\ndimensions::\n\n    (K_M, ... K_2, 2, M)\n\n(see `~astropy.wcs._astropy.wcs.Tabprm.K`).  The minimum is recorded\nin the first element of the compressed K_1 dimension, then the\nmaximum.  This array is used by the inverse table lookup function to\nspeed up table searches.\n\x00";

char doc_extver[73] = "``int`` (read-only)\n\n``EXTVER`` identifying the binary table extension.\n\x00";

char doc_find_all_wcs[880] = "find_all_wcs(relax=0, keysel=0)\n\nFind all WCS transformations in the header.\n\nParameters\n----------\n\nheader : str\n    The raw FITS header data.\n\nrelax : bool or int\n    Degree of permissiveness:\n\n    - `False`: Recognize only FITS keywords defined by the published\n      WCS standard.\n\n    - `True`: Admit all recognized informal extensions of the WCS\n      standard.\n\n    - `int`: a bit field selecting specific extensions to accept.  See\n      :ref:`relaxread` for details.\n\nkeysel : sequence of flags\n    Used to restrict the keyword types considered:\n\n    - ``WCSHDR_IMGHEAD``: Image header keywords.\n\n    - ``WCSHDR_BIMGARR``: Binary table image array.\n\n    - ``WCSHDR_PIXLIST``: Pixel list keywords.\n\n    If zero, there is no restriction.  If -1, `wcspih` is called,\n    rather than `wcstbh`.\n\nReturns\n-------\nwcs_list : list of `~astropy.wcs._astropy.wcs._Wcsprm` objects\n\x00";

char doc_fix[1613] = "fix(translate_units=\'\', naxis=0)\n\nApplies all of the corrections handled separately by\n`~astropy.wcs.Wcsprm.datfix`, `~astropy.wcs.Wcsprm.unitfix`,\n`~astropy.wcs.Wcsprm.celfix`, `~astropy.wcs.Wcsprm.spcfix`,\n`~astropy.wcs.Wcsprm.cylfix` and `~astropy.wcs.Wcsprm.cdfix`.\n\nParameters\n----------\n\ntranslate_units : str\n    Do potentially unsafe translations of non-standard unit strings.\n\n    Although ``\"S\"`` is commonly used to represent seconds, its\n    translation to ``\"s\"`` is potentially unsafe since the standard\n    recognizes ``\"S\"`` formally as Siemens, however rarely that may be\n    used.  The same applies to ``\"H\"`` for hours (Henry), and ``\"D\"``\n    for days (Debye).\n\n    This string controls what to do in such cases, and is\n    case-insensitive.\n\n    - If the string contains ``\"s\"``, translate ``\"S\"`` to ``\"s\"``.\n\n    - If the string contains ``\"h\"``, translate ``\"H\"`` to ``\"h\"``.\n\n    - If the string contains ``\"d\"``, translate ``\"D\"`` to ``\"d\"``.\n\n    Thus ``\'\'`` doesn\'t do any unsafe translations, whereas ``\'shd\'``\n    does all of them.\n\nnaxis : int array[naxis]\n    Image axis lengths.  If this array is set to zero or ``None``,\n    then `~astropy.wcs.Wcsprm.cylfix` will not be invoked.\n\nReturns\n-------\nstatus : dict\n\n    Returns a dictionary containing the following keys, each referring\n    to a status string for each of the sub-fix functions that were\n    called:\n\n    - `~astropy.wcs.Wcsprm.cdfix`\n\n    - `~astropy.wcs.Wcsprm.datfix`\n\n    - `~astropy.wcs.Wcsprm.unitfix`\n\n    - `~astropy.wcs.Wcsprm.celfix`\n\n    - `~astropy.wcs.Wcsprm.spcfix`\n\n    - `~astropy.wcs.Wcsprm.cylfix`\n\x00";

char doc_get_cdelt[452] = "get_cdelt() -> double array[naxis]\n\nCoordinate increments (``CDELTia``) for each coord axis.\n\nReturns the ``CDELT`` offsets in read-only form.  Unlike the\n`~astropy.wcs.Wcsprm.cdelt` property, this works even when the header\nspecifies the linear transformation matrix in one of the deprecated\n``CDi_ja`` or ``CROTAia`` forms.  This is useful when you want access\nto the linear transformation matrix, but don\'t care how it was\nspecified in the header.\n\x00";

char doc_get_offset[206] = "get_offset(x, y) -> (x, y)\n\nReturns the offset as defined in the distortion lookup table.\n\nReturns\n-------\ncoordinate : coordinate pair\n    The offset from the distortion table for pixel point (*x*, *y*).\n\x00";

char doc_get_pc[391] = "get_pc() -> double array[naxis][naxis]\n\nReturns the ``PC`` matrix in read-only form.  Unlike the\n`~astropy.wcs.Wcsprm.pc` property, this works even when the header\nspecifies the linear transformation matrix in one of the deprecated\n``CDi_ja`` or ``CROTAia`` forms.  This is useful when you want access\nto the linear transformation matrix, but don\'t care how it was\nspecified in the header.\n\x00";

char doc_get_ps[433] = "get_ps() -> list of tuples\n\nReturns ``PSi_ma`` keywords for each *i* and *m*.\n\nReturns\n-------\nps : list of tuples\n\n    Returned as a list of tuples of the form (*i*, *m*, *value*):\n\n    - *i*: int.  Axis number, as in ``PSi_ma``, (i.e. 1-relative)\n\n    - *m*: int.  Parameter number, as in ``PSi_ma``, (i.e. 0-relative)\n\n    - *value*: string.  Parameter value.\n\nSee also\n--------\nastropy.wcs.Wcsprm.set_ps : Set ``PSi_ma`` values\n\x00";

char doc_get_pv[716] = "get_pv() -> list of tuples\n\nReturns ``PVi_ma`` keywords for each *i* and *m*.\n\nReturns\n-------\n\n    Returned as a list of tuples of the form (*i*, *m*, *value*):\n\n    - *i*: int.  Axis number, as in ``PVi_ma``, (i.e. 1-relative)\n\n    - *m*: int.  Parameter number, as in ``PVi_ma``, (i.e. 0-relative)\n\n    - *value*: string. Parameter value.\n\nSee also\n--------\nastropy.wcs.Wcsprm.set_pv : Set ``PVi_ma`` values\n\nNotes\n-----\n\nNote that, if they were not given, `~astropy.wcs.Wcsprm.set` resets\nthe entries for ``PVi_1a``, ``PVi_2a``, ``PVi_3a``, and ``PVi_4a`` for\nlongitude axis *i* to match (``phi_0``, ``theta_0``), the native\nlongitude and latitude of the reference point given by ``LONPOLEa``\nand ``LATPOLEa``.\n\x00";

char doc_has_cd[911] = "has_cd() -> bool\n\nReturns `True` if ``CDi_ja`` is present.\n\n``CDi_ja`` is an alternate specification of the linear transformation\nmatrix, maintained for historical compatibility.\n\nMatrix elements in the IRAF convention are equivalent to the product\n``CDi_ja = CDELTia * PCi_ja``, but the defaults differ from that of\nthe ``PCi_ja`` matrix.  If one or more ``CDi_ja`` keywords are present\nthen all unspecified ``CDi_ja`` default to zero.  If no ``CDi_ja`` (or\n``CROTAia``) keywords are present, then the header is assumed to be in\n``PCi_ja`` form whether or not any ``PCi_ja`` keywords are present\nsince this results in an interpretation of ``CDELTia`` consistent with\nthe original FITS specification.\n\nWhile ``CDi_ja`` may not formally co-exist with ``PCi_ja``, it may\nco-exist with ``CDELTia`` and ``CROTAia`` which are to be ignored.\n\nSee also\n--------\nastropy.wcs.Wcsprm.cd : Get the raw ``CDi_ja`` values.\n\x00";

char doc_has_cdi_ja[103] = "has_cdi_ja() -> bool\n\nAlias for `~astropy.wcs.Wcsprm.has_cd`.  Maintained for backward\ncompatibility.\n\x00";

char doc_has_crota[652] = "has_crota() -> bool\n\nReturns `True` if ``CROTAia`` is present.\n\n``CROTAia`` is an alternate specification of the linear transformation\nmatrix, maintained for historical compatibility.\n\nIn the AIPS convention, ``CROTAia`` may only be associated with the\nlatitude axis of a celestial axis pair.  It specifies a rotation in\nthe image plane that is applied *after* the ``CDELTia``; any other\n``CROTAia`` keywords are ignored.\n\n``CROTAia`` may not formally co-exist with ``PCi_ja``.  ``CROTAia`` and\n``CDELTia`` may formally co-exist with ``CDi_ja`` but if so are to be\nignored.\n\nSee also\n--------\nastropy.wcs.Wcsprm.crota : Get the raw ``CROTAia`` values\n\x00";

char doc_has_crotaia[107] = "has_crotaia() -> bool\n\nAlias for `~astropy.wcs.Wcsprm.has_crota`.  Maintained for backward\ncompatibility.\n\x00";

char doc_has_pc[213] = "has_pc() -> bool\n\nReturns `True` if ``PCi_ja`` is present.  ``PCi_ja`` is the\nrecommended way to specify the linear transformation matrix.\n\nSee also\n--------\nastropy.wcs.Wcsprm.pc : Get the raw ``PCi_ja`` values\n\x00";

char doc_has_pci_ja[103] = "has_pci_ja() -> bool\n\nAlias for `~astropy.wcs.Wcsprm.has_pc`.  Maintained for backward\ncompatibility.\n\x00";

char doc_have[175] = "``string`` The name of the unit being converted from.\n\nThis value always uses standard unit names, even if the\n`UnitConverter` was initialized with a non-standard unit name.\n\x00";

char doc_i[41] = "``int`` (read-only)\n\nImage axis number.\n\x00";

char doc_imgpix_matrix[173] = "``double array[2][2]`` (read-only) Inverse of the ``CDELT`` or ``PC``\nmatrix.\n\nInverse containing the product of the ``CDELTia`` diagonal matrix and\nthe ``PCi_ja`` matrix.\n\x00";

char doc_is_unity[109] = "is_unity() -> bool\n\nReturns `True` if the linear transformation matrix\n(`~astropy.wcs.Wcsprm.cd`) is unity.\n\x00";

char doc_kind[130] = "``str`` (read-only)\n\nCharacter identifying the wcstab array type:\n\n    - ``\'c\'``: coordinate array,\n    - ``\'i\'``: index vector.\n\x00";

char doc_lat[86] = "``int`` (read-only) The index into the world coord array containing\nlatitude values.\n\x00";

char doc_latpole[75] = "``double`` The native latitude of the celestial pole, ``LATPOLEa`` (deg).\n\x00";

char doc_lattyp[236] = "``string`` (read-only) Celestial axis type for latitude.\n\nFor example, \"RA\", \"DEC\", \"GLON\", \"GLAT\", etc. extracted from \"RA--\",\n\"DEC-\", \"GLON\", \"GLAT\", etc. in the first four characters of\n``CTYPEia`` but with trailing dashes removed.\n\x00";

char doc_lng[87] = "``int`` (read-only) The index into the world coord array containing\nlongitude values.\n\x00";

char doc_lngtyp[237] = "``string`` (read-only) Celestial axis type for longitude.\n\nFor example, \"RA\", \"DEC\", \"GLON\", \"GLAT\", etc. extracted from \"RA--\",\n\"DEC-\", \"GLON\", \"GLAT\", etc. in the first four characters of\n``CTYPEia`` but with trailing dashes removed.\n\x00";

char doc_lonpole[77] = "``double`` The native longitude of the celestial pole.\n\n``LONPOLEa`` (deg).\n\x00";

char doc_m[59] = "``int`` (read-only)\n\nArray axis number for index vectors.\n\x00";

char doc_map[980] = "``int array[M]`` Association between axes.\n\nA vector of length `~astropy.wcs._astropy.wcs.Tabprm.M` that defines\nthe association between axis *m* in the *M*-dimensional coordinate\narray (1 <= *m* <= *M*) and the indices of the intermediate world\ncoordinate and world coordinate arrays.\n\nWhen the intermediate and world coordinate arrays contain the full\ncomplement of coordinate elements in image-order, as will usually be\nthe case, then ``map[m-1] == i-1`` for axis *i* in the *N*-dimensional\nimage (1 <= *i* <= *N*).  In terms of the FITS keywords::\n\n    map[PVi_3a - 1] == i - 1.\n\nHowever, a different association may result if the intermediate\ncoordinates, for example, only contains a (relevant) subset of\nintermediate world coordinate elements.  For example, if *M* == 1 for\nan image with *N* > 1, it is possible to fill the intermediate\ncoordinates with the relevant coordinate element with ``nelem`` set to\n1.  In this case ``map[0] = 0`` regardless of the value of *i*.\n\x00";

char doc_mix[4806] = "mix(mixpix, mixcel, vspan, vstep, viter, world, pixcrd, origin)\n\nGiven either the celestial longitude or latitude plus an element of\nthe pixel coordinate, solves for the remaining elements by iterating\non the unknown celestial coordinate element using\n`~astropy.wcs.Wcsprm.s2p`.\n\nParameters\n----------\nmixpix : int\n    Which element on the pixel coordinate is given.\n\nmixcel : int\n    Which element of the celestial coordinate is given. If *mixcel* =\n    ``1``, celestial longitude is given in ``world[self.lng]``,\n    latitude returned in ``world[self.lat]``.  If *mixcel* = ``2``,\n    celestial latitude is given in ``world[self.lat]``, longitude\n    returned in ``world[self.lng]``.\n\nvspan : pair of floats\n    Solution interval for the celestial coordinate, in degrees.  The\n    ordering of the two limits is irrelevant.  Longitude ranges may be\n    specified with any convenient normalization, for example\n    ``(-120,+120)`` is the same as ``(240,480)``, except that the\n    solution will be returned with the same normalization, i.e. lie\n    within the interval specified.\n\nvstep : float\n    Step size for solution search, in degrees.  If ``0``, a sensible,\n    although perhaps non-optimal default will be used.\n\nviter : int\n    If a solution is not found then the step size will be halved and\n    the search recommenced.  *viter* controls how many times the step\n    size is halved.  The allowed range is 5 - 10.\n\nworld : double array[naxis]\n    World coordinate elements.  ``world[self.lng]`` and\n    ``world[self.lat]`` are the celestial longitude and latitude, in\n    degrees.  Which is given and which returned depends on the value\n    of *mixcel*.  All other elements are given.  The results will be\n    written to this array in-place.\n\npixcrd : double array[naxis].\n    Pixel coordinates.  The element indicated by *mixpix* is given and\n    the remaining elements will be written in-place.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nresult : dict\n\n    Returns a dictionary with the following keys:\n\n    - *phi* (double array[naxis])\n\n    - *theta* (double array[naxis])\n\n        - Longitude and latitude in the native coordinate system of\n          the projection, in degrees.\n\n    - *imgcrd* (double array[naxis])\n\n        - Image coordinate elements.  ``imgcrd[self.lng]`` and\n          ``imgcrd[self.lat]`` are the projected *x*- and\n          *y*-coordinates, in decimal degrees.\n\n    - *world* (double array[naxis])\n\n        - Another reference to the *world* argument passed in.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nInvalidTransformError\n    Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\nInvalidCoordinateError\n    Invalid world coordinate.\n\nNoSolutionError\n    No solution found in the specified interval.\n\nSee also\n--------\nastropy.wcs.Wcsprm.lat, astropy.wcs.Wcsprm.lng\n    Get the axes numbers for latitude and longitude\n\nNotes\n-----\n\nInitially, the specified solution interval is checked to see if it\'s a\n\"crossing\" interval.  If it isn\'t, a search is made for a crossing\nsolution by iterating on the unknown celestial coordinate starting at\nthe upper limit of the solution interval and decrementing by the\nspecified step size.  A crossing is indicated if the trial value of\nthe pixel coordinate steps through the value specified.  If a crossing\ninterval is found then the solution is determined by a modified form\nof \"regula falsi\" division of the crossing interval.  If no crossing\ninterval was found within the specified solution interval then a\nsearch is made for a \"non-crossing\" solution as may arise from a\npoint of tangency.  The process is complicated by having to make\nallowance for the discontinuities that occur in all map projections.\n\nOnce one solution has been determined others may be found by\nsubsequent invocations of `~astropy.wcs.Wcsprm.mix` with suitably\nrestricted solution intervals.\n\nNote the circumstance that arises when the solution point lies at a\nnative pole of a projection in which the pole is represented as a\nfinite curve, for example the zenithals and conics.  In such cases two\nor more valid solutions may exist but `~astropy.wcs.Wcsprm.mix` only\never returns one.\n\nBecause of its generality, `~astropy.wcs.Wcsprm.mix` is very\ncompute-intensive.  For compute-limited applications, more efficient\nspecial-case solvers could be written for simple projections, for\nexample non-oblique cylindrical projections.\n\x00";

char doc_mjdavg[181] = "``double`` Modified Julian Date corresponding to ``DATE-AVG``.\n\n``(MJD = JD - 2400000.5)``.\n\nAn undefined value is represented by NaN.\n\nSee also\n--------\nastropy.wcs.Wcsprm.mjdobs\n\x00";

char doc_mjdobs[181] = "``double`` Modified Julian Date corresponding to ``DATE-OBS``.\n\n``(MJD = JD - 2400000.5)``.\n\nAn undefined value is represented by NaN.\n\nSee also\n--------\nastropy.wcs.Wcsprm.mjdavg\n\x00";

char doc_name[74] = "``string`` The name given to the coordinate representation\n``WCSNAMEa``.\n\x00";

char doc_naxis[761] = "``int`` (read-only) The number of axes (pixel and coordinate).\n\nGiven by the ``NAXIS`` or ``WCSAXESa`` keyvalues.\n\nThe number of coordinate axes is determined at parsing time, and can\nnot be subsequently changed.\n\nIt is determined from the highest of the following:\n\n  1. ``NAXIS``\n\n  2. ``WCSAXESa``\n\n  3. The highest axis number in any parameterized WCS keyword.  The\n     keyvalue, as well as the keyword, must be syntactically valid\n     otherwise it will not be considered.\n\nIf none of these keyword types is present, i.e. if the header only\ncontains auxiliary WCS keywords for a particular coordinate\nrepresentation, then no coordinate description is constructed for it.\n\nThis value may differ for different coordinate representations of the\nsame image.\n\x00";

char doc_nc[172] = "``int`` (read-only) Total number of coord vectors in the coord array.\n\nTotal number of coordinate vectors in the coordinate array being the\nproduct K_1 * K_2 * ... * K_M.\n\x00";

char doc_ndim[67] = "``int`` (read-only)\n\nExpected dimensionality of the wcstab array.\n\x00";

char doc_obsgeo[187] = "``double array[3]`` Location of the observer in a standard terrestrial\nreference frame.\n\n``OBSGEO-X``, ``OBSGEO-Y``, ``OBSGEO-Z`` (in meters).\n\nAn undefined value is represented by NaN.\n\x00";

char doc_offset[47] = "``double`` The offset of the unit conversion.\n\x00";

char doc_p0[257] = "``int array[M]`` Interpolated indices into the coordinate array.\n\nVector of length `~astropy.wcs._astropy.wcs.Tabprm.M` of interpolated\nindices into the coordinate array such that Upsilon_m, as defined in\nPaper III, is equal to ``(p0[m] + 1) + delta[m]``.\n\x00";

char doc_p2s[2005] = "p2s(pixcrd, origin)\n\nConverts pixel to world coordinates.\n\nParameters\n----------\n\npixcrd : double array[ncoord][nelem]\n    Array of pixel coordinates.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nresult : dict\n    Returns a dictionary with the following keys:\n\n    - *imgcrd*: double array[ncoord][nelem]\n\n      - Array of intermediate world coordinates.  For celestial axes,\n        ``imgcrd[][self.lng]`` and ``imgcrd[][self.lat]`` are the\n        projected *x*-, and *y*-coordinates, in pseudo degrees.  For\n        spectral axes, ``imgcrd[][self.spec]`` is the intermediate\n        spectral coordinate, in SI units.\n\n    - *phi*: double array[ncoord]\n\n    - *theta*: double array[ncoord]\n\n      - Longitude and latitude in the native coordinate system of the\n        projection, in degrees.\n\n    - *world*: double array[ncoord][nelem]\n\n      - Array of world coordinates.  For celestial axes,\n        ``world[][self.lng]`` and ``world[][self.lat]`` are the\n        celestial longitude and latitude, in degrees.  For spectral\n        axes, ``world[][self.spec]`` is the intermediate spectral\n        coordinate, in SI units.\n\n    - *stat*: int array[ncoord]\n\n      - Status return value for each coordinate. ``0`` for success,\n        ``1+`` for invalid pixel coordinate.\n\nRaises\n------\n\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nValueError\n    *x*- and *y*-coordinate arrays are not the same size.\n\nInvalidTransformError\n    Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\nSee also\n--------\nastropy.wcs.Wcsprm.lat, astropy.wcs.Wcsprm.lng\n    Definition of the latitude andlongitude axes\n\x00";

char doc_p4_pix2foc[652] = "p4_pix2foc(*pixcrd, origin*) -> double array[ncoord][nelem]\n\nConvert pixel coordinates to focal plane coordinates using `Paper IV`_\nlookup-table distortion correction.\n\nParameters\n----------\npixcrd : double array[ncoord][nelem].\n    Array of pixel coordinates.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nfoccrd : double array[ncoord][nelem]\n    Returns an array of focal plane coordinates.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nValueError\n    Invalid coordinate transformation parameters.\n\x00";

char doc_pc[1141] = "``double array[naxis][naxis]`` The ``PCi_ja`` (pixel coordinate)\ntransformation matrix.\n\nThe order is::\n\n  [[PC1_1, PC1_2],\n   [PC2_1, PC2_2]]\n\nFor historical compatibility, three alternate specifications of the\nlinear transforations are available in wcslib.  The canonical\n``PCi_ja`` with ``CDELTia``, and the deprecated ``CDi_ja`` and\n``CROTAia`` keywords.  Although the deprecated versions may not\nformally co-exist with ``PCi_ja``, the approach here is simply to\nignore them if given in conjunction with ``PCi_ja``.\n\n`~astropy.wcs.Wcsprm.has_pc`, `~astropy.wcs.Wcsprm.has_cd` and\n`~astropy.wcs.Wcsprm.has_crota` can be used to determine which of\nthese alternatives are present in the header.\n\nThese alternate specifications of the linear transformation matrix are\ntranslated immediately to ``PCi_ja`` by `~astropy.wcs.Wcsprm.set` and\nare nowhere visible to the lower-level routines.  In particular,\n`~astropy.wcs.Wcsprm.set` resets `~astropy.wcs.Wcsprm.cdelt` to unity\nif ``CDi_ja`` is present (and no ``PCi_ja``).  If no ``CROTAia`` is\nassociated with the latitude axis, `~astropy.wcs.Wcsprm.set` reverts\nto a unity ``PCi_ja`` matrix.\n\x00";

char doc_phi0[289] = "``double`` The native latitude of the fiducial point.\n\nThe point whose celestial coordinates are given in ``ref[1:2]``.  If\nundefined (NaN) the initialization routine, `~astropy.wcs.Wcsprm.set`,\nwill set this to a projection-specific default.\n\nSee also\n--------\nastropy.wcs.Wcsprm.theta0\n\x00";

char doc_pix2foc[636] = "pix2foc(*pixcrd, origin*) -> double array[ncoord][nelem]\n\nPerform both `SIP`_ polynomial and `Paper IV`_ lookup-table distortion\ncorrection in parallel.\n\nParameters\n----------\npixcrd : double array[ncoord][nelem]\n    Array of pixel coordinates.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nfoccrd : double array[ncoord][nelem]\n    Returns an array of focal plane coordinates.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nValueError\n    Invalid coordinate transformation parameters.\n\x00";

char doc_piximg_matrix[128] = "``double array[2][2]`` (read-only) Matrix containing the product of\nthe ``CDELTia`` diagonal matrix and the ``PCi_ja`` matrix.\n\x00";

char doc_power[49] = "``double`` The exponent of the unit conversion.\n\x00";

char doc_print_contents[210] = "print_contents()\n\nPrint the contents of the `~astropy.wcs.Wcsprm` object to stdout.\nProbably only useful for debugging purposes, and may be removed in the\nfuture.\n\nTo get a string of the contents, use `repr`.\n\x00";

char doc_print_contents_tabprm[224] = "print_contents()\n\nPrint the contents of the `~astropy.wcs._astropy.wcs.Tabprm` object to\nstdout.  Probably only useful for debugging purposes, and may be\nremoved in the future.\n\nTo get a string of the contents, use `repr`.\n\x00";

char doc_radesys[77] = "``string`` The equatorial or ecliptic coordinate system type,\n``RADESYSa``.\n\x00";

char doc_restfrq[94] = "``double`` Rest frequency (Hz) from ``RESTFRQa``.\n\nAn undefined value is represented by NaN.\n\x00";

char doc_restwav[94] = "``double`` Rest wavelength (m) from ``RESTWAVa``.\n\nAn undefined value is represented by NaN.\n\x00";

char doc_row[40] = "``int`` (read-only)\n\nTable row number.\n\x00";

char doc_s2p[1910] = "s2p(world, origin)\n\nTransforms world coordinates to pixel coordinates.\n\nParameters\n----------\nworld : double array[ncoord][nelem]\n    Array of world coordinates, in decimal degrees.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nresult : dict\n    Returns a dictionary with the following keys:\n\n    - *phi*: double array[ncoord]\n\n    - *theta*: double array[ncoord]\n\n        - Longitude and latitude in the native coordinate system of\n          the projection, in degrees.\n\n    - *imgcrd*: double array[ncoord][nelem]\n\n       - Array of intermediate world coordinates.  For celestial axes,\n         ``imgcrd[][self.lng]`` and ``imgcrd[][self.lat]`` are the\n         projected *x*-, and *y*-coordinates, in pseudo \"degrees\".\n         For quadcube projections with a ``CUBEFACE`` axis, the face\n         number is also returned in ``imgcrd[][self.cubeface]``.  For\n         spectral axes, ``imgcrd[][self.spec]`` is the intermediate\n         spectral coordinate, in SI units.\n\n    - *pixcrd*: double array[ncoord][nelem]\n\n        - Array of pixel coordinates.  Pixel coordinates are\n          zero-based.\n\n    - *stat*: int array[ncoord]\n\n        - Status return value for each coordinate. ``0`` for success,\n          ``1+`` for invalid pixel coordinate.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nInvalidTransformError\n   Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\nSee also\n--------\nastropy.wcs.Wcsprm.lat, astropy.wcs.Wcsprm.lng\n    Definition of the latitude and longitude axes\n\x00";

char doc_scale[56] = "``double`` The scaling factor for the unit conversion.\n\x00";

char doc_sense[245] = "``int array[M]`` +1 if monotonically increasing, -1 if decreasing.\n\nA vector of length `~astropy.wcs._astropy.wcs.Tabprm.M` whose elements\nindicate whether the corresponding indexing vector is monotonically\nincreasing (+1), or decreasing (-1).\n\x00";

char doc_set[1206] = "set()\n\nSets up a WCS object for use according to information supplied within\nit.\n\nNote that this routine need not be called directly; it will be invoked\nby `~astropy.wcs.Wcsprm.p2s` and `~astropy.wcs.Wcsprm.s2p` if\nnecessary.\n\nSome attributes that are based on other attributes (such as\n`~astropy.wcs.Wcsprm.lattyp` on `~astropy.wcs.Wcsprm.ctype`) may not\nbe correct until after `~astropy.wcs.Wcsprm.set` is called.\n\n`~astropy.wcs.Wcsprm.set` strips off trailing blanks in all string\nmembers.\n\n`~astropy.wcs.Wcsprm.set` recognizes the ``NCP`` projection and\nconverts it to the equivalent ``SIN`` projection and it also\nrecognizes ``GLS`` as a synonym for ``SFL``.  It does alias\ntranslation for the AIPS spectral types (``FREQ-LSR``, ``FELO-HEL``,\netc.) but without changing the input header keywords.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nInvalidTransformError\n    Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\x00";

char doc_set_ps[414] = "set_ps(list)\n\nSets `PSi_ma` keywords for each *i* and *m*.\n\nParameters\n----------\nps : sequence of tuples\n\n    The input must be a sequence of tuples of the form (*i*, *m*,\n    *value*):\n\n    - *i*: int.  Axis number, as in ``PSi_ma``, (i.e. 1-relative)\n\n    - *m*: int.  Parameter number, as in ``PSi_ma``, (i.e. 0-relative)\n\n    - *value*: string.  Parameter value.\n\nSee also\n--------\nastropy.wcs.Wcsprm.get_ps\n\x00";

char doc_set_pv[409] = "set_pv(list)\n\nSets `PVi_ma` keywords for each *i* and *m*.\n\nParameters\n----------\npv : list of tuples\n\n    The input must be a sequence of tuples of the form (*i*, *m*,\n    *value*):\n\n    - *i*: int.  Axis number, as in ``PVi_ma``, (i.e. 1-relative)\n\n    - *m*: int.  Parameter number, as in ``PVi_ma``, (i.e. 0-relative)\n\n    - *value*: float.  Parameter value.\n\nSee also\n--------\nastropy.wcs.Wcsprm.get_pv\n\x00";

char doc_set_tabprm[325] = "set()\n\nAllocates memory for work arrays.\n\nAlso sets up the class according to information supplied within it.\n\nNote that this routine need not be called directly; it will be invoked\nby functions that need it.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nInvalidTabularParameters\n    Invalid tabular parameters.\n\x00";

char doc_sip[84] = "Get/set the `~astropy.wcs.Sip` object for performing `SIP`_ distortion\ncorrection.\n\x00";

char doc_sip_foc2pix[649] = "sip_foc2pix(*foccrd, origin*) -> double array[ncoord][nelem]\n\nConvert focal plane coordinates to pixel coordinates using the `SIP`_\npolynomial distortion convention.\n\nParameters\n----------\nfoccrd : double array[ncoord][nelem]\n    Array of focal plane coordinates.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\npixcrd : double array[ncoord][nelem]\n    Returns an array of pixel coordinates.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nValueError\n    Invalid coordinate transformation parameters.\n\x00";

char doc_sip_pix2foc[649] = "sip_pix2foc(*pixcrd, origin*) -> double array[ncoord][nelem]\n\nConvert pixel coordinates to focal plane coordinates using the `SIP`_\npolynomial distortion convention.\n\nParameters\n----------\npixcrd : double array[ncoord][nelem]\n    Array of pixel coordinates.\n\n\norigin : int\n    Specifies the origin of pixel values.  The Fortran and FITS\n    standards use an origin of 1.  Numpy and C use array indexing with\n    origin at 0.\n\n\nReturns\n-------\nfoccrd : double array[ncoord][nelem]\n    Returns an array of focal plane coordinates.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nValueError\n    Invalid coordinate transformation parameters.\n\x00";

char doc_spcfix[272] = "spcfix() -> int\n\nTranslates AIPS-convention spectral coordinate types.  {``FREQ``,\n``VELO``, ``FELO``}-{``OBS``, ``HEL``, ``LSR``} (e.g. ``FREQ-LSR``,\n``VELO-OBS``, ``FELO-HEL``)\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00";

char doc_spec[68] = "``int`` (read-only) The index containing the spectral axis values.\n\x00";

char doc_specsys[145] = "``string`` Spectral reference frame (standard of rest), ``SPECSYSa``.\n\nSee also\n--------\nastropy.wcs.Wcsprm.ssysobs, astropy.wcs.Wcsprm.velosys\n\x00";

char doc_sptr[1373] = "sptr(ctype, i=-1)\n\nTranslates the spectral axis in a WCS object.\n\nFor example, a ``FREQ`` axis may be translated into ``ZOPT-F2W`` and\nvice versa.\n\nParameters\n----------\nctype : string\n    Required spectral ``CTYPEia``, maximum of 8 characters.  The first\n    four characters are required to be given and are never modified.\n    The remaining four, the algorithm code, are completely determined\n    by, and must be consistent with, the first four characters.\n    Wildcarding may be used, i.e.  if the final three characters are\n    specified as ``\"???\"``, or if just the eighth character is\n    specified as ``\"?\"``, the correct algorithm code will be\n    substituted and returned.\n\ni : int\n    Index of the spectral axis (0-relative).  If ``i < 0`` (or not\n    provided), it will be set to the first spectral axis identified\n    from the ``CTYPE`` keyvalues in the FITS header.\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nSingularMatrixError\n    Linear transformation matrix is singular.\n\nInconsistentAxisTypesError\n    Inconsistent or unrecognized coordinate axis types.\n\nValueError\n    Invalid parameter value.\n\nInvalidTransformError\n    Invalid coordinate transformation parameters.\n\nInvalidTransformError\n    Ill-conditioned coordinate transformation parameters.\n\nInvalidSubimageSpecificationError\n    Invalid subimage specification (no spectral axis).\n\x00";

char doc_ssysobs[253] = "``string`` Spectral reference frame.\n\nThe spectral reference frame in which there is no differential\nvariation in the spectral coordinate across the field-of-view,\n``SSYSOBSa``.\n\nSee also\n--------\nastropy.wcs.Wcsprm.specsys, astropy.wcs.Wcsprm.velosys\n\x00";

char doc_ssyssrc[150] = "``string`` Spectral reference frame for redshift.\n\nThe spectral reference frame (standard of rest) in which the redshift\nwas measured, ``SSYSSRCa``.\n\x00";

char doc_sub[3436] = "sub(axes)\n\nExtracts the coordinate description for a subimage from a\n`~astropy.wcs.WCS` object.\n\nThe world coordinate system of the subimage must be separable in the\nsense that the world coordinates at any point in the subimage must\ndepend only on the pixel coordinates of the axes extracted.  In\npractice, this means that the ``PCi_ja`` matrix of the original image\nmust not contain non-zero off-diagonal terms that associate any of the\nsubimage axes with any of the non-subimage axes.\n\n`sub` can also add axes to a wcsprm object.  The new axes will be\ncreated using the defaults set by the Wcsprm constructor which produce\na simple, unnamed, linear axis with world coordinates equal to the\npixel coordinate.  These default values can be changed before\ninvoking `set`.\n\nParameters\n----------\naxes : int or a sequence.\n\n    - If an int, include the first *N* axes in their original order.\n\n    - If a sequence, may contain a combination of image axis numbers\n      (1-relative) or special axis identifiers (see below).  Order is\n      significant; ``axes[0]`` is the axis number of the input image\n      that corresponds to the first axis in the subimage, etc.  Use an\n      axis number of 0 to create a new axis using the defaults.\n\n    - If ``0``, ``[]`` or ``None``, do a deep copy.\n\n    Coordinate axes types may be specified using either strings or\n    special integer constants.  The available types are:\n\n    - ``\'longitude\'`` / ``WCSSUB_LONGITUDE``: Celestial longitude\n\n    - ``\'latitude\'`` / ``WCSSUB_LATITUDE``: Celestial latitude\n\n    - ``\'cubeface\'`` / ``WCSSUB_CUBEFACE``: Quadcube ``CUBEFACE`` axis\n\n    - ``\'spectral\'`` / ``WCSSUB_SPECTRAL``: Spectral axis\n\n    - ``\'stokes\'`` / ``WCSSUB_STOKES``: Stokes axis\n\n    - ``\'celestial\'`` / ``WCSSUB_CELESTIAL``: An alias for the\n      combination of ``\'longitude\'``, ``\'latitude\'`` and ``\'cubeface\'``.\n\nReturns\n-------\nnew_wcs : `~astropy.wcs.WCS` object\n\nRaises\n------\nMemoryError\n    Memory allocation failed.\n\nInvalidSubimageSpecificationError\n    Invalid subimage specification (no spectral axis).\n\nNonseparableSubimageCoordinateSystem\n    Non-separable subimage coordinate system.\n\nNotes\n-----\nCombinations of subimage axes of particular types may be extracted in\nthe same order as they occur in the input image by combining the\ninteger constants with the \'binary or\' (``|``) operator.  For\nexample::\n\n    wcs.sub([WCSSUB_LONGITUDE | WCSSUB_LATITUDE | WCSSUB_SPECTRAL])\n\nwould extract the longitude, latitude, and spectral axes in the same\norder as the input image.  If one of each were present, the resulting\nobject would have three dimensions.\n\nFor convenience, ``WCSSUB_CELESTIAL`` is defined as the combination\n``WCSSUB_LONGITUDE | WCSSUB_LATITUDE | WCSSUB_CUBEFACE``.\n\nThe codes may also be negated to extract all but the types specified,\nfor example::\n\n    wcs.sub([\n      WCSSUB_LONGITUDE,\n      WCSSUB_LATITUDE,\n      WCSSUB_CUBEFACE,\n      -(WCSSUB_SPECTRAL | WCSSUB_STOKES)])\n\nThe last of these specifies all axis types other than spectral or\nStokes.  Extraction is done in the order specified by `axes`, i.e. a\nlongitude axis (if present) would be extracted first (via ``axes[0]``)\nand not subsequently (via ``axes[3]``).  Likewise for the latitude and\ncubeface axes in this example.\n\nThe number of dimensions in the returned object may be less than or\ngreater than the length of `axes`.  However, it will never exceed the\nnumber of axes in the input image.\n\x00";

char doc_tab[112] = "``list of Tabprm`` Tabular coordinate objects.\n\nA list of tabular coordinate objects associated with this WCS.\n\x00";

char doc_theta0[289] = "``double``  The native longitude of the fiducial point.\n\nThe point whose celestial coordinates are given in ``ref[1:2]``.  If\nundefined (NaN) the initialization routine, `~astropy.wcs.Wcsprm.set`,\nwill set this to a projection-specific default.\n\nSee also\n--------\nastropy.wcs.Wcsprm.phi0\n\x00";

char doc_to_header[2229] = "to_header(relax=False)\n\n`to_header` translates a WCS object into a FITS header.\n\nThe details of the header depends on context:\n\n    - If the `~astropy.wcs.Wcsprm.colnum` member is non-zero then a\n      binary table image array header will be produced.\n\n    - Otherwise, if the `~astropy.wcs.Wcsprm.colax` member is set\n      non-zero then a pixel list header will be produced.\n\n    - Otherwise, a primary image or image extension header will be\n      produced.\n\nThe output header will almost certainly differ from the input in a\nnumber of respects:\n\n    1. The output header only contains WCS-related keywords.  In\n       particular, it does not contain syntactically-required keywords\n       such as ``SIMPLE``, ``NAXIS``, ``BITPIX``, or ``END``.\n\n    2. Deprecated (e.g. ``CROTAn``) or non-standard usage will be\n       translated to standard (this is partially dependent on whether\n       `fix` was applied).\n\n    3. Quantities will be converted to the units used internally,\n       basically SI with the addition of degrees.\n\n    4. Floating-point quantities may be given to a different decimal\n       precision.\n\n    5. Elements of the ``PCi_j`` matrix will be written if and only if\n       they differ from the unit matrix.  Thus, if the matrix is unity\n       then no elements will be written.\n\n    6. Additional keywords such as ``WCSAXES``, ``CUNITia``,\n       ``LONPOLEa`` and ``LATPOLEa`` may appear.\n\n    7. The original keycomments will be lost, although\n       `~astropy.wcs.Wcsprm.to_header` tries hard to write meaningful\n       comments.\n\n    8. Keyword order may be changed.\n\nKeywords can be translated between the image array, binary table, and\npixel lists forms by manipulating the `~astropy.wcs.Wcsprm.colnum` or\n`~astropy.wcs.Wcsprm.colax` members of the `~astropy.wcs.Wcsprm.WCS`\nobject.\n\nParameters\n----------\n\nrelax : bool or int\n    Degree of permissiveness:\n\n    - `False`: Recognize only FITS keywords defined by the published\n      WCS standard.\n\n    - `True`: Admit all recognized informal extensions of the WCS\n      standard.\n\n    - `int`: a bit field selecting specific extensions to write.\n      See :ref:`relaxwrite` for details.\n\nReturns\n-------\nheader : str\n    Raw FITS header as a string.\n\x00";

char doc_ttype[108] = "``str`` (read-only)\n\n``TTYPEn`` identifying the column of the binary table that contains\nthe wcstab array.\n\x00";

char doc_unitfix[1098] = "unitfix(translate_units=\'\')\n\nTranslates non-standard ``CUNITia`` keyvalues.\n\nFor example, ``DEG`` -> ``deg``, also stripping off unnecessary\nwhitespace.\n\nParameters\n----------\ntranslate_units : string, optional\n    Do potentially unsafe translations of non-standard unit strings.\n\n    Although ``\"S\"`` is commonly used to represent seconds, its\n    recognizes ``\"S\"`` formally as Siemens, however rarely that may\n    be translation to ``\"s\"`` is potentially unsafe since the\n    standard used.  The same applies to ``\"H\"`` for hours (Henry),\n    and ``\"D\"`` for days (Debye).\n\n    This string controls what to do in such cases, and is\n    case-insensitive.\n\n    - If the string contains ``\"s\"``, translate ``\"S\"`` to ``\"s\"``.\n\n    - If the string contains ``\"h\"``, translate ``\"H\"`` to ``\"h\"``.\n\n    - If the string contains ``\"d\"``, translate ``\"D\"`` to ``\"d\"``.\n\n    Thus ``\'\'`` doesn\'t do any unsafe translations, whereas ``\'shd\'``\n    does all of them.\n\n    See :ref:`fits-unit` for more information.\n\nReturns\n-------\nsuccess : int\n    Returns ``0`` for success; ``-1`` if no change required.\n\x00";

char doc_velangl[186] = "``double`` Velocity angle.\n\nThe angle in degrees that should be used to decompose an observed\nvelocity into radial and transverse components.\n\nAn undefined value is represented by NaN.\n\x00";

char doc_velosys[316] = "``double`` Relative radial velocity.\n\nThe relative radial velocity (m/s) between the observer and the\nselected standard of rest in the direction of the celestial reference\ncoordinate, ``VELOSYSa``.\n\nAn undefined value is represented by NaN.\n\nSee also\n--------\nastropy.wcs.Wcsprm.specsys, astropy.wcs.Wcsprm.ssysobs\n\x00";

char doc_want[173] = "``string`` The name of the unit being converted to.\n\nThis value always uses standard unit names, even if the\n`UnitConverter` was initialized with a non-standard unit name.\n\x00";

char doc_wcs[83] = "A `~astropy.wcs.Wcsprm` object to perform the basic `wcslib`_ WCS\ntransformation.\n\x00";

char doc_zsource[98] = "``double`` The redshift, ``ZSOURCEa``, of the source.\n\nAn undefined value is represented by NaN.\n\x00";

#endif
