from setuptools import setup
import codecs
import os
import re

here = os.path.abspath(os.path.dirname(__file__))

# Read the version number from a source file.
# Why read it, and not import?
# see https://groups.google.com/d/topic/pypa-dev/0PkjVpcxTzQ/discussion
def find_version(*file_paths):
    # Open in Latin-1 so that we avoid encoding errors.
    # Use codecs.open for Python 2 compatibility
    with codecs.open(os.path.join(here, *file_paths), 'r', 'latin1') as f:
        version_file = f.read()

    # The version line must have the form
    # __version__ = 'ver'
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]",
                              version_file, re.M)
    if version_match:
        return version_match.group(1).encode('ascii')
    raise RuntimeError("Unable to find version string.")


description = "Simple thread based asynchronous file reader"

long_description="""
AsynchronousFileReader is a simple thread based way to read
one or multiple files in an asynchronous way.
"""

setup(
    name="asynchronousfilereader",
    version=find_version('asynchronousfilereader', '__init__.py'),
    description=description,
    long_description=long_description,
    url='https://github.com/soxofaan/asynchronousfilereader',
    author='Stefaan Lippens',
    author_email='soxofaan@gmail.com',
    license='MIT',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 3',
    ],

    keywords='async asynchronous threading',
    packages=['asynchronousfilereader'],
)
