# atl/__init__.py
#
#

"""
    ALLAH - path - padje - dag - dagje

"""

__version__ = 8

## IMPORTS 

from atl.generic import *
from atl.utils import *

import collections
import threading
import logging
import _thread
import socket
import queue
import types
import errno
import fcntl
import uuid
import json
import time
import imp
import sys
import os
import re

## ERRORS

class Error(BaseException): pass

class OverloadError(Error): pass

class MissingArgument(Error): pass

class MissingOutFunction(Error): pass

class NoText(Error): pass

class NoFileName(Error): pass

class SignatureError(Error): pass

class NoSuchBotType(Error): pass

class NoEvent(Error): pass

class RemoteDisconnect(Error): pass

## BASE

class Object(dict):

    def __getattribute__(self, *args, **kwargs):
        name = args[0]
        if name == "what": return get_cls(self)
        if name == "modname": return self.__class__.__module__
        if name == "cfrom": return called_from(2)
        if name == "stdin": return sys.stdin
        if name == "stdout": return sys.stdout
        return dict.__getattribute__(self, *args, **kwargs)

    def __getattr__(self, name):
        try: return self[name]
        except KeyError:
            if name == "_result": self["_result"] = Object()
            if name == "_ready": self["_ready"] = threading.Event()
            if name == "ctime": self["ctime"] = time.time()
        try: return self[name]
        except KeyError: return ""

    def __setattr__(self, name, value): return dict.__setitem__(self, name, value)

    def __exists__(self, a):
        try: return self[a]
        except KeyError: False

    def __lt__(self, a): return self.ctime < a.ctime

    ## locators

    def get_root(self):
        home = os.path.expanduser("~")
        return j(home, config.workdir)

    def get_target(self, fn="", **kwargs): return j(self.modname, self.what, fn)

    def get_path(self, fn="", **kwargs): return j(self.get_root(), self.get_target(fn))

    def get_stamp(self): return j(day(), hms())

    ## output

    def make_json(self, *args, **kwargs): return json.dumps(self.reduced(), default=smooth, *args, **kwargs)

    def make_full(self, *args, **kwargs): return json.dumps(self, default=smooth, *args, **kwargs)

    def make_signature(self, sig=None): return str(hashlib.sha1(bytes(str(sig or self), "utf-8")).hexdigest())

    def make_path(self, *args, **kwargs):
        if args: path = self.get_path(args[0])
        else: path = self.get_path(self.get_stamp())
        make_dir(path)
        return path

    ## input

    def load(self, *args, **kwargs):
        if args: path = self.make_path(*args, **kwargs)
        else: path = self.make_path()
        return self.load_file(path)

    def load_file(self, *args, **kwargs):
        path = args[0]
        ondisk = self.read(path) 
        fromdisk = json.loads(ondisk)
        if "data" in fromdisk: self.update(fromdisk["data"])
        return self

    def load_lines(Self, *args, **kwargs):
        txt = args[0]
        if not self.lines: self.lines = Object()
        c = 0
        for l in txt.split("\n"): self.lines[c] = l ; c += 1

    def load_json(self, *args, **kwargs):
        try: self.update(json.loads(args[0]))
        except ValueError: pass
        except: error()
        return self

    def read(self, *args, **kwargs):
        logging.info("read %s" % args[0])
        path = args[0]
        try: f = open(path, "r")
        except IOError as ex:
            if ex.errno == errno.ENOENT: return "{}"
            raise
        if self.do_test: f.line_buffering = False
        res = ""
        for line in f:
            if not line.strip().startswith("#"): res += line
        if not res.strip(): return "{}"
        f.close()
        return res

    ## persistence

    def save(self, *args, **kwargs):
        path = self.make_path(*args, **kwargs)
        logging.warn("save %s" % path)
        todisk = Object()
        todisk.data = self.reduced()
        todisk.data.path = path
        todisk.data.day = path.split(os.sep)[-2]
        todisk.create_type = self.what
        todisk.modname = self.modname
        todisk.saved_from = called_from()
        todisk.version = __version__
        todisk.signature = self.make_signature()
        try: result = todisk.make_json(indent=2)
        except TypeError: raise NoJSON(todisk)
        todisk.signature = make_signature(result)
        datafile = open(path + ".tmp", 'w')
        fcntl.flock(datafile, fcntl.LOCK_EX | fcntl.LOCK_NB)
        datafile.write(headertxt % (path, __version__, "%s characters" % len(result)))
        datafile.write(result)
        datafile.write("\n")
        fcntl.flock(datafile, fcntl.LOCK_UN)
        datafile.close()
        os.rename(path + ".tmp", path)
        return self

    def save_stamp(self, *args, **kwargs): self.save(self.get_stamp(*args, **kwargs))

    ## state

    def register(self, *args, **kwargs):
        name = args[0]
        obj = args[1]
        self[name] = obj

    def reduced(self):
        res = Object()
        for key in self.keys():
            k = str(key)
            if k.startswith("_"): continue   
            if key in ["args", "rest", "first"]: continue
            res[key] = self[key]
        return res

    ## locators

    def find(self, search):
        result = []
        for item in self.objects():
            if search in item.txt: result.append(item)
        return result
 
    def objects(self, *args, **kwargs):
        path = self.get_path(*args, **kwargs)
        kw = Object(**kwargs)
        res = []
        if not os.path.isdir(path): return []
        time_from = kw.time_from or  "1984"
        time_to = kw.time_to or "2014"
        for p in os.listdir(path):
            fnn = j(path, p)
            if os.path.isdir(fnn): res.extend(self.objects(fnn)) ; continue
            obj = Object().load_file(fnn)
            res.append(obj)
        res = sorted(res, key=lambda o: o.path)
        return res

    ## result

    def prepare(self, *args, **kwargs):
        try: self.user_cmnd, self.rest = self.txt.split(" ", 1)
        except: self.user_cmnd = self.txt ; self.rest = ""
        if self.user_cmnd and self.user_cmnd[0] == ".": self.user_cmnd = self.user_cmnd[1:]
        if self.rest: self.args = self.rest.split()
        else: self.args = []
        self.options = parse_options(self.txt)

    def ready(self): self._ready.set()

    def wait(self, sec=180.0): self._ready.wait(sec)

    def reply(self, value):
        if self.outer:
            outer = self.outer
            outer.write(value)
            outer.write("\n")
            outer.flush()
        self._result[time.time()] = value 

    def show_items(self): return ["%s=%s" % (a, b) for a, b in self.items() if b]

    def _raw(self, txt): self._target._raw(txt)

    def say(self, channel, txt): self._target.say(channel, txt)

    def display(self, *args, **kwargs):
        for res in sorted(self._result.keys()): self.say(self.channel or "", self._result[res])

    def format(self, *args, **kwargs):
        keys = args[0]
        result = ""
        for key in keys: result += "%s - " % self[key]
        return result[:-3]

    def handle(self, *args , **kwargs): return resolve(self, *args, **kwargs)

## TASKS

class TaskRunner(threading.Thread):

    def __init__(self, *args, **kwargs):
        threading.Thread.__init__(self, None, self._loop, "thread.%s" % str(time.time()), args, kwargs)
        self.setDaemon(True)
        self._queue = queue.Queue()
        self._state = "idle"

    def _loop(self):
        while self._state in ["running", "idle", "callback", "once"]:
            try: args, kwargs = self._queue.get() ; cb.handle_cb(args[0])
            except (KeyboardInterrupt, EOFError): pass
            except: error()

    def put(self, *args, **kwargs): self._queue.put((args, kwargs)) ; return 

## DISPATCH

class Dispatcher(Object):

    max = 50
    runners = collections.deque() 

    def stop(self, name=None):
        for taskrunner in self.runners:
            if name and name not in taskrunner.name: continue
            taskrunner.stop()

    def put(self, *args, **kwargs):
        if not args: raise NoTask()
        target = self.get_target()
        target.put(*args, **kwargs)
        return args[0]

    def get_target(self):
        target = None
        for taskrunner in self.runners:
            if taskrunner._queue and taskrunner._state == "idle": target = taskrunner
        if not target: target = self.makenew()
        return target

    def makenew(self, *args, **kwargs):
        if len(self._runners) < self.max:
            taskrunner = TaskRunner(*args, **kwargs)
            taskrunner.start()
            self.runners.append(taskrunner)
        else: taskrunner = random.choice(self._runners)
        return taskrunner

    def cleanup(self, dojoin=False):
        todo = []
        for taskrunner in self.runners:
            if taskrunner.stopped or not len(taskrunner.queue): todo.append(taskrunner)
        for taskrunner in todo: taskrunner.stop()
        for taskrunner in todo: self.runners.remove(taskrunner)

## CALLBACKS

class Callbacks(Dispatcher):

    def register(self, cbtype, cb):
        logging.info("register %s - %s" % (cbtype, str(cb))) 
        if cbtype not in self: self[cbtype] = []
        self[cbtype].append(cb)

    def handle_cb(self, *args, **kwargs):
        event = args[0]
        target = get_cls(event)
        logging.info("cb %s" % target)
        functions = []
        try: functions.extend(self[target])
        except KeyError: pass
        for func in functions:
            try: pre = getattr(func, "pre")
            except AttributeError: pre = None
            if pre and not pre(event): logging.debug("pre %s" % str(func)) ; return
            try: result = func(event)
            except: error()
        return event

## BOTS

class Bot(Callbacks): 

    def connect(self, *args, **kwargs): pass

    def exit(self, *args, **kwargs):
        try: sys.stdout.flush() 
        except Exception as ex: logging.warn(str(ex))

    def get_one(self): return Object()

    def read_some(self, *args, **kwargs): pass

    def run(self, *args, **kwargs):
        if not self._state: self._state = "running"
        try: self.connect()
        except socket.gaierror: error() ; self._state = "error"
        if self.loop: _thread.start_new_thread(self.loop, ())
        while self._state in ["running", "once"]:
            try: event = self.get_one() ; event._target = self ; self.put(event) ; event.wait() 
            except AttributeError: time.sleep(0.1)
            except KeyboardInterrupt: break
            if self._state == "once": break
        self.exit()

## PLUGINS

class Plugins(Object):

    def get_names(self, plugsdir): return [x[:-3] for x in os.listdir(plugsdir) if x.endswith(".py")]

    def load_plugs(self, path):
        logging.warn("plugins %s" % path)
        for plugname in self.get_names(path):
            if "__" in plugname: continue
            try: mod = self.load_mod(plugname, path, force=True)
            except: error() ; continue

    def load_package(self, modname):
        mod = __import__(modname)
        path, fn = os.path.split(mod.__file__)
        path += os.sep + "plugs"
        self.load_plugs(path)        

    def load_mod(self, plugname, pdir="", force=False):
        logging.info("load %s - %s" % (self.what.lower(), plugname))
        if plugname in self:
            if not force: return self[plugname]
            self[plugname] = imp.reload(self[plugname])
        else:
            if not pdir: pdir = j(self.root, "plugs")
            search = imp.find_module(plugname, [pdir,])
            self[plugname] = imp.load_module(plugname, *search)
        self.plug_exec(plugname, "init")
        return self[plugname]

    def plug_exec(self, plugname, item):
        try: todo = getattr(self[plugname], item) ; todo() ; logging.info("exec %s" % get_name(todo))
        except AttributeError: pass

    def unload(self, plugname):
        self.plug_exec(plugname, "shutdown")
        del self[plugname]

    def reload(self, plugname, force=False):
        self.unload(plugname)
        mod = self.load_mod(plugname, force)
        return mod

## BOOT

def boot(defaultdir=""):
    global config
    try: config.opts, config.args = make_opts()
    except SystemExit: os._exit(1)
    config.update(vars(config.opts))
    for arg in config.args:
        try: var, val = arg.split("=") ; config[var] = val ; continue
        except ValueError: pass
    if config.do_local: config.workdir = j(os.getcwd(), "workdir") 
    if not config.workdir: config.workdir = defaultdir or ".atl"
    make_dir(config.workdir)
    if not config.loglevel: config.loglevel = "error"
    from atl.log import log_config
    log_config(config.loglevel)
    if config.lglevel:
        logging.warn("")
        logging.warn("E G G S")
        logging.warn("")
        show_eggs()
    if config.loglevel:
        logging.warn("C O N F I G")
        logging.warn("")
        for line in config.show_items(): logging.warn(line)
    if config.loglevel:
        logging.warn("")
        logging.warn("B O O T")
        logging.warn("")
    cb.register("Object", handle_loop)
    return config

## HANDLER

def handle_loop(event): event.prepare() ; event.handle() ; event.display() ; event.ready()

## VARS

fleet = collections.deque()
plugins = Plugins()
cb = Callbacks()
cmnds = Callbacks()
tools = Callbacks()
tests = Callbacks()
config = Object()

## Tool class, YOU REFUSE TO SEE _ FEEL _ AND ALL !!

Tool = Object()
