# atl/drivers.py
#
#

""" drivers package. """

from atl import NoSuchBotType
from atl.drivers.xmpp import XMPPBot
from atl.drivers.irc import IRCBot
from atl.drivers.line import CLIBot

## get_bot factory function

def get_bot(type, config):
    if type == "IRC": return IRCBot(**config)
    elif type == "XMPP": return XMPPBot(**config)
    elif type == "CLI": return cLIBot(**config)
    else: raise NoSuchBotType(type)
