 # atl/drivers//console.py
#
#

""" console bot. """

## IMPORTS

from atl.defines import BOLD, ENDC, YELLOW
from atl.log import datefmt
from atl import Bot, Object, cb

import logging
import time
import sys
import os

## CONSOLE

class ConsoleBot(Bot):

    def _raw(self, txt):
        try: sys.stdout.write(txt)
        except Exception as ex: logging.warn(str(ex))

    def say(self, *args, **kwargs):
        try: txt = args[1]
        except IndexError: txt = args[0]
        self._raw("%s\n" % txt)
        
    def get_one(self): return Object(txt=input("%s -=- %s%s<%s " % (time.strftime(datefmt), BOLD, YELLOW, ENDC)))
