from atlassian import Atlassian


class Confluence(Atlassian):

    def create_page(self, space, parent, title, body):
        return self.post("/rest/api/content/", {
            "type": "page",
            "title": title,
            "ancestors": [{"type": "page", "title": parent}],
            "space": {"key": space},
            "body": {"storage": {
                "value": body,
                "representation": "storage"}}})
