require({cache:{
'url:app/form/templates/LabelManager.html':"<div>\n    <div class=\"labelContainer\" data-dojo-attach-point=\"labelContainer\">\n        <button data-dojo-attach-point=\"labelButton\"></button>\n        <div data-dojo-attach-point=\"prefLabelListNode\"></div>\n        <div data-dojo-attach-point=\"altLabelListNode\"></div>\n        <div data-dojo-attach-point=\"hiddenLabelListNode\"></div>\n    </div>\n</div>"}});
define([
        "dojo/_base/declare",
        "dijit/Dialog",
        "dijit/_WidgetBase",
        "dijit/_TemplatedMixin",
        "dijit/form/Button",
        "dijit/form/Select",
        "dgrid/OnDemandGrid",
        "dijit/form/TextBox",
        "dojox/layout/TableContainer",
        "dojo/_base/lang",
        "dojo/dom-construct",
        "dojo/store/Memory",
        "dgrid/editor",
        "dgrid/extensions/ColumnHider",
        "dojo/_base/array",
        "dojo/on",
        "./ConceptDetailList",
        "dojo/text!./templates/LabelManager.html"

    ],
    function (declare, Dialog, WidgetBase, TemplatedMixin, Button, Select, OnDemandGrid, TextBox, TableContainer, lang, domConstruct, Memory, editor, ColumnHider, arrayUtil, on, ConceptDetailList, template) {
        return declare(
            "app/form/LabelManager",
            [WidgetBase, TemplatedMixin],
            {
                templateString: template,

                name: 'LabelManager',
                title: 'Labels:',
                labelGrid: null,
                titleLabel: null,
                LabelGridContent: null,
                languageComboBox: null,
                labelTypeComboBox: null,
                prefLanguage: null,
                labels: null,
                tempLabels: null,//this variable is used to recover the labels if user delete a label and then press on the cancel button
                EditLabelButton: null,

                buildRendering: function () {
                    this.inherited(arguments);
                },
                postCreate: function () {
                    this.inherited(arguments);
                    var self = this;
                    //noinspection CommaExpressionJS

                    self.EditLabelButton = new Button({
                        label: "Add Labels",
                        showLabel: true,
                        iconClass: 'plusIcon',
                        onClick: function () {
                            var dlg = self._createDialog();
                            if (self.labels) {
                                self._setGrid(self.labels);
                               // self._setLanguageComboBox(self.labels);
                            }
                            dlg.show();
                            self.labelGrid.resize();
                            self.labelGrid.refresh();
                        }
                    }, this.labelButton);

                    this.prefLabelList = new ConceptDetailList({ }, this.prefLabelListNode);
                    this.altLabelList = new ConceptDetailList({}, this.altLabelListNode);
                    this.hiddenLabelList = new ConceptDetailList({}, this.hiddenLabelListNode);


                },

                _createDialog: function () {
                    var self = this;
                    var dlg = new Dialog({
                        style: "width: 600px",
                        title: "Add Labels",
                        doLayout: true
                    });

                    var mainDiv = domConstruct.create("div");
                    domConstruct.place(mainDiv, dlg.containerNode);
                    var tableBoxDiv = domConstruct.create("div");
                    domConstruct.place(tableBoxDiv, mainDiv, "first");
                    var labelTabForBoxes = new TableContainer({cols: 4, spacing: 10, orientation: "vert"}, tableBoxDiv);


                    var labelType = this._getLabelType();

                    var labelTypeComboBox = new Select(
                        {
                            id: "TypeComboBox",
                            name: "labelTypeComboBox",
                            title: "Type of label:",
                            placeHolder: 'Select a type',
                            options: labelType,
                            style: { width: '120px' }

                        });
                    var languages = this._getLanguages();
                    self.prefLanguage = languages;
                    var langStoreComboBox = new Select
                    (
                        {
                            id: "langStoreComboBox",
                            name: "langStoreComboBox",
                            title: "Language:",
                            placeHolder: 'Select a language',
                            options: languages,
                            style: { width: '80px' }

                        }
                    );

                    var addLabelButtonToTable = new Button
                    (
                        {
                            iconClass: 'plusIcon',
                            showLabel: false,
                            onClick: lang.hitch(this, function () {

                                console.log("Add label to tabel in add label dialog");

                                self.labelGrid.store.add({
                                    label: self.titleLabel.get('value'),
                                    language: self.languageComboBox.get('displayedValue'),
                                    languageValue: self.languageComboBox.get('value'),
                                    type:self.labelTypeComboBox.get('value') ,
                                    typeDisplayed: self.labelTypeComboBox.get('displayedValue')});
                                self.labelGrid.resize();
                                self.labelGrid.refresh();

                                //self._checkPrefLabelRules(self.labelTypeComboBox.get('value'));

                            })
                        }
                    );

                    var titleLabel = new TextBox({id: "titleLabel", title: "Title:"});

                    self.titleLabel = titleLabel;
                    self.labelTypeComboBox = labelTypeComboBox;
                    self.languageComboBox = langStoreComboBox;

                    labelTabForBoxes.addChild(titleLabel);
                    labelTabForBoxes.addChild(langStoreComboBox);
                    labelTabForBoxes.addChild(labelTypeComboBox);
                    labelTabForBoxes.addChild(addLabelButtonToTable);
                    labelTabForBoxes.startup();

                    var gridDiv = domConstruct.create("div");
                    var labelGrid = this._createGrid(gridDiv);
                    domConstruct.place(gridDiv, mainDiv, "last");

                    self.labelGrid = labelGrid;

                    var actionBar = domConstruct.create("div", {
                        'class': "dijitDialogPaneActionBar"
                    }, dlg.containerNode);

                    var addBtn = new Button({
                        "label": "Save"
                    }).placeAt(actionBar);
                    var cancelBtn = new Button({
                        "label": "Cancel"
                    }).placeAt(actionBar);

                    addBtn.onClick = function () {

                        self._createNodeList(self.labelGrid.store.data);
                        self.labels = self.labelGrid.store.data;
                        self.SetEditLabelButton();
                        dlg.hide();
                    };
                    cancelBtn.onClick = function () {
                        dlg.hide();
                    };

                    on(self.labelTypeComboBox, "change", function () {

                         //   self._checkPrefLabelRules(self.labelTypeComboBox.get('value'));

                        }
                    );

                    on(dlg, "hide", function () {
                        self.labels = lang.clone(self.tempLabels);
                        titleLabel.destroy();
                        labelTypeComboBox.destroy();
                        langStoreComboBox.destroy();
                    });

                    return dlg;


                },

                _getLabelType: function () {

                    var Type = [
                        {label: "Preferred", value: "prefLabel"},
                        {label: "Alternative", value: "altLabel"},
                        {label: "Hidden", value: "hiddenLabel"}
                    ];

                    return Type;
                },

                _getLanguages: function () {
                    var languages = [
                        {label: "NL", value: "nl", disabled: false},
                        {label: "FR", value: "fr", disabled: false},
                        {label: "EN", value: "en", disabled: false}

                    ];

                    return languages;

                },
                _createGrid: function (gridDiv) {
                    var self = this;
                    var columns;
                    columns = [
                        {label: "Title", field: "label"},
                        {label: "Language", field: "language"},
                        {label: "Language", field: "languageValue", unhidable: true, hidden: true},
                        {label: "Type", field: "typeDisplayed"},
                        {label: "Type", field: "type", unhidable: true, hidden: true},
                        editor({label: " ", field: 'button',
                                editorArgs: {label: "delete", showLabel: false, iconClass: 'minIcon', onClick: function (event) {

                                    var row = grid.row(event);
                                    self.languageComboBox.getOptions(row.data.languageValue).disabled=false;
                                    var itemToDelete = row.data.id;
                                    grid.store.remove(itemToDelete);
                                    grid.resize();
                                    grid.refresh();
                                   // self._checkPrefLabelRules(row.data.type);
                                }
                                }},
                            Button)
                    ];
                    var gridStore = new Memory({
                        data: []

                    });
                    var grid = new (declare([OnDemandGrid, ColumnHider]))({
                        columns: columns,
                        store: gridStore,
                        selectionMode: "single" // for Selection; only select a single row at a time
                    }, gridDiv);

                    grid.startup();

                    return grid;
                },
                _createNodeList: function (labels) {
                    var mapLabel = this.prefLabelList.mapLabelsForList(labels, "prefLabel");
                    this.prefLabelList.buidList(mapLabel, "Preferred labels", false);
                    mapLabel = this.altLabelList.mapLabelsForList(labels, "altLabel");
                    this.altLabelList.buidList(mapLabel, "Alternate labels", false);
                    mapLabel = this.hiddenLabelList.mapLabelsForList(labels, "hiddenLabel");
                    this.hiddenLabelList.buidList(mapLabel, "Hidden labels", false);
                },
                _setGrid: function (labels) {
                    var gridStore = new Memory({
                        data: labels

                    });
                    this.labelGrid.set("store", gridStore);
                },
                _mapLabelToDisplayedLabel: function (labels, typevalue, typeToBeDisplayed) {

                    var self = this;
                    var filteredItems = arrayUtil.filter(labels, function (item) {
                        return item.type == typevalue;
                    });
                    return arrayUtil.map(filteredItems, function (item) {
                        return {label: item.label, language: self._getLanguageToDisplay(item.language), languageValue: item.language, type: item.type, typeDisplayed: typeToBeDisplayed};
                    });
                },
                _getLanguageToDisplay: function (language) {
                    switch (language) {
                        case "nl":
                            return "NL";
                            break;
                        case "fr":
                            return "FR";
                            break;
                        case "en":
                            return "EN";
                            break;
                        default:
                            return language;
                            break;
                    }
                },

                //not in use for the moment
                _checkPrefLabelRules: function (value) {
                    var self = this;
                    if (value == "prefLabel") {
                        var filteredPrefLabel = arrayUtil.filter(self.labelGrid.store.data, function (item) {

                                return item.typeValue == "prefLabel";

                            }
                        );
                        if (filteredPrefLabel.length > 0) {
                            arrayUtil.forEach(filteredPrefLabel, function (item) {
                                    self.languageComboBox.getOptions(item.languageValue).disabled = true;
                                    self.languageComboBox.getOptions(item.languageValue).selected = false;
                                }
                            );
                            var enabledLanguages=arrayUtil.filter(self.languageComboBox.get("options"),function(item)
                            {
                                return item.disabled==false;
                            });
                            if (enabledLanguages.length > 0) {
                                if (self.labelTypeComboBox.get("value") == "prefLabel") {
                                    self.languageComboBox.getOptions(enabledLanguages[0].value).selected = true;
                                    self.languageComboBox.set("displayedValue", enabledLanguages[0].label);
                                }
                                if (enabledLanguages.length == 1) {
                                    arrayUtil.forEach(self.labelTypeComboBox.get("options"), function (item) {
                                            self.labelTypeComboBox.getOptions(item.value).disabled = false;
                                        }
                                    );
                                }
                            }
                            else {
                                self.labelTypeComboBox.getOptions("altLabel").selected = true;
                                self.labelTypeComboBox.getOptions("prefLabel").selected = false;
                                self.labelTypeComboBox.getOptions("prefLabel").disabled = true;
                                self.labelTypeComboBox.set("displayedValue", self.labelTypeComboBox.getOptions("altLabel").label);
                                arrayUtil.forEach(self.languageComboBox.get("options"), function (item) {
                                        self.languageComboBox.getOptions(item.value).disabled = false;
                                    }
                                );
                                self.languageComboBox.reset();
                            }
                        }
                        else {
                            self._resetLanguageComboBox();
                        }
                    }
                    else {
                        self._resetLanguageComboBox();
                    }
                },

                _resetLanguageComboBox: function () {
                    var self=this;
                    arrayUtil.forEach(self.languageComboBox.get("options"), function (item) {
                            self.languageComboBox.getOptions(item.value).disabled = false;
                        }
                    );

                },
                getLabels: function () {
                    if(this.labelGrid)
                    {
                     return  arrayUtil.map(this.labelGrid.store.data, function (label) {
                        return {"type": label.type, "language": label.languageValue, "label": label.label};
                        });
                    }
                    else
                    {
                        return  arrayUtil.map(this.labels, function (label) {
                        return {"type": label.type, "language": label.languageValue, "label": label.label};
                        });

                    }

                },

                setLabels: function (labels) {
                    console.log("set labels: " + labels);

                    this.labels = this._mapLabelToDisplayedLabel(labels, "prefLabel", "Preferred");
                    this.labels.push.apply(this.labels, this._mapLabelToDisplayedLabel(labels, "altLabel", "Alternative"));
                    this.labels.push.apply(this.labels, this._mapLabelToDisplayedLabel(labels, "hiddenLabel", "Hidden"));
                    this._createNodeList(this.labels);
                    this.tempLabels = lang.clone(this.labels);
                },

                SetEditLabelButton: function () {
                    this.EditLabelButton.set("label", "Edit labels");
                    this.EditLabelButton.set("iconClass", "");

                },
                reset: function () {
                    this.prefLabelList.reset();
                    this.altLabelList.reset();
                    this.hiddenLabelList.reset();
                    this.labels = null;
                    this.tempLabels = null;
                    this.labelGrid=null;
                    this.EditLabelButton.set("label", "Add labels");
                    this.EditLabelButton.set("iconClass", "plusIcon");
                }
            });
    });
