// wrapped by build app
define(["dojo","dijit","dojox","dojo/require!dojox/mobile/app/_Widget,dojo/fx"], function(dojo,dijit,dojox){
dojo.provide("dojox.mobile.app.ListSelector");
dojo.experimental("dojox.mobile.app.ListSelector");

dojo.require("dojox.mobile.app._Widget");
dojo.require("dojo.fx");

dojo.declare("dojox.mobile.app.ListSelector", dojox.mobile.app._Widget, {

	// data: Array
	//		The array of items to display.  Each element in the array
	//		should have both a label and value attribute, e.g.
	//		[{label: "Open", value: 1} , {label: "Delete", value: 2}]
	data: null,

	// controller: Object
	//		The current SceneController widget.
	controller: null,

	// onChoose: Function
	//		The callback function for when an item is selected
	onChoose: null,

	destroyOnHide: false,

	_setDataAttr: function(data){
		this.data = data;
	
		if(this.data){
			this.render();
		}
	},

	postCreate: function(){
		dojo.addClass(this.domNode, "listSelector");
	
		var _this = this;
	
		this.connect(this.domNode, "onclick", function(event){
			if(!dojo.hasClass(event.target, "listSelectorRow")){
				return;
			}
	
			if(_this.onChoose){
				_this.onChoose(_this.data[event.target._idx].value);
			}
			_this.hide();
		});

		this.connect(this.domNode, "onmousedown", function(event){
			if(!dojo.hasClass(event.target, "listSelectorRow")){
				return;
			}
			dojo.addClass(event.target, "listSelectorRow-selected");
		});

		this.connect(this.domNode, "onmouseup", function(event){
			if(!dojo.hasClass(event.target, "listSelectorRow")){
				return;
			}
			dojo.removeClass(event.target, "listSelectorRow-selected");
		});

		this.connect(this.domNode, "onmouseout", function(event){
			if(!dojo.hasClass(event.target, "listSelectorRow")){
				return;
			}
			dojo.removeClass(event.target, "listSelectorRow-selected");
		});
	
		var viewportSize = this.controller.getWindowSize();
	
		this.mask = dojo.create("div", {"class": "dialogUnderlayWrapper",
			innerHTML: "<div class=\"dialogUnderlay\"></div>"
		}, this.controller.assistant.domNode);
	
		this.connect(this.mask, "onclick", function(){
			_this.onChoose && _this.onChoose();
			_this.hide();
		});
	},

	show: function(fromNode){

		// Using dojo.fx here. Must figure out how to do this with CSS animations!!
		var startPos;
	
		var windowSize = this.controller.getWindowSize();
		var fromNodePos;
		if(fromNode){
			fromNodePos = dojo._abs(fromNode);
			startPos = fromNodePos;
		}else{
			startPos.x = windowSize.w / 2;
			startPos.y = 200;
		}
		console.log("startPos = ", startPos);
	
		dojo.style(this.domNode, {
			opacity: 0,
			display: "",
			width: Math.floor(windowSize.w * 0.8) + "px"
		});
	
		var maxWidth = 0;
		dojo.query(">", this.domNode).forEach(function(node){
			dojo.style(node, {
				"float": "left"
			});
			maxWidth = Math.max(maxWidth, dojo.marginBox(node).w);
			dojo.style(node, {
				"float": "none"
			});
		});
		maxWidth = Math.min(maxWidth, Math.round(windowSize.w * 0.8))
					+ dojo.style(this.domNode, "paddingLeft")
					+ dojo.style(this.domNode, "paddingRight")
					+ 1;
	
		dojo.style(this.domNode, "width", maxWidth + "px");
		var targetHeight = dojo.marginBox(this.domNode).h;
	
		var _this = this;
	
	
		var targetY = fromNodePos ?
				Math.max(30, fromNodePos.y - targetHeight - 10) :
				this.getScroll().y + 30;
	
		console.log("fromNodePos = ", fromNodePos, " targetHeight = ", targetHeight,
				" targetY = " + targetY, " startPos ", startPos);
	
	
		var anim1 = dojo.animateProperty({
			node: this.domNode,
			duration: 400,
			properties: {
				width: {start: 1, end: maxWidth},
				height: {start: 1, end: targetHeight},
				top: {start: startPos.y, end: targetY},
				left: {start: startPos.x, end: (windowSize.w/2 - maxWidth/2)},
				opacity: {start: 0, end: 1},
				fontSize: {start: 1}
			},
			onEnd: function(){
				dojo.style(_this.domNode, "width", "inherit");
			}
		});
		var anim2 = dojo.fadeIn({
			node: this.mask,
			duration: 400
		});
		dojo.fx.combine([anim1, anim2]).play();

	},

	hide: function(){
		// Using dojo.fx here. Must figure out how to do this with CSS animations!!
	
		var _this = this;
	
		var anim1 = dojo.animateProperty({
			node: this.domNode,
			duration: 500,
			properties: {
				width: {end: 1},
				height: {end: 1},
				opacity: {end: 0},
				fontSize: {end: 1}
			},
			onEnd: function(){
				if(_this.get("destroyOnHide")){
					_this.destroy();
				}
			}
		});
	
		var anim2 = dojo.fadeOut({
			node: this.mask,
			duration: 400
		});
		dojo.fx.combine([anim1, anim2]).play();
	},

	render: function(){
		// summary:
		//		Renders
	
		dojo.empty(this.domNode);
		dojo.style(this.domNode, "opacity", 0);
	
		var row;
	
		for(var i = 0; i < this.data.length; i++){
			// Create each row and add any custom classes. Also set the _idx property.
			row = dojo.create("div", {
				"class": "listSelectorRow " + (this.data[i].className || ""),
				innerHTML: this.data[i].label
			}, this.domNode);
	
			row._idx = i;
	
			if(i == 0){
				dojo.addClass(row, "first");
			}
			if(i == this.data.length - 1){
				dojo.addClass(row, "last");
			}
	
		}
	},


	destroy: function(){
		this.inherited(arguments);
		dojo.destroy(this.mask);
	}

});

});
