from django.utils.translation import ugettext_lazy as _
from django.contrib import admin

from provider.oauth2.admin import ClientAdmin

from . import models

class WebServiceAdmin(admin.ModelAdmin):
    prepopulated_fields = {'slug': ('name',)}

class AttributeReleaseInline(admin.TabularInline):
    model = models.AttributeRelease

class A2ClientAdmin(ClientAdmin):
    inlines = [AttributeReleaseInline]
    fieldsets = (
            (None, {'fields': (
                'name',
                'user',
                ) }),
            (_('Location'), {'fields': (
                'url',
                'redirect_uri',
                ) }),
            (_('Credentials'), {'fields': (
                'client_id',
                'client_type',
                'client_secret',
                ) }),
            (_('Logout'), 
                {'fields': ('logout_url', 'logout_use_iframe', 'logout_use_iframe_timeout'),}),)

admin.site.register(models.WebService, WebServiceAdmin)
admin.site.register(models.A2Client, A2ClientAdmin)
