###############################################################################
##
##  Copyright 2011 Tavendo GmbH
##
##  Licensed under the Apache License, Version 2.0 (the "License");
##  you may not use this file except in compliance with the License.
##  You may obtain a copy of the License at
##
##      http://www.apache.org/licenses/LICENSE-2.0
##
##  Unless required by applicable law or agreed to in writing, software
##  distributed under the License is distributed on an "AS IS" BASIS,
##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
##  See the License for the specific language governing permissions and
##  limitations under the License.
##
###############################################################################

from case import Case

class Case3_1(Case):

   DESCRIPTION = """Send small text message with <b>RSV = 1</b>."""

   EXPECTATION = """The connection is failed immediately (1002/protocol error), since RSV must be 0, when no extension defining RSV meaning has been negoiated."""

   def onOpen(self):
      self.expected[Case.OK] = []
      self.expectedClose = {"closedByMe": False,
                            "closeCode": [self.p.CLOSE_STATUS_CODE_PROTOCOL_ERROR],
                            "requireClean": False}
      self.p.sendFrame(opcode = 1, payload = "Hello, world!", rsv = 1)
      self.p.killAfter(1)
