def multi_as():
    """Returns anm with  input and physical as house graph"""
    import autonetkit
    import networkx as nx
    from autonetkit.load.load_json import simple_to_nx
    # returns a house graph
    data = {'directed': False,
            'graph': [('node_default',
                       {'asn': 1,
                        'device_type': 'router',
                        'host': 'localhost',
                        'ibgp_l3_cluster': u'None',
                        'ibgp_role': u'None',
                        'igp': 'ospf',
                        'ospf_area': 0,
                        'platform': 'netkit'}),
                      ('address_family', 'v4'),
                      ('file_type', 'graphml'),
                      ('enable_routing', True),
                      ('edge_default', {'ospf_cost': 1, 'type': 'physical'}),
                      ('specified_int_names', False)],
            'links': [{'dst': 'r2',
                       'dst_port': '_port1',
                       'id': 'e5',
                       'src': 'r1',
                       'src_port': '_port1',
                       'type': 'physical'},
                      {'dst': 'r8',
                       'dst_port': '_port1',
                       'id': 'e10',
                       'src': 'r10',
                       'src_port': '_port1',
                       'type': 'physical'},
                      {'dst': 'r9',
                       'dst_port': '_port1',
                       'id': 'e11',
                       'src': 'r10',
                       'src_port': '_port2',
                       'type': 'physical'},
                      {'dst': 'r2',
                       'dst_port': '_port2',
                       'id': 'e4',
                       'src': 'r3',
                       'src_port': '_port1',
                       'type': 'physical'},
                      {'dst': 'r1',
                       'dst_port': '_port2',
                       'id': 'e6',
                       'src': 'r4',
                       'src_port': '_port1',
                       'type': 'physical'},
                      {'dst': 'r2',
                       'dst_port': '_port3',
                       'id': 'e13',
                       'src': 'r4',
                       'src_port': '_port2',
                       'type': 'physical'},
                      {'dst': 'r5',
                       'dst_port': '_port1',
                       'id': 'e7',
                       'src': 'r4',
                       'src_port': '_port3',
                       'type': 'physical'},
                      {'dst': 'r7',
                       'dst_port': '_port1',
                       'id': 'e2',
                       'src': 'r4',
                       'src_port': '_port4',
                       'type': 'physical'},
                      {'dst': 'r3',
                       'dst_port': '_port2',
                       'id': 'e3',
                       'src': 'r5',
                       'src_port': '_port2',
                       'type': 'physical'},
                      {'dst': 'r6',
                       'dst_port': '_port1',
                       'id': 'e8',
                       'src': 'r5',
                       'src_port': '_port3',
                       'type': 'physical'},
                      {'dst': 'r8',
                       'dst_port': '_port2',
                       'id': 'e12',
                       'src': 'r5',
                       'src_port': '_port4',
                       'type': 'physical'},
                      {'dst': 'r8',
                       'dst_port': '_port3',
                       'id': 'e9',
                       'src': 'r6',
                       'src_port': '_port2',
                       'type': 'physical'},
                      {'dst': 'r8',
                       'dst_port': '_port4',
                       'id': 'e0',
                       'src': 'r7',
                       'src_port': '_port2',
                       'type': 'physical'},
                      {'dst': 'r9',
                       'dst_port': '_port2',
                       'id': 'e1',
                       'src': 'r7',
                       'src_port': '_port3',
                       'type': 'physical'}],
            'multigraph': False,
            'nodes': [{'asn': 1,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'A',
                       'ibgp_role': u'RRC',
                       'id': 'r1',
                       'igp': 'ospf',
                       'label': 'r1',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r1 to r2', 'id': '_port1'},
                                 {'category': 'physical', 'description': 'r1 to r4', 'id': '_port2'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r1 to r2'},
                                          2: {'category': 'physical', 'description': 'r1 to r4'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 555.0,
                       'y': 285.0},
                      {'asn': 3,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'None',
                       'ibgp_role': u'Peer',
                       'id': 'r10',
                       'igp': 'ospf',
                       'label': 'r10',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r10 to r8', 'id': '_port1'},
                                 {'category': 'physical', 'description': 'r10 to r9', 'id': '_port2'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r10 to r8'},
                                          2: {'category': 'physical', 'description': 'r10 to r9'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 765.0,
                       'y': 500.52000000000004},
                      {'asn': 1,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'A',
                       'ibgp_role': u'RRC',
                       'id': 'r2',
                       'igp': 'ospf',
                       'label': 'r2',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r2 to r1', 'id': '_port1'},
                                 {'category': 'physical',
                                  'description': 'r2 to r3', 'id': '_port2'},
                                 {'category': 'physical', 'description': 'r2 to r4', 'id': '_port3'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r2 to r1'},
                                          2: {'category': 'physical', 'description': 'r2 to r3'},
                                          3: {'category': 'physical', 'description': 'r2 to r4'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 645.0,
                       'y': 255.0},
                      {'asn': 1,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'A',
                       'ibgp_role': u'RRC',
                       'id': 'r3',
                       'igp': 'ospf',
                       'label': 'r3',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r3 to r2', 'id': '_port1'},
                                 {'category': 'physical', 'description': 'r3 to r5', 'id': '_port2'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r3 to r2'},
                                          2: {'category': 'physical', 'description': 'r3 to r5'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 765.0,
                       'y': 255.0},
                      {'asn': 1,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'A',
                       'ibgp_role': u'RR',
                       'id': 'r4',
                       'igp': 'ospf',
                       'label': 'r4',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r4 to r1', 'id': '_port1'},
                                 {'category': 'physical',
                                  'description': 'r4 to r2', 'id': '_port2'},
                                 {'category': 'physical',
                                  'description': 'r4 to r5', 'id': '_port3'},
                                 {'category': 'physical', 'description': 'r4 to r7', 'id': '_port4'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r4 to r1'},
                                          2: {'category': 'physical', 'description': 'r4 to r2'},
                                          3: {'category': 'physical', 'description': 'r4 to r5'},
                                          4: {'category': 'physical', 'description': 'r4 to r7'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 645.0,
                       'y': 345.0},
                      {'asn': 1,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'A',
                       'ibgp_role': u'RR',
                       'id': 'r5',
                       'igp': 'ospf',
                       'label': 'r5',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r5 to r4', 'id': '_port1'},
                                 {'category': 'physical',
                                  'description': 'r5 to r3', 'id': '_port2'},
                                 {'category': 'physical',
                                  'description': 'r5 to r6', 'id': '_port3'},
                                 {'category': 'physical', 'description': 'r5 to r8', 'id': '_port4'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r5 to r4'},
                                          2: {'category': 'physical', 'description': 'r5 to r3'},
                                          3: {'category': 'physical', 'description': 'r5 to r6'},
                                          4: {'category': 'physical', 'description': 'r5 to r8'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 765.0,
                       'y': 345.0},
                      {'asn': 2,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'None',
                       'ibgp_role': u'None',
                       'id': 'r6',
                       'igp': 'ospf',
                       'label': 'r6',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r6 to r5', 'id': '_port1'},
                                 {'category': 'physical', 'description': 'r6 to r8', 'id': '_port2'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r6 to r5'},
                                          2: {'category': 'physical', 'description': 'r6 to r8'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 894.616,
                       'y': 345.0},
                      {'asn': 3,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'None',
                       'ibgp_role': u'Peer',
                       'id': 'r7',
                       'igp': 'ospf',
                       'label': 'r7',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r7 to r4', 'id': '_port1'},
                                 {'category': 'physical',
                                  'description': 'r7 to r8', 'id': '_port2'},
                                 {'category': 'physical', 'description': 'r7 to r9', 'id': '_port3'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r7 to r4'},
                                          2: {'category': 'physical', 'description': 'r7 to r8'},
                                          3: {'category': 'physical', 'description': 'r7 to r9'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 645.0,
                       'y': 435.0},
                      {'asn': 3,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'None',
                       'ibgp_role': u'Peer',
                       'id': 'r8',
                       'igp': 'ospf',
                       'label': 'r8',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r8 to r10', 'id': '_port1'},
                                 {'category': 'physical',
                                  'description': 'r8 to r5', 'id': '_port2'},
                                 {'category': 'physical',
                                  'description': 'r8 to r6', 'id': '_port3'},
                                 {'category': 'physical', 'description': 'r8 to r7', 'id': '_port4'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r8 to r10'},
                                          2: {'category': 'physical', 'description': 'r8 to r5'},
                                          3: {'category': 'physical', 'description': 'r8 to r6'},
                                          4: {'category': 'physical', 'description': 'r8 to r7'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 765.0,
                       'y': 435.0},
                      {'asn': 3,
                       'device_type': 'router',
                       'host': 'localhost',
                       'ibgp_l3_cluster': u'None',
                       'ibgp_role': u'Peer',
                       'id': 'r9',
                       'igp': 'ospf',
                       'label': 'r9',
                       'ospf_area': 0,
                       'platform': 'netkit',
                       'ports': [{'category': 'loopback',
                                  'description': 'loopback',
                                  'id': 'Loopback0'},
                                 {'category': 'physical',
                                  'description': 'r9 to r10', 'id': '_port1'},
                                 {'category': 'physical', 'description': 'r9 to r7', 'id': '_port2'}],
                       'raw_interfaces': {0: {'category': 'loopback', 'description': 'loopback'},
                                          1: {'category': 'physical', 'description': 'r9 to r10'},
                                          2: {'category': 'physical', 'description': 'r9 to r7'}},
                       'specified_int_names': None,
                       'syntax': 'quagga',
                       'vrf': None,
                       'x': 645.0,
                       'y': 500.52}]}
    graph = simple_to_nx(data)
    anm = autonetkit.anm.NetworkModel()
    g_in = anm.add_overlay("input")
    g_in._replace_graph(nx.Graph(graph))
    # TODO: check if should build overlays here rather than clone in?
    g_phy = anm["phy"]
    g_phy._replace_graph(graph)
    return anm