/*
 * Decompiled with CFR 0.152.
 */
package org.pyant.tasks;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class PythonBaseTask
extends Task {
    protected Path pythonpath = null;
    protected String python = "python";
    protected boolean failonerror = true;
    protected int optimize = 0;
    private Commandline cmdline = null;

    protected void setPythonPathInExecute(Execute execute) {
        if (this.pythonpath != null) {
            Project project = this.getProject();
            project.log("pythonpath: " + this.pythonpath);
            String string = "PYTHONPATH=" + this.pythonpath;
            String[] stringArray = new String[]{string};
            execute.setEnvironment(stringArray);
        }
    }

    public void setPythonpath(Path path) {
        this.pythonpath = path;
    }

    public void setPythonpathref(String string) {
        Project project = this.getProject();
        this.pythonpath = (Path)project.getReference(string);
    }

    public String getPython() {
        return this.python;
    }

    public void setPython(String string) {
        this.python = string;
    }

    protected String fixFilePath(String string) {
        return string.replace('\\', '/');
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    protected void executeScript(Project project, File file, String string) {
        Commandline commandline = this.getCommandline();
        this.prepCommandline();
        Execute execute = this.createExecute(project, commandline, file);
        this.execExecuteTask(string, execute);
    }

    protected void execExecuteTask(String string, Execute execute) {
        try {
            int n = execute.execute();
            if (n != 0) {
                this.failureOcurred(string);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error executing task", (Throwable)iOException, this.getLocation());
        }
    }

    protected Execute createExecute(Project project, Commandline commandline, File file) {
        ExecuteStreamHandler executeStreamHandler = this.createStreamHandler();
        Execute execute = new Execute(executeStreamHandler, null);
        if (file != null) {
            execute.setWorkingDirectory(file);
        }
        this.setPythonPathInExecute(execute);
        execute.setAntRun(project);
        execute.setCommandline(commandline.getCommandline());
        return execute;
    }

    protected ExecuteStreamHandler createStreamHandler() {
        LogStreamHandler logStreamHandler = new LogStreamHandler((Task)this, 2, 1);
        return logStreamHandler;
    }

    protected Commandline getCommandline() {
        if (this.cmdline == null) {
            this.cmdline = this.createCommandline();
        }
        return this.cmdline;
    }

    protected Commandline createCommandline() {
        Commandline commandline = new Commandline();
        return commandline;
    }

    protected void prepCommandline() {
        this.cmdline.setExecutable(this.python);
        this.addCommandlineArgs(this.cmdline);
    }

    protected void addCommandlineArgs(Commandline commandline) {
        this.setOptimizeArgument(commandline);
    }

    protected void failureOcurred(String string) {
        this.log("failureOcurred", 4);
        if (this.failonerror) {
            throw new BuildException(string, this.getLocation());
        }
        this.log(string, 0);
    }

    public void setOptimize(int n) {
        this.optimize = n;
    }

    protected void setOptimizeArgument(Commandline commandline) {
        String string = null;
        if (this.optimize == 1) {
            string = "-O";
        } else if (this.optimize == 2) {
            string = "-OO";
        }
        if (string != null) {
            commandline.createArgument(true).setValue(string);
        }
    }
}

