#! /usr/bin/env python

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
try:
  from setuptools import setup
except ImportError:
  from distutils.core import setup

from sys import version_info
if version_info[:2] > (2, 5):
    install_requires = ['python-snappy']
else:
    install_requires = ['python-snappy', 'simplejson >= 2.0.9']

setup(
  name = 'avro',
  version = '1.6.0',
  packages = ['avro',],
  package_dir = {'avro': 'src/avro'},
  scripts = ["./scripts/avro"],

  # Project uses simplejson, so ensure that it gets installed or upgraded
  # on the target machine
  install_requires = install_requires,

  # metadata for upload to PyPI
  author = 'Apache Avro',
  author_email = 'avro-dev@hadoop.apache.org',
  description = 'Avro is a serialization and RPC framework.',
  license = 'Apache License 2.0',
  keywords = 'avro serialization rpc',
  url = 'http://hadoop.apache.org/avro',
)
