# -*- coding: utf-8 -*-
# $Id: tests.py 238727 2011-05-05 15:26:16Z glenfant $
"""Testing"""

from zope.publisher.browser import TestRequest
from Testing import ZopeTestCase
import Products.Five
from Products.Five import zcml as five_zcml
from Products.Five import fiveconfigure
import aws.zope2zcmldoc
from aws.zope2zcmldoc.config import CONTROLPANEL_ID

fiveconfigure.debug_mode = True
five_zcml.load_config('meta.zcml', Products.Five)
five_zcml.load_config('configure.zcml', Products.Five)
five_zcml.load_config('configure.zcml', aws.zope2zcmldoc)
fiveconfigure.debug_mode = False

ZopeTestCase.installPackage('aws.zope2zcmldoc')

_marker = {}

class TestZCMLDoc(ZopeTestCase.ZopeTestCase):

    def afterSetUp(self):
        # Installing the Control panel
        self.setRoles(['Manager'], name='test_user_1_')
        view = self.app.unrestrictedTraverse('@@install-aws-zope2zcmldoc')()
        return

    def beforeTearDown(self):
        # Removing control panel
        view = self.app.unrestrictedTraverse('@@uninstall-aws-zope2zcmldoc')()
        return

    def _getControlPanel(self):
        cp = self.app.Control_Panel
        return cp[CONTROLPANEL_ID]

    def _getControlPanelView(self, name, form=_marker):
        cp = self._getControlPanel()
        view = cp.unrestrictedTraverse(name)
        if form != _marker:
            view.request.form = form
        return view

    def test_have_controlpanel(self):
        """Control panel installation
        """
        cp = self.app.Control_Panel
        self.failUnless(CONTROLPANEL_ID in cp.objectIds(), "Control panel is not installed")
        return

    def test_cp_namespaces(self):
        # We have some base namespaces available from old times
        cp = self._getControlPanel()
        expected = ('', 'http://namespaces.zope.org/zope', 'http://namespaces.zope.org/meta')
        expected = set(expected)
        namespaces = set(cp.getNamespaces())
        self.failUnless(namespaces >= expected, "Some base namespaces are missing")
        return

    def test_cp_subdirs(self):
        # We have subdirectives for some directives
        cp = self._getControlPanel()
        expected = (('http://namespaces.zope.org/browser', u'menuItems'),
                    ('http://namespaces.zope.org/zope', u'class'))
        expected = set(expected)
        subdirs = set(cp.getSubdirs())
        self.failUnless(subdirs >= expected, "Some base namespaces are missing")
        return

    def test_manage_main(self):
        view = self._getControlPanelView('@@manage_main')
        for ns in view.namespaces():
            self.failUnless(ns.has_key('view_url'), "Missing view URL")
            self.failUnless(ns.has_key('namespace_url'), "Missing namespace URL")
        return

    def test_view_namespace(self):
        query = {'ns': 'http://namespaces.zope.org/zope'}
        view = self._getControlPanelView('@@view_namespace', form=query)
        directives = view.list_directives()
        for directive in directives:
            self.failUnless(directive.has_key('name'), "Directive has no name")
            self.failUnless(directive.has_key('view_url'), "Directive has no view URL")
        return

    def test_view_directive(self):
        query = {
            'ns': 'http://namespaces.zope.org/zope',
            'directive': 'class'
            }
        view = self._getControlPanelView('@@view_directive', form=query)
        subdirs = view.list_subdirectives()
        self.failUnless(len(subdirs) > 0, "'class' should have subdirectives")
        infos = view.directive_infos()
        self.failUnlessEqual(len(infos.attributes()), 1, "Only one attribute is required for 'class'")
        self.failUnlessEqual(infos.python_handler(), 'Products.Five.metaconfigure.ClassDirective',
                             "Expected 'Products.Five.metaconfigure.ClassDirective' handler")
        return


def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestZCMLDoc))
    return suite
