#!/usr/bin/env python
#
# Copyright (c) 2014 Vincent Janelle <randomfrequency@gmail.com>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# Tiny bits of logic taken from Cloudcaster.py, @WrathOfChris
#

import argparse
import boto
import boto.ec2
import boto.ec2.autoscale
import boto.ec2.elb
import boto.route53
import boto.route53.zone
import boto.vpc
import datetime
import json
import os
import re
import sys
import time
import pprint

from operator import itemgetter, attrgetter

MAX_COUNT=5
pp = pprint.PrettyPrinter(indent=4)

if 'AWS_ACCESS_KEY' in os.environ:
  aws_key = os.environ['AWS_ACCESS_KEY']
else:
  aws_key = None
if 'AWS_SECRET_KEY' in os.environ:
  aws_secret = os.environ['AWS_SECRET_KEY']
else:
  aws_secret = None

vpc_subnetids = []
vpc_pubsubnetids = []
nat_subnetidx = 0
nat_instances = []
nat_instwait = 5
nat_publicdns = None

parser = argparse.ArgumentParser(description="Remove stale AMI images generated by ec2autoimage")

parser.add_argument("-v", "--verbose", help="verbosity", action="store_true")
parser.add_argument("-n", "--dry-run", help="Dry run, noop mode", action="store_true")
parser.add_argument("file", help="cloudcaster JSON file")

args = parser.parse_args()
if args.file == None:
  parser.print_help()
  sys.exit(1)

verbose = args.verbose
dry_run = args.dry_run

conffile = open(args.file).read()
conf = json.loads(conffile)

# SETUP BOTO
awsvpc = boto.vpc.connect_to_region(conf['aws']['region'], aws_access_key_id=aws_key, aws_secret_access_key=aws_secret)
awsec2 = boto.ec2.connect_to_region(conf['aws']['region'], aws_access_key_id=aws_key, aws_secret_access_key=aws_secret)
awselb = boto.ec2.elb.connect_to_region(conf['aws']['region'], aws_access_key_id=aws_key, aws_secret_access_key=aws_secret)
awsiam = boto.connect_iam()
awsr53 = boto.connect_route53()
awsasg = boto.ec2.autoscale.connect_to_region(conf['aws']['region'], aws_access_key_id=aws_key, aws_secret_access_key=aws_secret)

lc_groups = {}

if dry_run:
    print "DRY RUN - NOT EXECUTING CLEANUP"

# Utility function to extract name and date from name
def extract_ami_names(ami):
    # name-"%Y%m%d%H%M%S"
    match = re.search("(.+)-(\d{14})", ami.name)
    if match:
        # "%Y%m%d%H%M%S"
        date = time.strptime(match.group(2), "%Y%m%d%H%M%S")
        return [ ami, match.group(1), date ]

# Scroll through all launch configurations to cache configurations
def get_launch_configurations():
  res = []
  lcs = awsasg.get_all_launch_configurations()
  for l in lcs:
    res.append(l)

  while lcs.next_token != None:
    lcs = awsasg.get_all_launch_configurations(next_token=lcs.next_token)
    for l in lcs:
      res.append(l)

  return res

def find_amibyname(name, amis):
  for a in amis:
    if str(a.name) == name:
      return a
    if re.match("%s-\d{14}" % name, str(a.name)):
      return a
  return None

def find_amibyid(id, amis):
    for a in amis:
        if str(a.id) == id:
            return a
    return None

def return_names(ami):
    return { "id": ami[0].id, "name": ami[0].name }

def return_amiid(ami):
    return ami[0].id

def return_lc_imageid(lc):
    return lc.image_id

# cache all launch configs

lcs = get_launch_configurations()

for app in conf['apps']:
# app = conf['apps'][4]
# if True:
    if verbose:
        print "Checking %s..." % ( app['name'] )

    amifilter = { 'name': "%s-%s-*" % (conf['aws']['env'], app['aminame']) }
    amis = awsec2.get_all_images(filters=amifilter)

    env = conf['aws']['env']

    if len(amis) == 0:
        if verbose:
            print "APP %s-%s has 0 entries !!!!" % ( env, app['aminame'] )
            print "Looking through \"all\" ..."

        env = "all"
        amifilter = { 'name': "all-%s-*" % app['aminame'] }
        amis = awsec2.get_all_images(filters=amifilter)

        if len(amis) == 0:
            print "APP %s-%s has no AMIs !?!" % ( conf['aws']['env'], app['aminame'] )

    ami = find_amibyname(".+-%s" % (app['aminame']), sorted(amis, key=lambda a: a.name, reverse=True))

    if len(amis) > 0:
        # avoid printing twice..
        if not verbose:
            print "Checking %s..." % ( app['name'] )

        # List of potential AMIs we can delete
        potential_amis = sorted(list(map(extract_ami_names, amis)), key=itemgetter(1,2), reverse=False)

        # Be very descriptive
        if verbose:
            for ami in amis:
                print "--> Found %s of %s-%s" % ( len(potential_amis), env, app['aminame'] )
                print "--> Considering (probably) %s of %s-%s" % ( len(potential_amis) - MAX_COUNT, env, app['aminame'] )

        # Converge just the sets of AMI IDs
        y = map( return_amiid, potential_amis )
        z = map( return_lc_imageid, lcs)

        leftovers = set(y).difference(set(z))
#        if verbose:
#            print "AMI IDs to be potentially removed %s" % ( leftovers)

        # Attempt to discover AMIs in use by running instances
        instances = awsec2.get_only_instances()

        res = []
        for instance in instances:
            for l in leftovers:
                if l == instance.image_id:
                    print "!!! %s still in use by %s:%s" % (l, instance.tags['Name'], instance.id )
                    res.append(instance.image_id)

        # pp.pprint(res)

        if len(set(leftovers).intersection(set(res))) > 0:
            print "!!! AMI IMAGE FOUND STILL IN USE, BUT NOT IN LC!"
            for image in set(res):
                print "!!! !!! %s" % ( image )
                # print find_amibyid(image, sorted(amis, key=lambda a: a.id, reverse=True))

        for image in set(leftovers) - set(res):
            ami=  find_amibyid(image, sorted(amis, key=lambda a: a.id, reverse=True))
            print "--> %s:%s" % ( ami.name, ami.id )




def main():
  pass
