
class version(str):
    def __cmp__(self, other):
        if not isinstance(other, basestring):
            raise TypeError

        a = version.normalize(self)
        b = version.normalize(other)
        return cmp(a, b)

    def __eq__(self, other):
        return self.__cmp__(other) == 0

    def __lt__(self, other):
        return self.__cmp__(other) == -1
    
    def __gt__(self, other):
        return self.__cmp__(other) == 1

    @staticmethod
    def normalize(v):
        parts = [int(x) for x in v.split('.')]
        while parts[-1] == 0:
            parts.pop()
        return parts

