# bard/bot.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import get_name, short_date, get_type
from bard.errors import RemoteDisconnect
from bard.dispatch import Dispatcher
from bard.defines import BLA, ENDC
from bard.object import Object

from bard import kernel, fleet

import logging
import socket
import time

## BOTS

class Bot(Dispatcher):

    """ Base Bot class. """

    def __init__(zelf, *args, **kwargs):
        Dispatcher.__init__(zelf, *args, **kwargs)
        zelf.channels = []

    ## OVERLOAD

    def handle_event(zelf, *args, **kwargs):
        event = args[0]
        command = event.check()
        target = None
        if command in kernel.cmnds: target = kernel.cmnds
        elif command in kernel.ctrl: target = kernel.ctrl
        if not target: return
        cmnds = target[command]
        for cmnd in cmnds:
            zelf.put(cmnd.func, *args, **kwargs)
            logging.info("dispatch %s" % event.type)

    ## CHANNELS

    def join_channels(zelf, *args, **kwargs):
        """ join channels.  """ 
        for channel in zelf.channels: zelf.join(channel)

    def announce(zelf, *args, **kwargs):
        """ announce on channels. """
        for channel in zelf.channels: zelf.say(channel, args[0])
                   
## TESTBOT

class TestBot(Bot):

    """ USE WITH Bot.put() and Bot.read(). """

    pass
