# bard/console.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.defines import BLA, GREEN, ENDC, pfc
from bard.errors import RemoteDisconnect
from bard.utils import short_date
from bard.object import Object
from bard.bot import Bot

from bard import kernel

import logging
import time
import sys

## CONSOLE

class ConsoleBot(Bot):

    """ bot running on the console. """

    def say(zelf, *args, **kwargs): sys.stdout.write(args[1] + "\n") ; sys.stdout.flush()

    def prompt(zelf, *args, **kwargs):
        return "%s %s<%s " % (short_date(time.ctime(time.time())).split()[1], GREEN, ENDC)

    def single(zelf, *args, **kwargs):
        if not kernel.cfg.args: return
        o = Object()
        o._target = zelf
        o.origin = "root@shell"
        o.txt = " ".join(kernel.cfg.args)
        zelf.handle_event(o)
        o.wait()
 
    def event(zelf, *args, **kwargs):
        o = Object()
        o._target = zelf
        o.origin = "root@shell"
        o.txt = input(zelf.prompt())
        return o
