# bard/looper.py
#
#

""" time related functionality. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import error, get_name
from bard.object import Object
from bard import kernel, fleet

import threading
import logging
import time

# TIMER

class Timer(Object):

    def __init__(zelf, time_alarm, event, *args, **kwargs):
        Object.__init__(zelf, *args, **kwargs)
        zelf.sleep = time_alarm - time.time()
        zelf._started = time.time()
        zelf._timer = threading.Timer(zelf.sleep, zelf.echo)
        zelf._status = "start"
        zelf._last = time.time()
        zelf._event = event

    def start(zelf, *args, **kwargs):
        zelf._started = time.time()
        zelf._timer.start()
        zelf._status = "running"
        
    def echo(zelf, *args, **kwargs):
        for bot in fleet: bot.announce(zelf._event.get_rest())
        
## LOOPS

class Looper(Object):

    """ a Looper calls a function every x seconds. """ 

    def __init__(zelf, func, sleeptime, *args, **kwargs):
        """ args = function, sleeptime. """
        Object.__init__(zelf, *args, **kwargs)
        zelf._func = func
        zelf.sleep = sleeptime
        zelf._started = time.time()
        zelf._last = time.time()
        zelf._status = "start"

    def start(zelf, *args, **kwargs):
        """ initialize a Looper. """
        zelf.cmnd = get_name(zelf._func)
        logging.info("looping %s" % zelf.cmnd)
        zelf._last = time.time()
        zelf._timer = threading.Timer(zelf.sleep, zelf.start)
        zelf._timer.start()
        zelf._status = "running"
        try: zelf._func()
        except: error()

    def exit(zelf, *args, **kwargs): zelf._timer.cancel()
