# bard/plugs.py
#
#

""" Plugins package, loads all plugins available. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.object import Object
from bard.utils import error

import importlib
import logging
import pkgutil

## PLUGINS

class Plugins(Object):

    """ object to register plugins with. """

    def start(zelf, modname):
        """ load plugins from the plugin directory. """
        mod = zelf.load(modname)
        for pkg in pkgutil.walk_packages(mod.__path__, mod.__name__+'.'):
            name = pkg[1].split(".")[-1]
            zelf[name] = zelf.load(pkg[1])

    def init(zelf, mods):
        from bard import kernel
        for name in mods.split(","):
            if not name or name not in zelf: continue
            logging.warn("init %s" % name)
            if name == "xmpp": zelf["xmpp"].init() ; continue
            try: kernel.workers.put(zelf[name].init)
            except: pass

    def load(zelf, name, force=True):
        """ load module. """
        logging.debug("! load %s" % name)
        if name in zelf and not force: mod = zelf.reload(name)
        else: mod = importlib.import_module(name)
        return mod

    def reload(zelf, *args, **kwargs):
        name = args[0]
        zelf[name] = importlib.reload(zelf[name])
        return zelf[name]
