# bard/plugs/clone.py
#
#

""" clone a remote workdir (api). """

## IMPORTS

from bard.utils import fetch_url
from bard.object import Object

from bard import kernel

import socket
import json

## COMMANDS

def clone(event):
    rest = event.get_rest()
    if not rest: return
    try: result = fetch_url("GET", rest + "/all").read()
    except socket.gaierror as ex: event.reply(str(ex)) ; return
    obj_list = json.loads(str(result, "utf-8"))
    for nr, url in obj_list.items():
        res = fetch_url("GET", url).read()
        obj = json.loads(str(res, "utf-8"))
        o = Object()
        o.update(obj)
        o.save()

kernel.ctrl.register("clone", clone)
