# bard/plugs/ls.py
#
#

""" show available commands. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard import kernel

## CMNDS

def ls(event):
    rest = event.rest()
    obj = kernel
    keys = True
    for mod in rest.split("."):
       try: obj = getattr(obj, mod) 
       except AttributeError: pass
    if not obj: return
    if "." in rest:
        try:
            res = ", ".join(obj.show()).strip()
            if res: event.reply(res)
        except AttributeError:
            res = str(obj)
            if res: event.reply(res)
    else:
        res = ", ".join([x for x in sorted(obj.names())])
        if res: event.reply(res.strip())

kernel.cmnds.register("ls", ls)
