# bard/bots/console.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.defines import BLA, GREEN, ENDC, pfc
from bard.errors import RemoteDisconnect
from bard.runtime import kernel, fleet
from bard.utils import short_date
from bard.object import Object
from bard.bot import Bot

import logging
import time
import sys

## CONSOLE

class ConsoleBot(Bot):

    """ bot running on the console. """

    def _raw(zelf, *args, **kwargs): sys.stdout.write(args[0] + "\n") ; sys.stdout.flush()

    def say(zelf, *args, **kwargs): zelf._raw(args[1])

    def prompt(zelf, *args, **kwargs):
        zelf.wait()
        return "%s %s<%s " % (short_date(time.ctime(time.time())).split()[1], GREEN, ENDC)

    def event(zelf, *args, **kwargs):
        event = Object()
        event._target = zelf
        event.origin = "root@shell"
        zelf.ready()
        event.txt = input(zelf.prompt())
        return event

    def start(zelf, *args, **kwargs):
        if not kernel.cfg.shell: zelf.single(" ".join(kernel.cfg.runargs)) ; return
        fleet.append(zelf)
        Bot.start(zelf)
