# bard/looper.py
#
#

""" time related functionality. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import error, get_named
from bard.object import Object
from bard.runtime import kernel, fleet

import threading
import logging
import time

# TIMER

class TIMER(Object):

    def __init__(zelf, time_alarm, event, *args, **kwargs):
        Object.__init__(zelf, *args, **kwargs)
        zelf.sleep = time_alarm - time.time()
        zelf._started = time.time()
        zelf._status = "start"
        zelf._last = time.time()
        zelf._running = "timer"
        zelf._event = event

    def start(zelf, *args, **kwargs):
        zelf._status = "running"
        time.sleep(zelf.sleep)        
        zelf.echo()

    def echo(zelf, *args, **kwargs):
        for bot in fleet: bot.announce(zelf._event.rest())
        
## LOOPS

class LOOPER(Object):

    """ a LOOPER calls a function every x seconds. """ 

    def __init__(zelf, func, sleeptime, *args, **kwargs):
        """ args = function, sleeptime. """
        Object.__init__(zelf, *args, **kwargs)
        zelf._func = func
        zelf._started = time.time()
        zelf._last = time.time()
        zelf._status = "start"
        zelf._running = get_named(zelf._func)
        zelf.sleep = sleeptime

    def start(zelf, *args, **kwargs):
        """ initialize a LOOPER. """
        zelf._status = "running"
        while zelf._status:
            zelf._last = time.time()
            try: zelf._func()
            except: error()
            time.sleep(zelf.sleep)

    def exit(zelf, *args, **kwargs): zelf._status = ""
