# bard/runtime.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.defaults import kernel as cfg_kernel
from bard.utils import make_opts, hello, error
from bard.dispatch import Dispatcher
from bard.defines import opts_defs
from bard.plugins import Plugins
from bard.object import Object
from bard.log import init

import logging
import os

## KERNEL

class Kernel(Plugins):

    def __init__(zelf, *args, **kwargs):
        Plugins.__init__(zelf, *args, **kwargs)
        opts, args = make_opts(opts_defs)
        zelf.cfg = Object()
        zelf.cfg.update(cfg_kernel)
        zelf.cfg.update(vars(opts))
        zelf.cfg.runargs = args
        zelf.cmnds = Dispatcher()
        zelf.workers = Dispatcher()

    def boot(zelf, *args, **kwargs):
        if args and zelf.cfg.shell: hello(args[0])
        init(zelf.cfg.loglevel)
        if zelf.cfg.loglevel != "error": print("\n".join(sorted(zelf.cfg.show()))) ; print("") 
        for package in zelf.cfg.packages:
            try: zelf.load(package)
            except: error()
        zelf.init(zelf.cfg.init)

    def shutdown(zelf, *args, **kwargs):
        """ close the program in a appropiate manner. """
        if zelf.cfg.shell: print("") ; logging.warn("exit") 
        for item in ["workers", "cmnds"]:
            logging.warn("stop %s" % item)
            if "stop" in zelf[item]: zelf[item].stop()

## DEFINES

kernel = Kernel()
fleet = []
