# bard/service/rss.py
#
#

""" rss module. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import parse_urls, short_date, fetch_url, error, strip_html
from bard.object import Object
from bard.looper import LOOPER
from bard.runtime import kernel

import threading
import logging
import socket
import time

## DEFINES

key_list = ["published", "title", "summary", "link"]

on_start = True

## display function

def display(*args, **kwargs):
    entry = args[0]
    counter = args[1]
    result = ""
    kernel.announce(" ")
    for key in key_list:
        try: kernel.announce("%s %s" % (counter, entry[key]))
        except Exception as ex: logging.info(str(ex))

## look function

def rss_fetch(*args, **kwargs):
    global on_start
    import bard.contrib.feedparser as fp
    seen = kernel.last("result", "rss")
    if not seen: seen = Object() ; seen.result = "rss" ; seen.list = []
    for obj in kernel.objects():
        if "rss" not in obj: continue
        counter = 1
        try:
            data = fetch_url("GET", obj.rss).read()
            data = fp.parse(data)
        except Exception as ex: error(obj.rss) ; continue
        for entry in data["entries"]:
            if entry["link"] not in seen.list:
                seen.list.append(entry["link"])
                o = Object(entry).slice(key_list)
                if "summary" in o: o["summary"] = strip_html(o["summary"]).rstrip()
                o.prefix = "rss"
                display(o, counter)
                o.save()
                counter += 1
                obj.last_poll = short_date(time.ctime())
                obj.sync()
    seen.sync()

kernel.cmnds.register("fetch", rss_fetch)

## RSS 

class RSS(LOOPER): pass

## INIT

def init(*args, **kwargs):
    rss = RSS(rss_fetch, 600)
    kernel.workers.put(rss.start)

