# bard/bot.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from bard.utils import get_name, short_date, get_type
from bard.errors import RemoteDisconnect
from bard.dispatcher import DISPATCHER
from bard.defines import BLA, ENDC
from bard.object import Object
from bard.runtime import kernel, fleet

import logging
import socket
import time

## BOTS

class BOT(DISPATCHER):

    """ Base Bot class. """

    def __init__(zelf, *args, **kwargs):
        DISPATCHER.__init__(zelf, *args, **kwargs)
        zelf._started = time.time()
        zelf.channels = ["#bard", ]
        
    def say(zelf, *args, **kwargs): print(args[1])
        
    ## CHANNELS

    def announce(zelf, *args, **kwargs):
        """ announce on channels. """
        logging.info("# announce %s" % " ".join(zelf.channels))
        for channel in zelf.channels: zelf.say(channel, args[0])

    def join(zelf, *args, **kwargs): pass
        
    def join_channels(zelf, *args, **kwargs):
        """ join channels.  """ 
        for channel in zelf.channels: zelf.join(channel)
            
## TESTBOT

class TEST(BOT):

    """ USE WITH Bot.put() and Bot.read(). """

    testing = True

    def say(zelf, *args, **kwargs): logging.warn(args[1])

    def event(zelf, *args, **kwargs):
        o = Object()
        o.origin = "test@bard"
        o._target = zelf
        o.loglevel = "warning"
        return o

