# bard/plugs/text.py
#
#

""" show JSON dump of objects. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from bard.runtime import kernel

import threading
import logging
import time
import re

## CMNDS

def text(event):
    rest = event.rest()
    objs = sorted(kernel.full(event.parsed), key=lambda x: x.get_timed())
    nr = 1
    for obj in objs:
        if obj.search(rest): event.reply("\n" + obj.format(nr, skiplist=["saved"])) ; nr += 1

kernel.register("text", text)
