# bard/runtime.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from bard.defaults import kernel as cfg_kernel
from bard.utils import make_opts, hello, error
from bard.dispatcher import DISPATCHER
from bard.defines import opts_defs
from bard.plugins import PLUGINS
from bard.object import Object
from bard.log import init

import logging
import os

## KERNEL

class KERNEL(PLUGINS, DISPATCHER):

    def __init__(zelf, *args, **kwargs):
        PLUGINS.__init__(zelf, *args, **kwargs)
        DISPATCHER.__init__(zelf, *args, **kwargs)

    def boot(zelf, *args, **kwargs):
        opts, args = make_opts(opts_defs)
        cfg.update(cfg_kernel)
        cfg.update(vars(opts))
        cfg.runargs = args
        if cfg.shell: hello(cfg.greeting)
        init(cfg.loglevel)
        if cfg.loglevel != "error": print("\n".join(sorted(cfg.show()))) ; print("") 
        for package in cfg.packages:
            try: zelf.load(package)
            except: error()
        zelf.init(cfg.init)
        zelf.ready()

    def shutdown(zelf, *args, **kwargs):
        logging.warn("shutdown")

## DEFINES

kernel = KERNEL()
cfg = Object()
fleet = []
