# bard/plugins.py
#
#

""" Plugins package, loads all plugins available. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from bard.object import Object
from bard.utils import error

import importlib
import logging
import pkgutil

## PLUGINS

class PLUGINS(Object):

    """ object to register plugins with. """

    def load(zelf, modname):
        """ load plugins from the plugin directory. """
        logging.warn("! load %s" % modname)
        mod = zelf.load_mod(modname)
        for pkg in pkgutil.walk_packages(mod.__path__, mod.__name__+'.'):
            name = pkg[1]
            zelf[name] = zelf.load_mod(name)

    def init(zelf, mods):
        modnames = mods.split(",") 
        for name in sorted(modnames)[::-1]:
            if not name: continue
            logging.warn("# start %s" % name.upper())
            modname = zelf.get_modname(name)
            obj = zelf.get(modname)
            if not obj: continue
            obj.plugname = modname
            if name == "xmpp": obj.init() ; continue
            zelf.put(obj.init)

    def stop(zelf, mods):
        modnames = mods.split(",") 
        for name in sorted(modnames)[::-1]:
            logging.warn("# init %s" % name)
            modname = zelf.get_modname(name)
            obj = zelf.get(modname)
            if not obj: continue
            zelf.put(obj.stop())

    def load_mod(zelf, name, force=True):
        """ load module. """
        logging.info("# module %s" % name)
        if name in zelf and not force: mod = zelf.reload(name)
        else: mod = importlib.import_module(name)
        return mod

    def reload(zelf, *args, **kwargs):
        name = args[0]
        zelf[name] = importlib.reload(zelf[name])
        return zelf[name]

    def get_modname(zelf, *args, **kwargs):
        name = args[0]
        obj = zelf.get("bard.services.%s" % name)
        if not obj: obj = zelf.get("bard.bots.%s" % name)
        if not obj: obj = zelf.get("bard.plugs.%s" % name)
        if not obj: return
        return str(obj.__name__)

    def reload_name(zelf, *args, **kwargs):
        name = zelf.get_modname(args[0])
        if name: return zelf.reload(name)
