# bard/plugs/ls.py
#
#

""" show available commands. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from bard.runtime import kernel, fleet

import types

## CMNDS

def ls(event):
    rest = event.rest()
    if not rest: event.reply(", ".join(sorted([x for x in kernel.names()]))) ; return
    obj = kernel.get(rest)
    if not obj:
        packagename, mod = rest.rsplit(".", 1)
        package = kernel.get(packagename)
        if package: obj = getattr(package, mod)
    if type(obj) == list: res = ", ".join([str(x) for x in obj])
    elif type(obj) == types.ModuleType: res = ", ".join(dir(obj))
    else: res = str(obj)
    event.reply(res)
 
kernel.register("ls", ls)
