# bard/udp.py
#
#

""" relay txt through a udp port listener. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from bard.utils import error, get_name
from bard.defaults import udp
from bard.contrib import rijndael
from bard.errors import StopIter
from bard.object import Object
from bard.runtime import kernel

import logging
import socket
import queue
import bard
import time
import re

crypt = rijndael.rijndael(udp.seed)

## UDP class

class UDP(Object):

    def __init__(zelf, *args, **kwargs):
        Object.__init__(zelf, *args, **kwargs)
        zelf._status = "idle"
        zelf._start = time.time()
        zelf._sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        zelf._sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        try: zelf._sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEPORT, 1)
        except: pass
        zelf._sock.setblocking(1)

    def start(zelf):
        zelf._sock.bind((udp.host, udp.port))
        logging.warn("# start %s/%s" % (udp.host, udp.port)) 
        zelf.ready()
        while zelf._status:
            input, addr = zelf._sock.recvfrom(64000)
            if not zelf._status: break
            input = str(input.rstrip(), "utf-8")
            data = ""
            for i in range(int(len(input)/16)):
                txt = input[i*16:i*16+16]
                try: data += crypt.decrypt(txt)
                except Exception as ex: error() ;  break
            if not data: break
            zelf.output(data, addr)
        
    def exit(zelf, *args, **kwargs):
        logging.warn("# exit %s" % get_name(zelf))
        zelf._status = ""
        zelf._sock.settimeout(1.0)
        zelf._sock.sendto(bytes("bla", "utf-8"), (udp.host, udp.port))
        #zelf._sock.shutdown(socket.SHUT_WR)

    def output(zelf, input, addr):
        passwd, text = input.split(" ", 1)
        text = text.replace("\00", "")
        if passwd == udp.password: kernel.announce(text)

def init(*args, **kwargs):
    server = UDP()
    kernel.put(server.start)
