# bard/plugs/keys.py
#
#

""" show all attributes available. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from bard.object import Object
from bard.runtime import kernel

import string
import time
import os

## CMNDS

def keys_do(event):
    result = []
    for obj in kernel.objects():
        for key in obj.obj():
            if key not in result: result.append(key)
    for arg in event.parsed.args:
        result = filter(lambda x: arg not in x, result)
    if result: event.reply(" ".join(result))

kernel.register("keys", keys_do)
