# bard/plugs/timer.py
#
#

""" time the timing. """

__copyright__ = "Copyright 2015, B.H.J Thate"

## IMPORTS

from bard.utils import get_day, get_hour, today, short_date
from bard.runtime import kernel
from bard.object import Object
from bard.looper import TIMER
import datetime
import threading
import logging
import time

## CMNDS

def timer(event):
    rest = event.rest()
    target = today() + get_day(rest) + get_hour(rest)
    event.reply("time detected: %s" % short_date(time.ctime(target)))
    timer = TIMER(target, event)
    kernel.put(timer.start)
    event.ok()

kernel.register("timer", timer)
