# apo/plugs/campagne.py
#
#

""" the thing to resolve. """

## IMPORTS

from bard.utils import a_time, nr_days, elapsed_days
from bard.object import Object
from bard.looper import Looper
from bard.runtime import kernel, fleet

## basic imports

import time
import logging
import random
import datetime

## SuicideWarnLoop

pogingenjaar = 94000
pogingendag = pogingenjaar / 365.0
pogingenuur = pogingendag / 24.0
pogingenmin = pogingenuur / 60.0
geslaagdjaar = 1854
geslaagddag = geslaagdjaar / 365.0
geslaagduur = geslaagddag /  24.0
geslaagdmin = geslaagduur / 60.0
counter = 0
startdate = "2012-09-13 00:00:00"
starttime = a_time(startdate)

bron = "https://www.113online.nl/informatie/113online%2B/cijfers-over-zelfmoord"
url = "http://pypi.python.org/pypi/apoclaim"
tags = ["#cda", "#pvda", "#d66", "#vvd", "#groenlinks", "#pvv", "#pvdd", "#ggznederland", "#igz", "#vws"]

prevpogingen = 0
prevgeslaagd = 0
lastpoging = 0
lastsuicide = 0

def campagne(*args, **kwargs):
    event = args[0]
    global counter, prevpogingen, prevgeslaagd, lastpoging, lastsuicide
    counter += 1
    timediff = time.time() - starttime
    aantalmin = timediff / 60.0
    pogingen = int(aantalmin * pogingenmin)
    geslaagd = int(aantalmin * geslaagdmin)
    time_diff = float(time.time() - starttime)
    days = elapsed_days(time_diff)
    tag = random.choice(tags)
    if pogingen > lastpoging:
        txt = "POGING nummer %s #apotheker #meds #ggz %s - %s (%s) %s/dag" % (pogingen, tag, url, days, int(pogingendag))
        kernel.announce(txt)
        lastpoging = pogingen
    tag = random.choice(tags)
    if geslaagd > lastsuicide:
        txt = "SUICIDE nummer %s #apotheker #meds #ggz %s - %s (%s) %s/dag" % (geslaagd, tag, url, days, int(geslaagddag)) 
        kernel.announce(txt)
        lastsuicide = geslaagd

kernel.cmnds.register("campagne", campagne)

## campagne init

def init(*args, **kwargs):
    global kernel
    camp = Looper(campagne, 300)
    kernel.run.campagne = camp
    #camp.start()
    kernel.workers.put(camp.start)
