# bot/plugs/mbox.py
#
#

""" mailbox input plugin. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import j, error, parse_email, short_date, ftime
from bard.object import Object
from bard.runtime import kernel

import email.message
import mailbox
import datetime
import logging
import email
import time
import os

## CMNDS

def mbox(event):
    try: fn = os.path.abspath(os.path.expanduser(event.parsed.args[0]))
    except: event.reply("mbox <file>") ; return
    nr = 0
    if os.path.isdir(fn): event.reply("a mbox file is needed.") ; return
    for m in mailbox.mbox(fn):
        o = Object()
        o.update(m.items())
        try: sdate = os.sep.join(short_date(o.Date).split())
        except AttributeError: sdate = None
        o.text = ""
        for load in m.walk():
            if load.get_content_type() == 'text/plain': o.text += load.get_payload()
        o.text = o.text.replace("\\n", "\n")
        o.prefix = "email"
        if sdate: o.save(sdate)
        else: o.save()
        nr += 1
    event.ok(nr)

kernel.ctrl.register("mbox", mbox)
