# bard/plugs/uptime.py
#
#

""" uptime of services. """

## IMPORTS

from bard.utils import elapsed_days, str_day, error
from bard.runtime import kernel

import time

## UNTIL

def until(obj): 
    try: return elapsed_days(int(obj.sleep) - int(time.time() - obj._last))
    except: return ""

def upt(obj):
    try: return elapsed_days(int(time.time()) - int(obj._started))
    except: return ""

def idle(obj):
    try: return elapsed_days(int(obj._last - obj._started))
    except: return ""

def status(obj):
    try: return obj._status
    except: return ""

def sleeptime(obj):
    try: return elapsed_days(obj.sleep)
    except: return ""

## CMNDS

def uptime(event):
    global kernel
    for service in sorted(kernel.run.names()):
        print(service)
        obj = kernel.run[service]
        if "sleep" in obj: event.reply("%s: %s %s (%s/%s)" % (service, status(obj), upt(obj), until(obj), elapsed_days(obj.sleep)))
        else: event.reply("%s: %s %s" % (service, status(obj), upt(obj)))

kernel.cmnds.register("uptime", uptime)
