#!/usr/bin/env python3
#
#

import os
import sys

if sys.version_info.major < 3: print("you need to run NODE with python3") ; os._exit(1)

try: use_setuptools()
except: pass

try:
    from setuptools import setup
except Exception as ex: print(str(ex)) ; os._exit(1)

from distutils import sysconfig
site_packages_path = sysconfig.get_python_lib()

setup(
    name='bard',
    version='4',
    url='https://pikacode.com/bthate/bard',
    author='Bart Thate',
    author_email='bthate@dds.nl',
    description='bots.',
    license='MIT',
    include_package_data=True,
    zip_safe=False,
    install_requires=["beautifulsoup4", "sleekxmpp", "feedparser"],
    scripts=["bin/bard", "bin/bard-local", "bin/bard-docs", "bin/bard-udp"],
    packages=['bard',
              'bard.service',
              'bard.contrib',
              'bard.plugs',
              'bard.bots',
             ],
    long_description = """  XMPP - IRC - CLI - RSS - UDP - API. """,
    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: MIT License',
        'Operating System :: Unix',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules'],
)
