# bard/bots/xmpp.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.object import Object
from bard.bot import Bot

from bard.defines import BLA, GREEN, ENDC, pfc
from bard.defaults import xmpp
from bard.utils import stripped

from bard.runtime import kernel

import threading
import logging
import getpass
import queue
import time

## XMPP

class XMPPBot(Bot):

    """ XMPP bot. """

    def __init__(zelf, *args, **kwargs):
        import sleekxmpp
        from sleekxmpp import clientxmpp
        Bot.__init__(zelf, *args, **kwargs)
        if "port" not in zelf: zelf.port = 5222
        zelf._queue = queue.Queue()
        zelf.xmpp = clientxmpp.ClientXMPP(zelf.user, getpass.getpass())
        zelf.xmpp.add_event_handler("session_start", zelf.session_start)
        zelf.xmpp.add_event_handler("message", zelf.handle_message)
        zelf.xmpp.add_event_handler('disconnected', zelf.handle_disconnected)
        zelf.xmpp.add_event_handler('connected', zelf.handle_connected)
        zelf.xmpp.add_event_handler('presence_available', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_dnd', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_xa', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_chat', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_away', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_unavailable', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_subscribe', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_subscribed', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_unsubscribe', zelf.handle_presence)
        zelf.xmpp.add_event_handler('presence_unsubscribed', zelf.handle_presence)
        zelf.xmpp.add_event_handler('groupchat_message', zelf.handle_message)
        zelf.xmpp.add_event_handler('groupchat_presence', zelf.handle_presence)
        zelf.xmpp.add_event_handler('groupchat_subject', zelf.handle_presence)
        zelf.xmpp.add_event_handler('failed_auth', zelf.handle_failedauth)
        zelf.xmpp.exception = zelf.exception
        zelf.xmpp.use_signals()
        zelf.openfire = kernel.cfg.openfire
        if zelf.openfire:
            logging.warn("! XMPP/enable openfire")
            import ssl
            zelf.xmpp.ssl_version = ssl.PROTOCOL_SSLv3
        zelf._connected = threading.Event()
        zelf.channels = []

    def _raw(zelf, *args, **kwargs):
        logging.info("> XMPP/raw %s" % args[0])
        zelf.xmpp.send_raw(args[0])

    def start(zelf, *args, **kwargs):
        zelf.connect()
        Bot.start(zelf, *args, **kwargs)

    def connect(zelf):
        logging.warn("! XMPP/connect %s" % zelf.server)
        try: zelf.xmpp.connect((zelf.server, zelf.port), use_ssl=zelf.openfire)
        except: zelf.xmpp.connect((zelf.server, zelf.port))

    def session_start(zelf, event):
        zelf.xmpp.send_presence()
        zelf.ready()
        logging.warn("! XMPP/session %s" % zelf.user)
         
    def exception(zelf, ex):
        zelf._status = ex
        logging.error("! XMPP/error %s"% str(ex))

    def announce(zelf, *args, **kwargs):
        for channel in zelf.channels: zelf.xmpp.send_message(channel, args[0])

    def handle_failedauth(zelf, error, *args, **kwargs): zelf._error = error ; logging.error("* XMPP/auth %s" % str(error))

    def handle_failure(zelf, error, *args, **kwargs): zelf._error = error ; logging.error("* XMPP/failure %s" % str(error))

    def handle_disconnected(zelf, *args, **kwargs):
        zelf._connected.clear()
        zelf._status = "disconnected"
        logging.error("! XMPP/disconnect %s" % zelf.user)

    def handle_connected(zelf, *args, **kwargs): 
        zelf._status = "running"
        zelf._connected.set()
        logging.warn("! XMPP/connected %s" % zelf.user)

    def loop(zelf, *args, **kwargs): zelf.xmpp.process(block=True)

    def say(zelf, *args, **kwargs):
        zelf.xmpp.send_message(args[0], args[1])
        logging.info("> XMPP/message %s %s" % (args[0], args[1]))

    def event(zelf, *args, **kwargs): return zelf._queue.get()

    def handle_message(zelf, data, *args, **kwargs):
        logging.info("< XMPP/raw %s" % data)
        m = Object(**data)
        if '<delay xmlns="urn:xmpp:delay"' in str(data):
            logging.warn("! XMPP/ignore %s %s" % (m.type, m.origin))
            return
        if m.type == "error": logging.error(m.error) ; return
        m["from"] = str(m["from"])
        m.origin = stripped(m["from"])
        m.channel = m.origin
        m.to = m.origin
        m.element = "message"
        m.txt = m["body"]
        m._target = zelf
        logging.warn("> XMPP/%s %s" % (m.type, m.origin))
        zelf._queue.put(m)

    def handle_presence(zelf, data, *args, **kwargs):
        logging.info("< XMPP/raw %s" % data)
        o = Object(data)
        o["from"] = stripped(str(o["from"]))
        o.origin = o["from"]
        o.element = "presence"
        if o.type == 'subscribe':
            pres = Object({'to': zelf["from"], 'type': 'subscribed'})
            o.xmpp.send_presence(pres)
            pres = Object({'to': zelf["from"], 'type': 'subscribe'})
            o.xmpp.send_presence(pres)
        else:
            if o.origin != zelf.user and o.origin not in zelf.channels: zelf.channels.append(o.origin)
        o.no_dispatch = True
        o._target = zelf
        logging.warn("> XMPP/%s %s" % (o.type, o.origin))
        zelf._queue.put(o)

    def exit(zelf, *args, **kwargs):
        zelf.xmpp.disconnect()
        Bot.exit(zelf)
        zelf._queue.put("blaet")
        
def init(*args, **kwargs):
    cfg = Object().last("cfg", "xmpp")
    if not cfg: cfg = xmpp ; cfg.save()
    bot = XMPPBot(**cfg) 
    kernel.run.xmpp = bot
    kernel.workers.put(bot.loop)   
    kernel.workers.put(bot.start)
