# bard/plugs/keys.py
#
#

""" show all attributes available. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.object import Object
from bard.runtime import kernel

import string
import time
import os

## CMNDS

def keys(event):
    rest = event.rest()
    result = []
    for obj in event.objects():
        if "added" not in obj: continue
        for key in obj.get_obj():
            if key not in result: result.append(key)
    args = rest.split()
    for arg in args:
        result = filter(lambda x: arg not in x, result)
    event.reply(" ".join(result))
    event.ok()

kernel.cmnds.register("keys", keys)
