# bard/bot.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import get_name, short_date, get_type
from bard.errors import RemoteDisconnect
from bard.dispatch import Dispatcher
from bard.defines import BLA, ENDC
from bard.object import Object
from bard.runtime import kernel, fleet

import logging
import socket
import time

## BOTS

class Bot(Dispatcher):

    """ Base Bot class. """

    def __init__(zelf, *args, **kwargs):
        Dispatcher.__init__(zelf, *args, **kwargs)
        zelf.channels = ["#bard", ]

    def say(zelf, *args, **kwargs): print(args[1])
        
    def announce(zelf, *args, **kwargs):
        """ announce on channels. """
        logging.info("announce %s" % " ".join(zelf.channels))
        for channel in zelf.channels: zelf.say(channel, args[0])

    def join(zelf, *args, **kwargs): pass
        
    ## CHANNELS

    def join_channels(zelf, *args, **kwargs):
        """ join channels.  """ 
        for channel in zelf.channels: zelf.join(channel)
            
## TESTBOT

class TestBot(Bot):

    """ USE WITH Bot.put() and Bot.read(). """

    testing = True

    def say(zelf, *args, **kwargs): logging.warn(args[1])

    def event(zelf, *args, **kwargs):
        o = Object()
        o.origin = "test@bard"
        o._target = zelf
        o.loglevel = "warning"
        return o
