# bard/runtime.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.defaults import kernel as cfg_kernel
from bard.utils import make_opts, hello
from bard.defines import opts_defs
from bard.plugins import Plugins
from bard.object import Object
from bard.log import init

import logging
import os

## RUNTIME

def boot():
    from bard.dispatch import Dispatcher
    opts, args = make_opts(opts_defs)
    cfg = Object()
    cfg.update(cfg_kernel)
    cfg.update(vars(opts))
    cfg.runargs = args
    kernel = Object()
    kernel.cfg = cfg
    kernel.plugs = Plugins()
    kernel.services = Plugins()
    kernel.bots = Plugins()
    kernel.cmnds = Dispatcher()
    kernel.ctrl = Dispatcher()
    kernel.workers = Dispatcher()
    kernel.run = Object()
    return kernel

## SHUTDOWN

def shutdown(*args, **kwargs):
    """ close the program in a appropiate manner. """
    if kernel.cfg.shell: print("") ; logging.warn("exit") 
    for item in ["workers", "ctrl", "cmnds", "bots"]:
        logging.warn("stop %s" % item)
        if "stop" in kernel.run: kernel.run[item].stop()
    os._exit(0)

## DEFINES

kernel = boot()
fleet = []
