# bard/defaults.py
#
#

""" default configurations. """

__copyright__ = "Copyright 2014 B.H.J Thate"

from bard.defines import homedir
from bard.object import Object
from bard.utils import j

import os
import os.path
import socket

## XMPP

xmpp = Object()
xmpp.server = "localhost"
xmpp.username = "bard"
xmpp.channel = "#bard"
xmpp.nick = "bard"
xmpp.cfg = "xmpp"
xmpp.user = "bard@localhost"

## IRC

irc = Object()
irc.server = "localhost"
irc.username = "bard"
irc.channel = "#bard"
irc.nick = "bard"
irc.cfg = "irc"

## KERNEL

kernel = Object()
kernel.debug = False
kernel.background = False
kernel.openfire = False
kernel.shell = False
kernel.init = ""
kernel.workdir = ""
kernel.loglevel = "error"
kernel.plugs = ["bard.bots", "bard.service", "bard.plugs"]
kernel.cfg = "kernel"

# UDP

udp = Object()
udp.cfg = "udp"
udp.host = "localhost"
udp.port = 5500
udp.password = "boh"
udp.seed = "blablablablablaz" # needs to be 16 chars wide

## API

api = Object()
api.cfg = "api"
api.hostname = socket.getfqdn()
api.port = 10102
