# bard/dispatch.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import get_plugname, get_name, get_strace, error
from bard.errors import NoFunction
from bard.object import Object

import collections
import threading
import logging
import threading
import random
import queue
import time

## DEFINES

threads = []

## RUNNER

class Runner(threading.Thread):

    """ the working unit of NODE.  """

    def __init__(zelf, *args, **kwargs):
        threading.Thread.__init__(zelf, None, zelf._loop, "Runner", args, kwargs)
        zelf.setDaemon(True)
        zelf.type = "Runner"
        zelf._queue = queue.Queue()
        zelf._ready = threading.Event() 
        zelf._status = "start"
        
    def _loop(zelf, *args, **kwargs):
        """ loop that executes the (function, object) pairs. """
        last = None
        while zelf._status:
            zelf._status = "running"
            try:
                args, kwargs = zelf._queue.get()
                zelf.clear()
                if not zelf._status: break
                func = args[0]
                if not func: raise NoFunction()
                try: arguments = args[1:] ; last = args[1]
                except IndexError: arguments = []
                name = get_name(func)
                zelf._status = name
                func(*arguments, **kwargs)
                logging.warn("# exec %s" % name)
                if arguments: event = arguments[0] ; last = event ; event.ready()
            except: error(last)
            if not zelf._queue.qsize(): break
        zelf.ready()
        return last

    def stop(zelf, *args, **kwargs):
        zelf._status = ""
        zelf.put("blah")
        
    def put(zelf, *args, **kwargs):
        """ put arguments/kwargs to the Runner. """
        zelf._queue.put((args, kwargs))
        return zelf

    ## WAITERS

    def ready(zelf):
        """ signal to ready state. """
        logging.debug("! %s/ready %s" % (zelf.type, get_name(zelf)))
        zelf._ready.set()

    def clear(zelf):
        """ clear the ready state. """
        logging.debug("! %s/clear %s" % (zelf.type, get_name(zelf)))
        zelf._ready.clear()

    def wait(zelf, sec=180.0):
        """ wait for ready state. """
        logging.debug("! %s/wait %s %s" % (zelf.type, get_name(zelf), get_strace()))
        try: zelf._ready.wait(sec)
        except: pass

## DISPATCH

class Dispatcher(Object):

    """ the dispatcher delegates the workload to the Runners. Runner gets instantiated when needed. """

    def __init__(zelf, *args, **kwargs):
        Object.__init__(zelf, *args, **kwargs)
        zelf._output = queue.Queue()
        zelf._ready = threading.Event()
        zelf._status = ""

    ## VIRTUAL

    def single(zelf, *args, **kwargs):
        from bard.runtime import kernel
        event = Object()
        event._target = zelf
        event.origin = "bard@shell"
        event.txt = " ".join(kernel.cfg.runargs)
        return zelf.once(event)
                
    def once(zelf, *args, **kwargs):
        from bard.runtime import kernel
        if args: event = args[0]
        else: event = zelf.event()
        if not event: return
        try: result = zelf.handle_event(event, kernel.cmnds)
        except KeyError: pass
        except Exception: error()
        zelf.collect(result)
        return result

    def handle_event(zelf, *args, **kwargs):
        from bard.runtime import kernel
        event = args[0]
        try: target = args[1]
        except IndexError: target = None
        command = event.check()
        if not command: return
        if not target: target = kernel.cmnds
        cmnds = target[command]
        result = []
        for cmnd in cmnds:
            o = zelf.put(cmnd.func, event)
            result.append(o)
        return result

    def collect(zelf, *args, **kwargs):
        result = args[0]
        if not result: return
        for event in result:
            if event: event.wait()

    def event(zelf, *args, **kwargs): pass
        
    ## PROCES

    def start(zelf, *args, **kwargs):
        logging.warn("# start %s" % zelf.type)
        zelf._status = "get"
        while zelf._status:
            try: result = zelf.once() ; zelf.collect(result)
            except (EOFError, KeyboardInterrupt): raise
            except: error()
        return result 

    def stop(zelf, *args, **kwargs): zelf._status = "" ; zelf.put(None)

    ## INPUT/OUTPUT

    def put(zelf, *args, **kwargs):
        runner = Runner(*args, **kwargs)
        runner.start()
        return runner.put(*args, **kwargs)
