# bard/plugs/ls.py
#
#

""" show available commands. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.runtime import kernel, fleet

## CMNDS

def ls(event):
    rest = event.rest()
    if not rest:
        res = ", ".join([x for x in sorted(list(kernel.names()) + ["fleet", ])])
        event.reply(res)
        return
    if rest == "fleet": event.reply(" ".join([bot.type for bot in fleet])) ; return
    obj = kernel
    keys = True
    for mod in rest.split("."):
       try: obj = getattr(obj, mod) 
       except AttributeError: pass
    if not obj: return
    try: res = ", ".join(obj.names()).strip()
    except AttributeError: res = obj.names()
    if res: event.reply(res.strip())
 
kernel.cmnds.register("ls", ls)
