# bard/errors.py
#
#

""" exceptions package. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## ERRORS

class Error(BaseException):
    """ basic Exception used in the program. """
    pass


class TestException(Error):
    """ test exception. """
    pass

class StopIter(Error):
    """ stop the iteration. """
    pass

class NotImplemented(Error):
    """ method is not implemented. """
    pass

class NoFunction(Error):
    """ No function could be found. """
    pass

class NoEvent(Error):
    """ No event is returned. """
    pass

class NoWorkdirSet(BaseException):
    """ a working directory is needed. """
    pass

class Overload(Error):
    """ method is trying to be overloaded. """
    pass

class AttributeSet(Error):
    """ attribute is already set. """
    pass

class DataNotSet(Error):
    """ missing argument attribute. """
    pass

class NoTarget(Error):
    """ missing argument attribute. """
    pass

class NoJSON(Error):
    """ no JSON could be decoded/encoded. """
    pass

class RemoteDisconnect(Error):
    """ Exception thrown when the connection is disconnected. """
    pass

class NotSet(Error):
    """ attribute is not set. """
    pass

class FileNotFoundError(Error):
    """ file is not found. """
    pass
