# bard/plugs.py
#
#

""" Plugins package, loads all plugins available. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.dispatch import Dispatcher
from bard.object import Object
from bard.utils import error

import importlib
import logging
import pkgutil

## PLUGINS

class Plugins(Object):

    """ object to register plugins with. """

    def load(zelf, modname):
        """ load plugins from the plugin directory. """
        logging.warn("! load %s" % modname)
        mod = zelf.load_mod(modname)
        for pkg in pkgutil.walk_packages(mod.__path__, mod.__name__+'.'):
            name = pkg[1]
            zelf[name] = zelf.load_mod(name)

    def init(zelf, mods):
        modnames = mods.split(",")
        if "xmpp" in modnames and "xmpp" in zelf: zelf["xmpp"].init()
        for name in modnames:   
            if not name or name not in zelf: continue
            if name == "xmpp": continue
            logging.warn("! init %s" % name)
            try: zelf.workers.put(zelf[name].init)   
            except: error()    

    def load_mod(zelf, name, force=True):
        """ load module. """
        logging.info("# module %s" % name)
        if name in zelf and not force: mod = zelf.reload(name)
        else: mod = importlib.import_module(name)
        return mod

    def reload(zelf, *args, **kwargs):
        name = args[0]
        zelf[name] = importlib.reload(zelf[name])
        return zelf[name]
