# bard/plugs/stop.py
#
#

""" regen, regen. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.runtime import kernel, fleet

import logging

## CMNDS

def stop(event):
    rest = event.rest()
    if not rest: return
    todo = []
    for item in kernel.services:
        if item == rest:
            logging.info("stop %s" % rest)
            kernel.workers.put(kernel.services[rest].exit)
            todo.append(rest)
    for item in fleet:
        if item.type == rest:
            logging.info("stop %s" % rest)
            kernel.workers.put(kernel.plugs[rest].exit)
            todo.append(rest)
    for item in todo: del kernel.services[item]
    event.ok(", ".join(todo))

kernel.cmnds.register("stop", stop)
