# bard/dispatch.py
#
#

""" basic package for the program. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import get_plugname, get_named, get_strace, error
from bard.errors import NoFunction, NoEvent
from bard.object import Object

import collections
import threading
import logging
import threading
import random
import queue
import time

## DEFINES

threads = []

## RUNNER

class Runner(threading.Thread):

    """ the working unit of BARD.  """

    def __init__(zelf, *args, **kwargs):
        threading.Thread.__init__(zelf, None, zelf._loop, "Runner", args, kwargs)
        zelf.setDaemon(True)
        zelf.type = "Runner"
        zelf._queue = queue.Queue()
        zelf._ready = threading.Event() 
        zelf._status = "start"
        zelf._running = ""
        zelf._start = time.time()
        
    def _loop(zelf, *args, **kwargs):
        """ loop that executes the (function, object) pairs. """
        last = None
        zelf._status = "wait"
        while zelf._status:
            try:
                zelf._status = "blocking"
                args, kwargs = zelf._queue.get()
                if not args or not args[0]: break
                zelf.clear()
                func = args[0]
                try: arguments = args[1:] ; last = args[1]
                except IndexError: arguments = []
                zelf._running = get_named(func)
                zelf._status = "exec"
                func(*arguments, **kwargs)
                logging.info("# exec %s" % zelf._running)
                if arguments: event = arguments[0] ; last = event ; event.ready()
            except: error(last)
            if not zelf._queue.qsize(): break
        zelf.ready()
        return last

    def stop(zelf, *args, **kwargs): zelf.put(None)
        
    def put(zelf, *args, **kwargs):
        """ put arguments/kwargs to the Runner. """
        zelf._queue.put((args, kwargs))
        return zelf

    ## WAITERS

    def ready(zelf):
        """ signal to ready state. """
        logging.debug("! %s/ready %s" % (zelf.type, str(zelf._ready)))
        zelf._ready.set()

    def clear(zelf):
        """ clear the ready state. """
        logging.debug("! %s/clear %s" % (zelf.type, str(zelf._ready)))
        zelf._ready.clear()

    def wait(zelf, sec=180.0):
        """ wait for ready state. """
        logging.debug("! %s/wait %s" % (zelf.type, str(zelf._ready)))
        try: zelf._ready.wait(sec)
        except: pass

## DISPATCH

class Dispatcher(Object):

    """ the dispatcher delegates the workload to the Runners. Runner gets instantiated when needed. """

    def __init__(zelf, *args, **kwargs):
        Object.__init__(zelf, *args, **kwargs)
        zelf._output = queue.Queue()
        zelf._ready = threading.Event()
        zelf._status = ""

    ## EVENT

    def event(zelf, *args, **kwargs): pass
        
    ## PROCES

    def start(zelf, *args, **kwargs):
        logging.warn("# start %s" % zelf.type)
        zelf._status = "get"
        while zelf._status:
            try: zelf.handle_event(zelf.event())
            except (EOFError, KeyboardInterrupt): raise
            except: error()

    def stop(zelf, *args, **kwargs): zelf._status = "" ; zelf.put(None)

    ## INPUT/OUTPUT

    def put(zelf, *args, **kwargs):
        runner = Runner(*args, **kwargs)
        runner.start()
        return runner.put(*args, **kwargs)

    ## DISPATCHING

    def single(zelf, *args, **kwargs):
        if not args[0]: return
        event = Object()
        event._target = zelf
        event.origin = "bard@shell"
        event.txt = args[0]
        return zelf.handle_event(event)
                
    def handle_event(zelf, *args, **kwargs):
        event = args[0]
        if "txt" not in event or not event.txt: return []
        result = zelf.handle_cmnd(event)
        zelf.collect(result)
        return result

    def handle_cmnd(zelf, *args, **kwargs):
        from bard.runtime import kernel
        event = args[0]
        cmnd = event.txt.split()[0]
        if "cc" in event:    
            if cmnd.startswith(event.cc): cmnd = cmnd[1:]
            else: return
        try: cmnds = kernel.cmnds[cmnd]
        except KeyError: cmnds = []
        result = []
        for cmnd in cmnds:  
            o = zelf.put(cmnd.func, event)
            result.append(o)
        return result

    ## RESULTS

    def collect(zelf, *args, **kwargs):
        result = args[0]
        if not result: return
        for event in result:
            if event: event.wait()
