# bard/looper.py
#
#

""" time related functionality. """

__copyright__ = "Copyright 2014 B.H.J Thate"

## IMPORTS

from bard.utils import error, get_named
from bard.object import Object
from bard.runtime import kernel, fleet

import threading
import logging
import time

# TIMER

class Timer(Object):

    def __init__(zelf, time_alarm, event, *args, **kwargs):
        Object.__init__(zelf, *args, **kwargs)
        zelf.sleep = time_alarm - time.time()
        zelf._start = time.time()
        zelf._timer = threading.Timer(zelf.sleep, zelf.echo)
        zelf._status = "start"
        zelf._last = time.time()
        zelf._running = "timer"
        zelf._event = event

    def start(zelf, *args, **kwargs):
        zelf._started = time.time()
        zelf._timer.start()
        zelf._status = "running"
        
    def echo(zelf, *args, **kwargs):
        for bot in fleet: bot.announce(zelf._event.rest())
        
## LOOPS

class Looper(Object):

    """ a Looper calls a function every x seconds. """ 

    def __init__(zelf, func, sleeptime, *args, **kwargs):
        """ args = function, sleeptime. """
        Object.__init__(zelf, *args, **kwargs)
        zelf._func = func
        zelf._start = time.time()
        zelf._last = time.time()
        zelf._status = "start"
        zelf._running = get_named(zelf._func)
        zelf.sleep = sleeptime

    def start(zelf, *args, **kwargs):
        """ initialize a Looper. """
        zelf._status = "running"
        while zelf._status:
            zelf._last = time.time()
            try: zelf._func()
            except: error()
            time.sleep(zelf.sleep)

    def exit(zelf, *args, **kwargs): zelf._status = ""

